/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Platform4;
import com.db4o.YapObject;
import com.db4o.YapObjectCarrier;
import com.db4o.YapStream;
import com.db4o.foundation.SimpleTimer;

class YapReferences
implements Runnable {
    final Object _queue;
    private final YapStream _stream;
    private SimpleTimer _timer;
    public final boolean _weak;

    YapReferences(YapStream yapStream) {
        this._stream = yapStream;
        this._weak = !(yapStream instanceof YapObjectCarrier) && Platform4.hasWeakReferences() && yapStream.i_config.weakReferences();
        this._queue = this._weak ? Platform4.createReferenceQueue() : null;
    }

    Object createYapRef(YapObject yapObject, Object object) {
        if (!this._weak) {
            return object;
        }
        return Platform4.createYapRef(this._queue, yapObject, object);
    }

    void pollReferenceQueue() {
        if (this._weak) {
            Platform4.pollReferenceQueue(this._stream, this._queue);
        }
    }

    public void run() {
        this.pollReferenceQueue();
    }

    void startTimer() {
        if (!this._weak) {
            return;
        }
        if (!this._stream.i_config.weakReferences()) {
            return;
        }
        if (this._stream.i_config.weakReferenceCollectionInterval() <= 0) {
            return;
        }
        if (this._timer != null) {
            return;
        }
        this._timer = new SimpleTimer(this, this._stream.i_config.weakReferenceCollectionInterval(), "db4o WeakReference collector");
    }

    void stopTimer() {
        if (this._timer == null) {
            return;
        }
        this._timer.stop();
        this._timer = null;
    }
}

