/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Platform4;
import com.db4o.Transaction;
import com.db4o.YInt;
import com.db4o.YLong;
import com.db4o.YapFile;
import com.db4o.YapStringIO;
import com.db4o.YapWriter;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.foundation.Cool;
import com.db4o.inside.Exceptions4;
import com.db4o.inside.freespace.FreespaceManager;
import java.io.IOException;

public final class YapConfigBlock
implements Runnable {
    private final Object _timeWriterLock = new Object();
    private final YapFile _stream;
    int _address;
    private Transaction _transactionToCommit;
    int _bootRecordID;
    private static final int POINTER_ADDRESS = 2;
    private static final int MINIMUM_LENGTH = 21;
    static final int OPEN_TIME_OFFSET = 4;
    static final int ACCESS_TIME_OFFSET = 12;
    static final int TRANSACTION_OFFSET = 21;
    private static final int BOOTRECORD_OFFSET = 29;
    private static final int INT_FORMERLY_KNOWN_AS_BLOCK_OFFSET = 33;
    private static final int ENCRYPTION_PASSWORD_LENGTH = 5;
    private static final int PASSWORD_OFFSET = 38;
    private static final int FREESPACE_SYSTEM_OFFSET = 39;
    private static final int FREESPACE_ADDRESS_OFFSET = 43;
    private static final int CONVERTER_VERSION_OFFSET = 47;
    private static final int LENGTH = 51;
    private final long _opentime;
    byte _encoding;
    byte _freespaceSystem;
    int _freespaceAddress;
    private int _converterVersion;

    YapConfigBlock(YapFile yapFile) {
        this._stream = yapFile;
        this._encoding = yapFile.i_config.encoding();
        this._freespaceSystem = FreespaceManager.checkType(yapFile.i_config.freespaceSystem());
        this._opentime = YapConfigBlock.processID();
        if (this.lockFile()) {
            this.writeHeaderLock();
        }
    }

    Transaction getTransactionToCommit() {
        return this._transactionToCommit;
    }

    private void ensureFreespaceSlot() {
        if (this._freespaceAddress == 0) {
            this.newFreespaceSlot(this._freespaceSystem);
        }
    }

    public int newFreespaceSlot(byte by) {
        this._freespaceAddress = FreespaceManager.initSlot(this._stream);
        this._freespaceSystem = by;
        return this._freespaceAddress;
    }

    void go() {
        this._stream.createStringIO(this._encoding);
        if (this.lockFile()) {
            try {
                this.writeAccessTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.syncFiles();
            this.openTimeOverWritten();
            new Thread(this).start();
        }
    }

    private YapWriter headerLockIO() {
        YapWriter yapWriter = this._stream.getWriter(this._stream.getTransaction(), 0, 4);
        yapWriter.moveForward(6);
        return yapWriter;
    }

    private void headerLockOverwritten() {
        if (this.lockFile()) {
            YapWriter yapWriter = this.headerLockIO();
            yapWriter.read();
            if (YInt.readInt(yapWriter) != (int)this._opentime) {
                throw new DatabaseFileLockedException();
            }
            this.writeHeaderLock();
        }
    }

    private boolean lockFile() {
        return this._stream.needsLockFileThread();
    }

    private YapWriter openTimeIO() {
        YapWriter yapWriter = this._stream.getWriter(this._stream.getTransaction(), this._address, 8);
        yapWriter.moveForward(4);
        return yapWriter;
    }

    private void openTimeOverWritten() {
        if (this.lockFile()) {
            YapWriter yapWriter = this.openTimeIO();
            yapWriter.read();
            if (YLong.readLong(yapWriter) != this._opentime) {
                Exceptions4.throwRuntimeException(22);
            }
            this.writeOpenTime();
        }
    }

    private byte[] passwordToken() {
        byte[] byArray = new byte[5];
        String string = this._stream.i_config.password();
        if (this._stream.i_config.encrypt() && string != null) {
            try {
                byte[] byArray2 = new YapStringIO().write(string);
                YapWriter yapWriter = new YapWriter(this._stream.i_trans, byArray2.length + 5);
                yapWriter.append(byArray2);
                yapWriter.append(new byte[5]);
                this._stream.i_handlers.decrypt(yapWriter);
                System.arraycopy(yapWriter._buffer, 0, byArray, 0, 5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    static long processID() {
        long l = System.currentTimeMillis();
        return l;
    }

    void read(int n) {
        int n2;
        this._address = n;
        this.writeOpenTime();
        YapWriter yapWriter = this._stream.getWriter(this._stream.getSystemTransaction(), this._address, 51);
        try {
            this._stream.readBytes(yapWriter._buffer, this._address, 51);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = yapWriter.readInt();
        if (n3 > 51 || n3 < 21) {
            Exceptions4.throwRuntimeException(17);
        }
        if (n3 != 51 && !this._stream.i_config.isReadOnly() && !this._stream.i_config.allowVersionUpdates()) {
            if (this._stream.i_config.automaticShutDown()) {
                Platform4.removeShutDownHook(this._stream, this._stream.i_lock);
            }
            Exceptions4.throwRuntimeException(65);
        }
        long l = YLong.readLong(yapWriter);
        long l2 = YLong.readLong(yapWriter);
        this._encoding = yapWriter.readByte();
        if (n3 > 21) {
            int n4 = YInt.readInt(yapWriter);
            n2 = YInt.readInt(yapWriter);
            if (n4 > 0 && n4 == n2) {
                this._transactionToCommit = new Transaction(this._stream, null);
                this._transactionToCommit.setAddress(n4);
            }
        }
        if (n3 > 29) {
            this._bootRecordID = YInt.readInt(yapWriter);
        }
        if (n3 > 33) {
            YInt.readInt(yapWriter);
        }
        if (n3 > 38) {
            byte[] byArray = yapWriter.readBytes(5);
            n2 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 0) continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                this._stream.i_handlers.oldEncryptionOff();
            } else {
                byte[] byArray2 = this.passwordToken();
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] == byArray[i]) continue;
                    this._stream.fatalException(54);
                }
            }
        }
        this._freespaceSystem = 1;
        if (n3 > 39) {
            this._freespaceSystem = yapWriter.readByte();
        }
        if (n3 > 43) {
            this._freespaceAddress = yapWriter.readInt();
        }
        if (n3 > 47) {
            this._converterVersion = yapWriter.readInt();
        }
        this.ensureFreespaceSlot();
        if (this.lockFile() && l2 != 0L) {
            this._stream.logMsg(28, null);
            long l3 = 10000L;
            long l4 = System.currentTimeMillis();
            while (System.currentTimeMillis() < l4 + l3) {
                Cool.sleepIgnoringInterruption(l3);
            }
            yapWriter = this._stream.getWriter(this._stream.getSystemTransaction(), this._address, 16);
            yapWriter.moveForward(4);
            yapWriter.read();
            long l5 = YLong.readLong(yapWriter);
            long l6 = YLong.readLong(yapWriter);
            if (l6 > l2) {
                throw new DatabaseFileLockedException();
            }
        }
        if (this.lockFile()) {
            Cool.sleepIgnoringInterruption(100L);
            this.syncFiles();
            this.openTimeOverWritten();
        }
        if (n3 < 51) {
            this.write();
        }
        this.go();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        thread.setName("db4o file lock");
        try {
            while (this.writeAccessTime()) {
                Cool.sleepIgnoringInterruption(1000L);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void converterVersion(int n) {
        this._converterVersion = n;
    }

    public int converterVersion() {
        return this._converterVersion;
    }

    void syncFiles() {
        this._stream.syncFiles();
    }

    public void write() {
        this.headerLockOverwritten();
        this._address = this._stream.getSlot(51);
        YapWriter yapWriter = this._stream.getWriter(this._stream.i_trans, this._address, 51);
        YInt.writeInt(51, yapWriter);
        YLong.writeLong(this._opentime, yapWriter);
        YLong.writeLong(this._opentime, yapWriter);
        yapWriter.append(this._encoding);
        YInt.writeInt(0, yapWriter);
        YInt.writeInt(0, yapWriter);
        YInt.writeInt(this._bootRecordID, yapWriter);
        YInt.writeInt(0, yapWriter);
        yapWriter.append(this.passwordToken());
        yapWriter.append(this._freespaceSystem);
        this.ensureFreespaceSlot();
        YInt.writeInt(this._freespaceAddress, yapWriter);
        YInt.writeInt(this._converterVersion, yapWriter);
        yapWriter.write();
        this.writePointer();
    }

    boolean writeAccessTime() throws IOException {
        return this._stream.writeAccessTime();
    }

    private void writeOpenTime() {
        if (this.lockFile()) {
            YapWriter yapWriter = this.openTimeIO();
            YLong.writeLong(this._opentime, yapWriter);
            yapWriter.write();
        }
    }

    private void writeHeaderLock() {
        if (this.lockFile()) {
            YapWriter yapWriter = this.headerLockIO();
            YInt.writeInt((int)this._opentime, yapWriter);
            yapWriter.write();
        }
    }

    private void writePointer() {
        this.headerLockOverwritten();
        YapWriter yapWriter = this._stream.getWriter(this._stream.i_trans, 0, 4);
        yapWriter.moveForward(2);
        YInt.writeInt(this._address, yapWriter);
        yapWriter.write();
        this.writeHeaderLock();
    }
}

