/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Msg;
import com.db4o.YapClient;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Lock4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.network.YapSocket;

class YapClientThread
extends Thread {
    private YapClient i_stream;
    private YapSocket i_socket;
    final Queue4 messageQueue;
    final Lock4 messageQueueLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YapClientThread(YapClient yapClient, YapSocket yapSocket, Queue4 queue4, Lock4 lock4) {
        YapClientThread yapClientThread = this;
        synchronized (yapClientThread) {
            this.i_stream = yapClient;
            this.messageQueue = queue4;
            this.i_socket = yapSocket;
            this.messageQueueLock = lock4;
        }
    }

    synchronized boolean isClosed() {
        return this.i_socket == null;
    }

    synchronized void close() {
        this.i_stream = null;
        this.i_socket = null;
    }

    public void run() {
        while (this.i_socket != null) {
            try {
                Msg msg;
                if (this.i_stream == null) {
                    return;
                }
                try {
                    msg = Msg.readMessage(this.i_stream.getTransaction(), this.i_socket);
                }
                catch (Exception exception) {
                    this.messageQueueLock.run(new Closure4(){

                        public Object run() {
                            YapClientThread.this.messageQueue.add(Msg.ERROR);
                            YapClientThread.this.close();
                            YapClientThread.this.messageQueueLock.awake();
                            return null;
                        }
                    });
                    this.close();
                    return;
                }
                if (this.i_stream == null) {
                    return;
                }
                if (Msg.PING.equals(msg)) {
                    this.i_stream.writeMsg(Msg.OK);
                    continue;
                }
                if (Msg.CLOSE.equals(msg)) {
                    this.i_stream.logMsg(35, this.i_stream.toString());
                    if (this.i_stream == null) {
                        return;
                    }
                    this.i_stream = null;
                    this.i_socket = null;
                    continue;
                }
                this.messageQueueLock.run(new Closure4(){

                    public Object run() {
                        YapClientThread.this.messageQueue.add(msg);
                        YapClientThread.this.messageQueueLock.awake();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                this.close();
                return;
            }
        }
    }
}

