/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.ClassIndex;
import com.db4o.ClassIndexClient;
import com.db4o.Config4Impl;
import com.db4o.Messages;
import com.db4o.Msg;
import com.db4o.MsgBlob;
import com.db4o.MsgD;
import com.db4o.MsgObject;
import com.db4o.PBootRecord;
import com.db4o.Platform4;
import com.db4o.QQuery;
import com.db4o.QResultClient;
import com.db4o.QueryResultImpl;
import com.db4o.Transaction;
import com.db4o.TransactionClient;
import com.db4o.UseSystemTransaction;
import com.db4o.YapClass;
import com.db4o.YapClientBlobThread;
import com.db4o.YapClientThread;
import com.db4o.YapMeta;
import com.db4o.YapObject;
import com.db4o.YapReader;
import com.db4o.YapStream;
import com.db4o.YapStringIOUnicode;
import com.db4o.YapWriter;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oException;
import com.db4o.ext.ExtClient;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Lock4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.network.YapSocket;
import com.db4o.foundation.network.YapSocketFake;
import com.db4o.inside.Exceptions4;
import com.db4o.reflect.ReflectClass;
import java.io.IOException;

public class YapClient
extends YapStream
implements ExtClient {
    final Object blobLock = new Object();
    private YapClientBlobThread blobThread;
    private YapSocket i_socket;
    Queue4 messageQueue = new Queue4();
    final Lock4 messageQueueLock = new Lock4();
    private String password;
    int[] prefetchedIDs = new int[10];
    private YapClientThread _readerThread;
    int remainingIDs;
    private String switchedToFile;
    private boolean _singleThreaded;
    private String userName;
    private Db4oDatabase i_db;
    private boolean _doFinalize = true;
    private byte _blockSize = 1;

    private YapClient() {
        super(null);
    }

    public YapClient(String string) {
        this();
        Object object = this.lock();
        synchronized (object) {
            this._singleThreaded = this.i_config.singleThreadedClient();
            throw new RuntimeException("This constructor is for Debug.fakeServer use only.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YapClient(YapSocket yapSocket, String string, String string2, boolean bl) throws IOException {
        this();
        Object object = this.lock();
        synchronized (object) {
            this._singleThreaded = this.i_config.singleThreadedClient();
            if (string2 == null) {
                throw new NullPointerException(Messages.get(56));
            }
            if (!bl) {
                string2 = null;
            }
            this.userName = string;
            this.password = string2;
            this.i_socket = yapSocket;
            try {
                this.loginToServer(yapSocket);
            }
            catch (IOException iOException) {
                this.i_references.stopTimer();
                throw iOException;
            }
            if (!this._singleThreaded) {
                this.startReaderThread(yapSocket, string);
            }
            this.logMsg(36, this.toString());
            this.readThis();
            this.initialize3();
            Platform4.postOpen(this);
        }
    }

    private void startReaderThread(YapSocket yapSocket, String string) {
        this._readerThread = new YapClientThread(this, yapSocket, this.messageQueue, this.messageQueueLock);
        this._readerThread.setName("db4o message client for user " + string);
        this._readerThread.start();
    }

    public void backup(String string) throws IOException {
        Exceptions4.throwRuntimeException(60);
    }

    public byte blockSize() {
        return this._blockSize;
    }

    public PBootRecord bootRecord() {
        return null;
    }

    boolean close2() {
        if (null != this._readerThread && this._readerThread.isClosed()) {
            return true;
        }
        try {
            Msg.COMMIT_OK.write(this, this.i_socket);
            this.expectedResponse(Msg.OK);
        }
        catch (Exception exception) {
            Exceptions4.catchAll(exception);
        }
        try {
            Msg.CLOSE.write(this, this.i_socket);
        }
        catch (Exception exception) {
            Exceptions4.catchAll(exception);
        }
        try {
            if (!this._singleThreaded) {
                this._readerThread.close();
            }
        }
        catch (Exception exception) {
            Exceptions4.catchAll(exception);
        }
        try {
            this.i_socket.close();
        }
        catch (Exception exception) {
            Exceptions4.catchAll(exception);
        }
        boolean bl = super.close2();
        return bl;
    }

    final void commit1() {
        this.i_trans.commit();
    }

    final ClassIndex createClassIndex(YapClass yapClass) {
        return new ClassIndexClient(yapClass);
    }

    YapSocket createParalellSocket() throws IOException {
        Msg.GET_THREAD_ID.write(this, this.i_socket);
        int n = this.expectedByteResponse(Msg.ID_LIST).readInt();
        YapSocket yapSocket = this.i_socket.openParalellSocket();
        if (!(this.i_socket instanceof YapSocketFake)) {
            this.loginToServer(yapSocket);
        }
        if (this.switchedToFile != null) {
            MsgD msgD = Msg.SWITCH_TO_FILE.getWriterForString(this.i_systemTrans, this.switchedToFile);
            msgD.write(this, yapSocket);
            if (!Msg.OK.equals(Msg.readMessage(this.i_systemTrans, yapSocket))) {
                throw new IOException(Messages.get(42));
            }
        }
        Msg.USE_TRANSACTION.getWriterForInt(this.i_trans, n).write(this, yapSocket);
        return yapSocket;
    }

    final QueryResultImpl createQResult(Transaction transaction) {
        return new QResultClient(transaction);
    }

    final void createTransaction() {
        this.i_systemTrans = new TransactionClient(this, null);
        this.i_trans = new TransactionClient(this, this.i_systemTrans);
    }

    boolean createYapClass(YapClass yapClass, ReflectClass reflectClass, YapClass yapClass2) {
        this.writeMsg(Msg.CREATE_CLASS.getWriterForString(this.i_systemTrans, reflectClass.getName()));
        Msg msg = this.getResponse();
        if (msg == null) {
            return false;
        }
        if (msg.equals(Msg.FAILED)) {
            if (this.i_config.exceptionsOnNotStorable()) {
                throw new ObjectNotStorableException(reflectClass);
            }
            return false;
        }
        if (!msg.equals(Msg.OBJECT_TO_CLIENT)) {
            return false;
        }
        MsgObject msgObject = (MsgObject)msg;
        YapWriter yapWriter = msgObject.unmarshall();
        if (yapWriter == null) {
            return false;
        }
        yapWriter.setTransaction(this.getSystemTransaction());
        if (!super.createYapClass(yapClass, reflectClass, yapClass2)) {
            return false;
        }
        yapClass.setID(msgObject._id);
        yapClass.readName1(this.getSystemTransaction(), yapWriter);
        this.i_classCollection.addYapClass(yapClass);
        this.i_classCollection.readYapClass(yapClass, reflectClass);
        return true;
    }

    long currentVersion() {
        this.writeMsg(Msg.CURRENT_VERSION);
        return ((MsgD)this.expectedResponse(Msg.ID_LIST)).readLong();
    }

    final boolean delete5(Transaction transaction, YapObject yapObject, int n, boolean bl) {
        this.writeMsg(Msg.DELETE.getWriterForInts(this.i_trans, new int[]{yapObject.getID(), bl ? 1 : 0}));
        return true;
    }

    boolean detectSchemaChanges() {
        return false;
    }

    protected boolean doFinalize() {
        return this._doFinalize;
    }

    final YapWriter expectedByteResponse(Msg msg) {
        Msg msg2 = this.expectedResponse(msg);
        if (msg2 == null) {
            return null;
        }
        return msg2.getByteLoad();
    }

    final Msg expectedResponse(Msg msg) {
        Msg msg2 = this.getResponse();
        if (msg.equals(msg2)) {
            return msg2;
        }
        return null;
    }

    final void free(int n, int n2) {
        throw Exceptions4.virtualException();
    }

    void getAll(Transaction transaction, QueryResultImpl queryResultImpl) {
        this.writeMsg(Msg.GET_ALL);
        this.readResult(queryResultImpl);
    }

    Msg getResponse() {
        return this._singleThreaded ? this.getResponseSingleThreaded() : this.getResponseMultiThreaded();
    }

    private Msg getResponseMultiThreaded() {
        try {
            return (Msg)this.messageQueueLock.run(new Closure4(){

                public Object run() {
                    Msg msg = this.retrieveMessage();
                    if (msg != null) {
                        return msg;
                    }
                    this.throwOnClosed();
                    YapClient.this.messageQueueLock.snooze(YapClient.this.i_config.timeoutClientSocket());
                    this.throwOnClosed();
                    return this.retrieveMessage();
                }

                private void throwOnClosed() {
                    if (YapClient.this._readerThread.isClosed()) {
                        YapClient.this._doFinalize = false;
                        Exceptions4.throwRuntimeException(20, YapClient.this.name());
                    }
                }

                private Msg retrieveMessage() {
                    Msg msg = null;
                    msg = (Msg)YapClient.this.messageQueue.next();
                    if (msg != null && Msg.ERROR.equals(msg)) {
                        throw new Db4oException("Client connection error");
                    }
                    return msg;
                }
            });
        }
        catch (Exception exception) {
            Exceptions4.catchAll(exception);
            return null;
        }
    }

    private Msg getResponseSingleThreaded() {
        while (this.i_socket != null) {
            try {
                Msg msg = Msg.readMessage(this.i_trans, this.i_socket);
                if (Msg.PING.equals(msg)) {
                    this.writeMsg(Msg.OK);
                    continue;
                }
                if (Msg.CLOSE.equals(msg)) {
                    this.logMsg(35, this.toString());
                    this.close();
                    return null;
                }
                if (msg == null) continue;
                return msg;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public YapClass getYapClass(int n) {
        ReflectClass reflectClass;
        YapClass yapClass = super.getYapClass(n);
        if (yapClass != null) {
            return yapClass;
        }
        this.writeMsg(Msg.CLASS_NAME_FOR_ID.getWriterForInt(this.i_systemTrans, n));
        MsgD msgD = (MsgD)this.expectedResponse(Msg.CLASS_NAME_FOR_ID);
        String string = msgD.readString();
        if (string != null && string.length() > 0 && (reflectClass = this.reflector().forName(string)) != null) {
            return this.getYapClass(reflectClass, true);
        }
        return null;
    }

    boolean needsLockFileThread() {
        return false;
    }

    boolean hasShutDownHook() {
        return false;
    }

    public Db4oDatabase identity() {
        if (this.i_db == null) {
            this.writeMsg(Msg.IDENTITY);
            YapWriter yapWriter = this.expectedByteResponse(Msg.ID_LIST);
            this.showInternalClasses(true);
            this.i_db = (Db4oDatabase)this.getByID(yapWriter.readInt());
            this.activate1(this.i_systemTrans, this.i_db, 3);
            this.showInternalClasses(false);
        }
        return this.i_db;
    }

    public boolean isClient() {
        return true;
    }

    void loginToServer(YapSocket yapSocket) throws IOException {
        if (this.password != null) {
            YapStringIOUnicode yapStringIOUnicode = new YapStringIOUnicode();
            int n = yapStringIOUnicode.length(this.userName) + yapStringIOUnicode.length(this.password);
            MsgD msgD = Msg.LOGIN.getWriterForLength(this.i_systemTrans, n);
            msgD.writeString(this.userName);
            msgD.writeString(this.password);
            msgD.write(this, yapSocket);
            Msg msg = Msg.readMessage(this.i_systemTrans, yapSocket);
            if (!Msg.LOGIN_OK.equals(msg)) {
                throw new IOException(Messages.get(42));
            }
            YapWriter yapWriter = msg.getPayLoad();
            this._blockSize = (byte)yapWriter.readInt();
            int n2 = yapWriter.readInt();
            if (n2 == 0) {
                this.i_handlers.oldEncryptionOff();
            }
        }
    }

    boolean maintainsIndices() {
        return false;
    }

    public final int newUserObject() {
        YapWriter yapWriter = null;
        if (this.remainingIDs < 1) {
            this.writeMsg(Msg.PREFETCH_IDS);
            yapWriter = this.expectedByteResponse(Msg.ID_LIST);
            for (int i = 9; i >= 0; --i) {
                this.prefetchedIDs[i] = yapWriter.readInt();
            }
            this.remainingIDs = 10;
        }
        --this.remainingIDs;
        return this.prefetchedIDs[this.remainingIDs];
    }

    int prefetchObjects(QResultClient qResultClient, Object[] objectArray, int n) {
        Object object;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        while (qResultClient.hasNext() && n3 < n) {
            boolean bl = false;
            n2 = qResultClient.nextInt();
            if (n2 <= 0) continue;
            YapObject yapObject = this.getYapObject(n2);
            if (yapObject != null) {
                object = yapObject.getObject();
                if (object != null) {
                    objectArray[n3] = object;
                    bl = true;
                } else {
                    this.yapObjectGCd(yapObject);
                }
            }
            if (!bl) {
                nArray[n4] = n2;
                nArray2[n4] = n3;
                ++n4;
            }
            ++n3;
        }
        if (n4 > 0) {
            this.writeMsg(Msg.READ_MULTIPLE_OBJECTS.getWriterForIntArray(this.i_trans, nArray, n4));
            MsgD msgD = (MsgD)this.expectedResponse(Msg.READ_MULTIPLE_OBJECTS);
            n2 = msgD.readInt();
            for (int i = 0; i < n2; ++i) {
                object = (MsgObject)Msg.OBJECT_TO_CLIENT.clone(qResultClient.i_trans);
                ((MsgObject)object)._payLoad = msgD._payLoad.readYapBytes();
                if (((MsgObject)object)._payLoad == null) continue;
                ((MsgObject)object)._payLoad.incrementOffset(9);
                YapWriter yapWriter = ((MsgObject)object).unmarshall(9);
                objectArray[nArray2[i]] = new YapObject(nArray[i]).readPrefetch(this, qResultClient.i_trans, yapWriter);
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBlobMessage(MsgBlob msgBlob) {
        Object object = this.blobLock;
        synchronized (object) {
            boolean bl;
            boolean bl2 = bl = this.blobThread == null || this.blobThread.isTerminated();
            if (bl) {
                this.blobThread = new YapClientBlobThread(this);
            }
            this.blobThread.add(msgBlob);
            if (bl) {
                this.blobThread.start();
            }
        }
    }

    final void queryExecute(QQuery qQuery, QueryResultImpl queryResultImpl) {
        this.writeMsg(Msg.QUERY_EXECUTE.getWriter(this.marshall(qQuery.getTransaction(), qQuery)));
        this.readResult(queryResultImpl);
    }

    public void raiseVersion(long l) {
        this.writeMsg(Msg.RAISE_VERSION.getWriterForLong(this.i_trans, l));
    }

    void readBytes(byte[] byArray, int n, int n2, int n3) {
        throw Exceptions4.virtualException();
    }

    void readBytes(byte[] byArray, int n, int n2) {
        this.writeMsg(Msg.READ_BYTES.getWriterForInts(this.i_trans, new int[]{n, n2}));
        YapWriter yapWriter = this.expectedByteResponse(Msg.READ_BYTES);
        System.arraycopy(yapWriter._buffer, 0, byArray, 0, n2);
    }

    protected boolean rename1(Config4Impl config4Impl) {
        this.logMsg(58, null);
        return false;
    }

    public final YapWriter readWriterByID(Transaction transaction, int n) {
        try {
            this.writeMsg(Msg.READ_OBJECT.getWriterForInt(transaction, n));
            YapWriter yapWriter = ((MsgObject)this.expectedResponse(Msg.OBJECT_TO_CLIENT)).unmarshall();
            if (yapWriter == null) {
                return null;
            }
            yapWriter.setTransaction(transaction);
            return yapWriter;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final YapReader readReaderByID(Transaction transaction, int n) {
        return this.readWriterByID(transaction, n);
    }

    private void readResult(QueryResultImpl queryResultImpl) {
        YapWriter yapWriter = this.expectedByteResponse(Msg.ID_LIST);
        int n = yapWriter.readInt();
        for (int i = 0; i < n; ++i) {
            queryResultImpl.add(yapWriter.readInt());
        }
        queryResultImpl.reset();
    }

    void readThis() {
        this.writeMsg(Msg.GET_CLASSES.getWriter(this.i_systemTrans));
        YapWriter yapWriter = this.expectedByteResponse(Msg.GET_CLASSES);
        this.i_classCollection.setID(yapWriter.readInt());
        this.createStringIO(yapWriter.readByte());
        this.i_classCollection.read(this.i_systemTrans);
        this.i_classCollection.refreshClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSemaphore(String string) {
        Object object = this.i_lock;
        synchronized (object) {
            this.checkClosed();
            if (string == null) {
                throw new NullPointerException();
            }
            this.writeMsg(Msg.RELEASE_SEMAPHORE.getWriterForString(this.i_trans, string));
        }
    }

    void releaseSemaphores(Transaction transaction) {
    }

    private void reReadAll() {
        this.remainingIDs = 0;
        this.initialize0();
        this.initialize1();
        this.createTransaction();
        this.readThis();
    }

    final void rollback1() {
        this.writeMsg(Msg.ROLLBACK);
        this.i_trans.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            if (object != null) {
                this.writeMsg(Msg.USER_MESSAGE.getWriter(this.marshall(this.i_trans, object)));
            }
        }
    }

    final void setDirty(UseSystemTransaction useSystemTransaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSemaphore(String string, int n) {
        Object object = this.i_lock;
        synchronized (object) {
            this.checkClosed();
            if (string == null) {
                throw new NullPointerException();
            }
            this.writeMsg(Msg.SET_SEMAPHORE.getWriterForIntString(this.i_trans, n, string));
            Msg msg = this.getResponse();
            return msg.equals(Msg.SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToFile(String string) {
        Object object = this.i_lock;
        synchronized (object) {
            this.commit();
            this.writeMsg(Msg.SWITCH_TO_FILE.getWriterForString(this.i_trans, string));
            this.expectedResponse(Msg.OK);
            this.reReadAll();
            this.switchedToFile = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToMainFile() {
        Object object = this.i_lock;
        synchronized (object) {
            this.commit();
            this.writeMsg(Msg.SWITCH_TO_MAIN_FILE);
            this.expectedResponse(Msg.OK);
            this.reReadAll();
            this.switchedToFile = null;
        }
    }

    public String name() {
        return this.toString();
    }

    public String toString() {
        return "Client Connection " + this.userName;
    }

    void write(boolean bl) {
    }

    final void writeDirty() {
    }

    public final void writeEmbedded(YapWriter yapWriter, YapWriter yapWriter2) {
        yapWriter.addEmbedded(yapWriter2);
    }

    final void writeMsg(Msg msg) {
        msg.write(this, this.i_socket);
    }

    public final void writeNew(YapClass yapClass, YapWriter yapWriter) {
        this.writeMsg(Msg.WRITE_NEW.getWriter(yapClass, yapWriter));
    }

    final void writeObject(YapMeta yapMeta, YapReader yapReader, int n) {
        Exceptions4.shouldNeverBeCalled();
    }

    final void writeTransactionPointer(int n) {
    }

    public final void writeUpdate(YapClass yapClass, YapWriter yapWriter) {
        this.writeMsg(Msg.WRITE_UPDATE.getWriter(yapClass, yapWriter));
    }

    public boolean isAlive() {
        try {
            this.writeMsg(Msg.PING);
            return this.expectedResponse(Msg.OK) != null;
        }
        catch (Db4oException db4oException) {
            return false;
        }
    }

    public YapSocket socket() {
        return this.i_socket;
    }
}

