/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Readable;
import com.db4o.Tree;
import com.db4o.YapReader;

public final class TreeReader {
    private final Readable i_template;
    private final YapReader i_bytes;
    private int i_current = 0;
    private int i_levels = 0;
    private int i_size;
    private boolean i_orderOnRead = false;

    TreeReader(YapReader yapReader, Readable readable) {
        this.i_template = readable;
        this.i_bytes = yapReader;
    }

    public TreeReader(YapReader yapReader, Readable readable, boolean bl) {
        this(yapReader, readable);
        this.i_orderOnRead = bl;
    }

    public Tree read() {
        return this.read(this.i_bytes.readInt());
    }

    public Tree read(int n) {
        this.i_size = n;
        if (this.i_size > 0) {
            if (this.i_orderOnRead) {
                Tree tree = null;
                for (int i = 0; i < this.i_size; ++i) {
                    tree = Tree.add(tree, (Tree)this.i_template.read(this.i_bytes));
                }
                return tree;
            }
            while (1 << this.i_levels < this.i_size + 1) {
                ++this.i_levels;
            }
            return this.linkUp(null, this.i_levels);
        }
        return null;
    }

    private final Tree linkUp(Tree tree, int n) {
        Tree tree2 = (Tree)this.i_template.read(this.i_bytes);
        ++this.i_current;
        tree2._preceding = tree;
        tree2._subsequent = this.linkDown(n + 1);
        tree2.calculateSize();
        if (this.i_current < this.i_size) {
            return this.linkUp(tree2, n - 1);
        }
        return tree2;
    }

    private final Tree linkDown(int n) {
        if (this.i_current < this.i_size) {
            ++this.i_current;
            if (n < this.i_levels) {
                Tree tree = this.linkDown(n + 1);
                Tree tree2 = (Tree)this.i_template.read(this.i_bytes);
                tree2._preceding = tree;
                tree2._subsequent = this.linkDown(n + 1);
                tree2.calculateSize();
                return tree2;
            }
            return (Tree)this.i_template.read(this.i_bytes);
        }
        return null;
    }
}

