/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.jdk;

import com.db4o.Platform4;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectConstructor;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.ReflectMethod;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.jdk.JdkConstructor;
import com.db4o.reflect.jdk.JdkField;
import com.db4o.reflect.jdk.JdkMethod;
import com.db4o.reflect.jdk.JdkReflector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JdkClass
implements ReflectClass {
    private final Reflector _reflector;
    private final Class _clazz;
    private ReflectConstructor _constructor;
    private Object[] _constructorParams;

    public JdkClass(Reflector reflector, Class clazz) {
        if (reflector == null) {
            throw new NullPointerException();
        }
        this._reflector = reflector;
        this._clazz = clazz;
    }

    public ReflectClass getComponentType() {
        return this._reflector.forClass(this._clazz.getComponentType());
    }

    public ReflectConstructor[] getDeclaredConstructors() {
        Constructor<?>[] constructorArray = this._clazz.getDeclaredConstructors();
        ReflectConstructor[] reflectConstructorArray = new ReflectConstructor[constructorArray.length];
        for (int i = 0; i < constructorArray.length; ++i) {
            reflectConstructorArray[i] = new JdkConstructor(this._reflector, constructorArray[i]);
        }
        return reflectConstructorArray;
    }

    public ReflectField getDeclaredField(String string) {
        try {
            return new JdkField(this._reflector, this._clazz.getDeclaredField(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ReflectField[] getDeclaredFields() {
        Field[] fieldArray = this._clazz.getDeclaredFields();
        ReflectField[] reflectFieldArray = new ReflectField[fieldArray.length];
        for (int i = 0; i < reflectFieldArray.length; ++i) {
            reflectFieldArray[i] = new JdkField(this._reflector, fieldArray[i]);
        }
        return reflectFieldArray;
    }

    public ReflectClass getDelegate() {
        return this;
    }

    public ReflectMethod getMethod(String string, ReflectClass[] reflectClassArray) {
        try {
            Method method = this._clazz.getMethod(string, JdkReflector.toNative(reflectClassArray));
            if (method == null) {
                return null;
            }
            return new JdkMethod(method, this.reflector());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        return this._clazz.getName();
    }

    public ReflectClass getSuperclass() {
        return this._reflector.forClass(this._clazz.getSuperclass());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this._clazz.getModifiers());
    }

    public boolean isArray() {
        return this._clazz.isArray();
    }

    public boolean isAssignableFrom(ReflectClass reflectClass) {
        if (!(reflectClass instanceof JdkClass)) {
            return false;
        }
        return this._clazz.isAssignableFrom(JdkReflector.toNative(reflectClass));
    }

    public boolean isCollection() {
        return this._reflector.isCollection(this);
    }

    public boolean isInstance(Object object) {
        return this._clazz.isInstance(object);
    }

    public boolean isInterface() {
        return this._clazz.isInterface();
    }

    public boolean isPrimitive() {
        return this._clazz.isPrimitive();
    }

    public boolean isSecondClass() {
        return this.isPrimitive();
    }

    public Object newInstance() {
        try {
            if (this._constructor == null) {
                return this._clazz.newInstance();
            }
            return this._constructor.newInstance(this._constructorParams);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    Class getJavaClass() {
        return this._clazz;
    }

    public Reflector reflector() {
        return this._reflector;
    }

    public boolean skipConstructor(boolean bl) {
        Constructor constructor;
        if (bl && (constructor = Platform4.jdk().serializableConstructor(this._clazz)) != null) {
            try {
                Object t = constructor.newInstance(null);
                if (t != null) {
                    this.useConstructor(new JdkConstructor(this._reflector, constructor), null);
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.useConstructor(null, null);
        return false;
    }

    public void useConstructor(ReflectConstructor reflectConstructor, Object[] objectArray) {
        this._constructor = reflectConstructor;
        this._constructorParams = objectArray;
    }

    public Object[] toArray(Object object) {
        return null;
    }
}

