/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.generic;

import com.db4o.Transaction;
import com.db4o.YapBit;
import com.db4o.YapStream;
import com.db4o.YapWriter;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectClassPredicate;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.CollectionUpdateDepthEntry;
import com.db4o.reflect.generic.GenericArrayReflector;
import com.db4o.reflect.generic.GenericClass;
import com.db4o.reflect.generic.GenericConverter;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericObject;
import com.db4o.reflect.generic.GenericVirtualField;

public class GenericReflector
implements Reflector,
DeepClone {
    private Reflector _delegate;
    private GenericArrayReflector _array;
    private final Hashtable4 _classByName = new Hashtable4(1);
    private final Hashtable4 _classByClass = new Hashtable4(1);
    private final Collection4 _classes = new Collection4();
    private final Hashtable4 _classByID = new Hashtable4(1);
    private Collection4 _collectionPredicates = new Collection4();
    private Collection4 _collectionUpdateDepths = new Collection4();
    private Collection4 _pendingClasses = new Collection4();
    private Transaction _trans;
    private YapStream _stream;

    public GenericReflector(Transaction transaction, Reflector reflector) {
        this.setTransaction(transaction);
        this._delegate = reflector;
        if (this._delegate != null) {
            this._delegate.setParent(this);
        }
    }

    public Object deepClone(Object object) {
        GenericReflector genericReflector = new GenericReflector(null, (Reflector)this._delegate.deepClone(this));
        genericReflector._collectionPredicates = (Collection4)this._collectionPredicates.deepClone(genericReflector);
        genericReflector._collectionUpdateDepths = (Collection4)this._collectionUpdateDepths.deepClone(genericReflector);
        return genericReflector;
    }

    YapStream getStream() {
        return this._stream;
    }

    public boolean hasTransaction() {
        return this._trans != null;
    }

    public void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this._trans = transaction;
            this._stream = transaction.i_stream;
        }
    }

    public ReflectArray array() {
        if (this._array == null) {
            this._array = new GenericArrayReflector(this);
        }
        return this._array;
    }

    public int collectionUpdateDepth(ReflectClass reflectClass) {
        Iterator4 iterator4 = this._collectionUpdateDepths.iterator();
        while (iterator4.hasNext()) {
            CollectionUpdateDepthEntry collectionUpdateDepthEntry = (CollectionUpdateDepthEntry)iterator4.next();
            if (!collectionUpdateDepthEntry._predicate.match(reflectClass)) continue;
            return collectionUpdateDepthEntry._depth;
        }
        return 2;
    }

    public boolean constructorCallsSupported() {
        return this._delegate.constructorCallsSupported();
    }

    GenericClass ensureDelegate(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return null;
        }
        GenericClass genericClass = (GenericClass)this._classByName.get(reflectClass.getName());
        if (genericClass == null) {
            String string = reflectClass.getName();
            genericClass = new GenericClass(this, reflectClass, string, null);
            this._classes.add(genericClass);
            this._classByName.put(string, (Object)genericClass);
        }
        return genericClass;
    }

    public ReflectClass forClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ReflectClass reflectClass = (ReflectClass)this._classByClass.get(clazz);
        if (reflectClass != null) {
            return reflectClass;
        }
        reflectClass = this.forName(clazz.getName());
        if (reflectClass != null) {
            this._classByClass.put(clazz, (Object)reflectClass);
            return reflectClass;
        }
        reflectClass = this._delegate.forClass(clazz);
        if (reflectClass == null) {
            return null;
        }
        reflectClass = this.ensureDelegate(reflectClass);
        this._classByClass.put(clazz, (Object)reflectClass);
        return reflectClass;
    }

    public ReflectClass forName(String string) {
        int n;
        ReflectClass reflectClass = (ReflectClass)this._classByName.get(string);
        if (reflectClass != null) {
            return reflectClass;
        }
        reflectClass = this._delegate.forName(string);
        if (reflectClass != null) {
            return this.ensureDelegate(reflectClass);
        }
        if (this._stream == null) {
            return null;
        }
        if (this._stream.i_classCollection != null && (n = this._stream.i_classCollection.getYapClassID(string)) > 0) {
            reflectClass = this.ensureClassInitialised(n);
            this._classByName.put(string, (Object)reflectClass);
            return reflectClass;
        }
        return null;
    }

    public ReflectClass forObject(Object object) {
        if (object instanceof GenericObject) {
            return ((GenericObject)object)._class;
        }
        return this._delegate.forObject(object);
    }

    public Reflector getDelegate() {
        return this._delegate;
    }

    public boolean isCollection(ReflectClass reflectClass) {
        Iterator4 iterator4 = this._collectionPredicates.iterator();
        while (iterator4.hasNext()) {
            if (!((ReflectClassPredicate)iterator4.next()).match(reflectClass)) continue;
            return true;
        }
        return this._delegate.isCollection(reflectClass.getDelegate());
    }

    public void registerCollection(Class clazz) {
        this.registerCollection(this.classPredicate(clazz));
    }

    public void registerCollection(ReflectClassPredicate reflectClassPredicate) {
        this._collectionPredicates.add(reflectClassPredicate);
    }

    private ReflectClassPredicate classPredicate(Class clazz) {
        final ReflectClass reflectClass = this.forClass(clazz);
        ReflectClassPredicate reflectClassPredicate = new ReflectClassPredicate(){

            public boolean match(ReflectClass reflectClass2) {
                return reflectClass.isAssignableFrom(reflectClass2);
            }
        };
        return reflectClassPredicate;
    }

    public void registerCollectionUpdateDepth(Class clazz, int n) {
        this.registerCollectionUpdateDepth(this.classPredicate(clazz), n);
    }

    public void registerCollectionUpdateDepth(ReflectClassPredicate reflectClassPredicate, int n) {
        this._collectionUpdateDepths.add(new CollectionUpdateDepthEntry(reflectClassPredicate, n));
    }

    public void register(GenericClass genericClass) {
        String string = genericClass.getName();
        if (this._classByName.get(string) == null) {
            this._classByName.put(string, (Object)genericClass);
            this._classes.add(genericClass);
        }
    }

    public ReflectClass[] knownClasses() {
        ReflectClass[] reflectClassArray;
        this.readAll();
        Collection4 collection4 = new Collection4();
        Iterator4 iterator4 = this._classes.iterator();
        while (iterator4.hasNext()) {
            reflectClassArray = (ReflectClass[])iterator4.next();
            if (this._stream.i_handlers.ICLASS_INTERNAL.isAssignableFrom((ReflectClass)reflectClassArray) || reflectClassArray.isSecondClass() || reflectClassArray.isArray()) continue;
            collection4.add(reflectClassArray);
        }
        reflectClassArray = new ReflectClass[collection4.size()];
        int n = 0;
        iterator4 = collection4.iterator();
        while (iterator4.hasNext()) {
            reflectClassArray[n++] = (ReflectClass)iterator4.next();
        }
        return reflectClassArray;
    }

    private void readAll() {
        int n;
        int n2 = this._stream.i_classCollection.getID();
        YapWriter yapWriter = this._stream.readWriterByID(this._trans, n2);
        int n3 = yapWriter.readInt();
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = yapWriter.readInt();
            this.ensureClassAvailability(nArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            this.ensureClassRead(nArray[n]);
        }
    }

    private GenericClass ensureClassInitialised(int n) {
        GenericClass genericClass = this.ensureClassAvailability(n);
        while (this._pendingClasses.size() > 0) {
            Collection4 collection4 = this._pendingClasses;
            this._pendingClasses = new Collection4();
            Iterator4 iterator4 = collection4.iterator();
            while (iterator4.hasNext()) {
                this.ensureClassRead((Integer)iterator4.next());
            }
        }
        return genericClass;
    }

    private GenericClass ensureClassAvailability(int n) {
        if (n == 0) {
            return null;
        }
        GenericClass genericClass = (GenericClass)this._classByID.get(n);
        if (genericClass != null) {
            return genericClass;
        }
        YapWriter yapWriter = this._stream.readWriterByID(this._trans, n);
        int n2 = yapWriter.readInt();
        String string = this._stream.stringIO().read(yapWriter, n2);
        genericClass = (GenericClass)this._classByName.get(string);
        if (genericClass != null) {
            this._classByID.put(n, (Object)genericClass);
            this._pendingClasses.add(new Integer(n));
            return genericClass;
        }
        yapWriter.incrementOffset(4);
        int n3 = yapWriter.readInt();
        int n4 = yapWriter.readInt();
        int n5 = yapWriter.readInt();
        ReflectClass reflectClass = this._delegate.forName(string);
        genericClass = new GenericClass(this, reflectClass, string, this.ensureClassAvailability(n3));
        genericClass.setDeclaredFieldCount(n5);
        this._classByID.put(n, (Object)genericClass);
        this._pendingClasses.add(new Integer(n));
        return genericClass;
    }

    private void ensureClassRead(int n) {
        GenericClass genericClass = (GenericClass)this._classByID.get(n);
        YapWriter yapWriter = this._stream.readWriterByID(this._trans, n);
        int n2 = yapWriter.readInt();
        String string = this._stream.stringIO().read(yapWriter, n2);
        if (this._classByName.get(string) != null) {
            return;
        }
        this._classByName.put(string, (Object)genericClass);
        this._classes.add(genericClass);
        yapWriter.incrementOffset(12);
        int n3 = yapWriter.readInt();
        GenericField[] genericFieldArray = new GenericField[n3];
        for (int i = 0; i < n3; ++i) {
            String string2 = null;
            int n4 = yapWriter.readInt();
            string2 = this._stream.stringIO().read(yapWriter, n4);
            if (string2.indexOf("v4o") == 0) {
                genericFieldArray[i] = new GenericVirtualField(string2);
                continue;
            }
            GenericClass genericClass2 = null;
            int n5 = yapWriter.readInt();
            switch (n5) {
                case 11: {
                    genericClass2 = (GenericClass)this.forClass(Object.class);
                    break;
                }
                case 12: {
                    genericClass2 = ((GenericClass)this.forClass(Object.class)).arrayClass();
                    break;
                }
                default: {
                    this.ensureClassAvailability(n5);
                    genericClass2 = (GenericClass)this._classByID.get(n5);
                }
            }
            YapBit yapBit = new YapBit(yapWriter.readByte());
            boolean bl = yapBit.get();
            boolean bl2 = yapBit.get();
            boolean bl3 = yapBit.get();
            genericFieldArray[i] = new GenericField(string2, genericClass2, bl, bl2, bl3);
        }
        genericClass.initFields(genericFieldArray);
    }

    public void registerPrimitiveClass(int n, String string, GenericConverter genericConverter) {
        GenericClass genericClass = (GenericClass)this._classByID.get(n);
        if (genericClass != null) {
            if (null != genericConverter) {
                genericClass.setSecondClass();
            } else {
                genericClass.setConverter(null);
            }
            return;
        }
        ReflectClass reflectClass = this._delegate.forName(string);
        GenericClass genericClass2 = null;
        if (reflectClass != null) {
            genericClass2 = this.ensureDelegate(reflectClass);
        } else {
            genericClass2 = new GenericClass(this, null, string, null);
            this._classByName.put(string, (Object)genericClass2);
            genericClass2.initFields(new GenericField[]{new GenericField(null, null, true, false, false)});
            genericClass2.setConverter(genericConverter);
            this._classes.add(genericClass2);
        }
        genericClass2.setSecondClass();
        genericClass2.setPrimitive();
        this._classByID.put(n, (Object)genericClass2);
    }

    public void setParent(Reflector reflector) {
    }
}

