/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.Platform4;
import com.db4o.io.IoAdapter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileAdapter
extends IoAdapter {
    private RandomAccessFile _delegate;

    public RandomAccessFileAdapter() {
    }

    protected RandomAccessFileAdapter(String string, boolean bl, long l) throws IOException {
        this._delegate = new RandomAccessFile(string, "rw");
        if (l > 0L) {
            this._delegate.seek(l - 1L);
            this._delegate.write(new byte[]{0});
        }
        if (bl) {
            Platform4.lockFile(this._delegate);
        }
    }

    public void close() throws IOException {
        try {
            Platform4.unlockFile(this._delegate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._delegate.close();
    }

    public void delete(String string) {
        new File(string).delete();
    }

    public boolean exists(String string) {
        File file = new File(string);
        return file.exists() && file.length() > 0L;
    }

    public long getLength() throws IOException {
        return this._delegate.length();
    }

    public IoAdapter open(String string, boolean bl, long l) throws IOException {
        return new RandomAccessFileAdapter(string, bl, l);
    }

    public int read(byte[] byArray, int n) throws IOException {
        return this._delegate.read(byArray, 0, n);
    }

    public void seek(long l) throws IOException {
        this._delegate.seek(l);
    }

    public void sync() throws IOException {
        this._delegate.getFD().sync();
    }

    public void write(byte[] byArray, int n) throws IOException {
        this._delegate.write(byArray, 0, n);
    }
}

