/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.marshall;

import com.db4o.CorruptionException;
import com.db4o.Transaction;
import com.db4o.YapReader;
import com.db4o.YapStream;
import com.db4o.YapWriter;
import com.db4o.inside.marshall.ObjectHeaderAttributes;
import com.db4o.inside.marshall.StringMarshaller;

public class StringMarshaller1
extends StringMarshaller {
    public boolean inlinedStrings() {
        return true;
    }

    public void calculateLengths(Transaction transaction, ObjectHeaderAttributes objectHeaderAttributes, boolean bl, Object object, boolean bl2) {
        if (bl) {
            objectHeaderAttributes.addBaseLength(this.linkLength());
            objectHeaderAttributes.prepareIndexedPayLoadEntry(transaction);
        } else if (bl2) {
            objectHeaderAttributes.addPayLoadLength(this.linkLength());
        }
        if (object == null) {
            return;
        }
        objectHeaderAttributes.addPayLoadLength(transaction.i_stream.stringIO().length((String)object));
    }

    public Object writeNew(Object object, boolean bl, YapWriter yapWriter, boolean bl2) {
        YapStream yapStream = yapWriter.getStream();
        String string = (String)object;
        if (!bl2) {
            if (string != null) {
                StringMarshaller1.writeShort(yapStream, string, yapWriter);
            }
            return string;
        }
        if (string == null) {
            yapWriter.writeEmbeddedNull();
            return null;
        }
        int n = yapStream.stringIO().length(string);
        YapWriter yapWriter2 = new YapWriter(yapWriter.getTransaction(), n);
        StringMarshaller1.writeShort(yapStream, string, yapWriter2);
        yapWriter.writePayload(yapWriter2, bl);
        return yapWriter2;
    }

    public YapWriter readIndexEntry(YapWriter yapWriter) throws CorruptionException {
        int n = yapWriter.readInt();
        int n2 = yapWriter.readInt();
        if (n == 0) {
            return null;
        }
        return yapWriter.readPayloadWriter(n, n2);
    }

    public YapReader readSlotFromParentSlot(YapStream yapStream, YapReader yapReader) throws CorruptionException {
        int n = yapReader.readInt();
        int n2 = yapReader.readInt();
        if (n == 0) {
            return null;
        }
        return yapReader.readPayloadReader(n, n2);
    }
}

