/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.convert;

import com.db4o.YapConfigBlock;
import com.db4o.YapFile;
import com.db4o.foundation.Hashtable4;
import com.db4o.inside.Exceptions4;
import com.db4o.inside.convert.Conversion;
import com.db4o.inside.convert.conversions.CommonConversions;

public class Converter {
    public static final int VERSION = 5;
    private Hashtable4 _conversions = new Hashtable4(1);

    public static final boolean convert(YapFile yapFile, YapConfigBlock yapConfigBlock) {
        if (yapConfigBlock.converterVersion() >= 5) {
            return false;
        }
        Converter converter = new Converter();
        converter.run(yapFile, yapConfigBlock);
        return true;
    }

    private Converter() {
        new CommonConversions(this);
    }

    public void register(int n, Conversion conversion) {
        if (this._conversions.get(n) != null) {
            Exceptions4.shouldNeverHappen();
        }
        this._conversions.put(n, (Object)conversion);
    }

    private void run(YapFile yapFile, YapConfigBlock yapConfigBlock) {
        int n;
        for (int i = n = yapConfigBlock.converterVersion(); i <= 5; ++i) {
            Conversion conversion = (Conversion)this._conversions.get(i);
            if (conversion == null) continue;
            conversion.setFile(yapFile);
            conversion.run();
        }
        yapConfigBlock.converterVersion(5);
        yapConfigBlock.write();
    }
}

