/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.IDGenerator;
import com.db4o.QCandidate;
import com.db4o.QCon;
import com.db4o.QField;
import com.db4o.QOrder;
import com.db4o.Transaction;
import com.db4o.Tree;
import com.db4o.TreeInt;
import com.db4o.VisitorBoolean;
import com.db4o.YapClass;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.diagnostic.DiagnosticProcessor;
import com.db4o.inside.ix.QxProcessor;

public final class QCandidates
implements Visitor4 {
    public final Transaction i_trans;
    private Tree i_root;
    private List4 i_constraints;
    YapClass i_yapClass;
    private QField i_field;
    QCon i_currentConstraint;
    Tree i_ordered;
    private int i_orderID;
    private IDGenerator _idGenerator;

    QCandidates(Transaction transaction, YapClass yapClass, QField qField) {
        this.i_trans = transaction;
        this.i_yapClass = yapClass;
        this.i_field = qField;
        if (qField == null || qField.i_yapField == null || !(qField.i_yapField.getHandler() instanceof YapClass)) {
            return;
        }
        YapClass yapClass2 = (YapClass)qField.i_yapField.getHandler();
        if (this.i_yapClass == null) {
            this.i_yapClass = yapClass2;
        } else if ((yapClass2 = this.i_yapClass.getHigherOrCommonHierarchy(yapClass2)) != null) {
            this.i_yapClass = yapClass2;
        }
    }

    public QCandidate addByIdentity(QCandidate qCandidate) {
        this.i_root = Tree.add(this.i_root, qCandidate);
        if (qCandidate._size == 0) {
            return qCandidate.getRoot();
        }
        return qCandidate;
    }

    void addConstraint(QCon qCon) {
        this.i_constraints = new List4(this.i_constraints, qCon);
    }

    void addOrder(QOrder qOrder) {
        this.i_ordered = Tree.add(this.i_ordered, qOrder);
    }

    void applyOrdering(Tree tree, int n) {
        boolean bl;
        if (tree == null || this.i_root == null) {
            return;
        }
        if (n > 0) {
            n = -n;
        }
        boolean bl2 = bl = n - this.i_orderID < 0;
        if (bl) {
            this.i_orderID = n;
        }
        final int[] nArray = new int[]{0};
        this.i_root.traverse(new Visitor4(){

            public void visit(Object object) {
                ((QCandidate)object).hintOrder(0, bl);
                int n = nArray[0];
                nArray[0] = n + 1;
                ((QCandidate)object).hintOrder(n, !bl);
            }
        });
        nArray[0] = 1;
        tree.traverse(new Visitor4(){

            public void visit(Object object) {
                QOrder qOrder = (QOrder)object;
                QCandidate qCandidate = qOrder._candidate.getRoot();
                int n = nArray[0];
                nArray[0] = n + 1;
                qCandidate.hintOrder(n, bl);
            }
        });
        final Collection4 collection4 = new Collection4();
        this.i_root.traverse(new Visitor4(){

            public void visit(Object object) {
                QCandidate qCandidate = (QCandidate)object;
                collection4.add(qCandidate);
            }
        });
        Tree[] treeArray = new Tree[]{null};
        Iterator4 iterator4 = collection4.iterator();
        while (iterator4.hasNext()) {
            QCandidate qCandidate = (QCandidate)iterator4.next();
            qCandidate._preceding = null;
            qCandidate._subsequent = null;
            qCandidate._size = 1;
            treeArray[0] = Tree.add(treeArray[0], qCandidate);
        }
        this.i_root = treeArray[0];
    }

    void collect(QCandidates qCandidates) {
        Iterator4 iterator4 = this.iterateConstraints();
        while (iterator4.hasNext()) {
            QCon qCon = (QCon)iterator4.next();
            this.setCurrentConstraint(qCon);
            qCon.collect(qCandidates);
        }
        this.setCurrentConstraint(null);
    }

    void execute() {
        QxProcessor qxProcessor;
        int n = this.i_yapClass.indexEntryCount(this.i_trans);
        boolean bl = true;
        if (this.i_constraints != null && (qxProcessor = new QxProcessor()).run(this, n)) {
            this.i_root = qxProcessor.toQCandidates(this);
            bl = false;
        }
        if (bl) {
            this.loadFromClassIndex();
        }
        this.evaluate();
    }

    void evaluate() {
        if (this.i_constraints == null) {
            return;
        }
        Iterator4 iterator4 = this.iterateConstraints();
        while (iterator4.hasNext()) {
            ((QCon)iterator4.next()).evaluateSelf();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.hasNext()) {
            ((QCon)iterator4.next()).evaluateSimpleChildren();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.hasNext()) {
            ((QCon)iterator4.next()).evaluateEvaluations();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.hasNext()) {
            ((QCon)iterator4.next()).evaluateCreateChildrenCandidates();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.hasNext()) {
            ((QCon)iterator4.next()).evaluateCollectChildren();
        }
        iterator4 = this.iterateConstraints();
        while (iterator4.hasNext()) {
            ((QCon)iterator4.next()).evaluateChildren();
        }
    }

    boolean isEmpty() {
        final boolean[] blArray = new boolean[]{true};
        this.traverse(new Visitor4(){

            public void visit(Object object) {
                if (((QCandidate)object)._include) {
                    blArray[0] = false;
                }
            }
        });
        return blArray[0];
    }

    boolean filter(Visitor4 visitor4) {
        if (this.i_root != null) {
            this.i_root.traverse(visitor4);
            this.i_root = this.i_root.filter(new VisitorBoolean(){

                public boolean isVisit(Object object) {
                    return ((QCandidate)object)._include;
                }
            });
        }
        return this.i_root != null;
    }

    int generateCandidateId() {
        if (this._idGenerator == null) {
            this._idGenerator = new IDGenerator();
        }
        return -this._idGenerator.next();
    }

    public Iterator4 iterateConstraints() {
        if (this.i_constraints == null) {
            return Iterator4Impl.EMPTY;
        }
        return new Iterator4Impl(this.i_constraints);
    }

    void loadFromClassIndex() {
        if (!this.isEmpty()) {
            return;
        }
        this.i_root = TreeInt.toQCandidate((TreeInt)this.i_yapClass.getIndex(this.i_trans), this);
        DiagnosticProcessor diagnosticProcessor = this.i_trans.i_stream.i_handlers._diagnosticProcessor;
        if (diagnosticProcessor.enabled()) {
            diagnosticProcessor.loadedFromClassIndex(this.i_yapClass);
        }
    }

    void setCurrentConstraint(QCon qCon) {
        this.i_currentConstraint = qCon;
    }

    void traverse(Visitor4 visitor4) {
        if (this.i_root != null) {
            this.i_root.traverse(visitor4);
        }
    }

    boolean tryAddConstraint(QCon qCon) {
        Object object;
        if (this.i_field != null && (object = qCon.getField()) != null && this.i_field.i_name != ((QField)object).i_name) {
            return false;
        }
        if (this.i_yapClass == null || qCon.isNullConstraint()) {
            this.addConstraint(qCon);
            return true;
        }
        object = qCon.getYapClass();
        if (object != null && (object = this.i_yapClass.getHigherOrCommonHierarchy((YapClass)object)) != null) {
            this.i_yapClass = object;
            this.addConstraint(qCon);
            return true;
        }
        return false;
    }

    public void visit(Object object) {
        QCandidate qCandidate = (QCandidate)object;
        if (qCandidate.createChild(this)) {
            return;
        }
        Iterator4 iterator4 = this.iterateConstraints();
        while (iterator4.hasNext()) {
            ((QCon)iterator4.next()).visitOnNull(qCandidate.getRoot());
        }
    }
}

