/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Config4Impl;
import com.db4o.Messages;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.Platform4;
import com.db4o.Session;
import com.db4o.Sessions;
import com.db4o.YapClient;
import com.db4o.YapFile;
import com.db4o.YapMemoryFile;
import com.db4o.YapServer;
import com.db4o.config.Configuration;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.MemoryFile;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.network.YapSocketReal;
import com.db4o.reflect.Reflector;
import java.io.IOException;

public class Db4o {
    static final Config4Impl i_config = new Config4Impl();
    private static Sessions i_sessions = new Sessions();
    static final Object lock = Db4o.initialize();
    static String licTo = "";
    private static boolean expirationMessagePrinted;

    private static final Object initialize() {
        Platform4.getDefaultConfiguration(i_config);
        return new Object();
    }

    public static void main(String[] stringArray) {
        System.out.println(Db4o.version());
    }

    public static Configuration configure() {
        return i_config;
    }

    public static void licensedTo(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectContainer openClient(String string, int n, String string2, String string3) throws IOException {
        Object object = lock;
        synchronized (object) {
            return new YapClient(new YapSocketReal(string, n), string2, string3, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ObjectContainer openFile(String string) throws DatabaseFileLockedException {
        Object object = lock;
        synchronized (object) {
            return i_sessions.open(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final ObjectContainer openMemoryFile1(MemoryFile memoryFile) {
        Object object = lock;
        synchronized (object) {
            if (memoryFile == null) {
                memoryFile = new MemoryFile();
            }
            YapMemoryFile yapMemoryFile = null;
            try {
                yapMemoryFile = new YapMemoryFile(memoryFile);
            }
            catch (Throwable throwable) {
                Messages.logErr(i_config, 4, "Memory File", throwable);
                return null;
            }
            if (yapMemoryFile != null) {
                Platform4.postOpen(yapMemoryFile);
                Messages.logMsg(i_config, 5, "Memory File");
            }
            return yapMemoryFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ObjectServer openServer(String string, int n) throws DatabaseFileLockedException {
        Object object = lock;
        synchronized (object) {
            YapFile yapFile = (YapFile)Db4o.openFile(string);
            if (yapFile == null) {
                return null;
            }
            Object object2 = yapFile.lock();
            synchronized (object2) {
                return new YapServer(yapFile, n);
            }
        }
    }

    static Reflector reflector() {
        return i_config.reflector();
    }

    static void forEachSession(Visitor4 visitor4) {
        i_sessions.forEach(visitor4);
    }

    static void sessionStopped(Session session) {
        i_sessions.remove(session);
    }

    public static final String version() {
        return "db4o 5.5.1";
    }
}

