/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.marshall;

import com.db4o.Config4Class;
import com.db4o.CorruptionException;
import com.db4o.Db4oTypeImpl;
import com.db4o.Transaction;
import com.db4o.TreeInt;
import com.db4o.YapClass;
import com.db4o.YapField;
import com.db4o.YapObject;
import com.db4o.YapReader;
import com.db4o.YapWriter;
import com.db4o.inside.marshall.ObjectHeaderAttributes;
import com.db4o.inside.marshall.ObjectHeaderAttributes1;
import com.db4o.inside.marshall.ObjectMarshaller;

public class ObjectMarshaller1
extends ObjectMarshaller {
    public void addFieldIndices(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapWriter yapWriter, boolean bl) {
        this.addDeclaredFieldIndices(yapClass, (ObjectHeaderAttributes1)objectHeaderAttributes, yapWriter, 0, bl);
    }

    private void addDeclaredFieldIndices(YapClass yapClass, ObjectHeaderAttributes1 objectHeaderAttributes1, YapWriter yapWriter, int n, boolean bl) {
        int n2 = yapWriter.readInt();
        for (int i = 0; i < n2; ++i) {
            if (objectHeaderAttributes1.isNull(n)) {
                yapClass.i_fields[i].addIndexEntry(yapWriter.getTransaction(), yapWriter.getID(), null);
            } else {
                yapClass.i_fields[i].addFieldIndex(this._family, yapWriter, bl);
            }
            ++n;
        }
        if (yapClass.i_ancestor != null) {
            this.addDeclaredFieldIndices(yapClass.i_ancestor, objectHeaderAttributes1, yapWriter, n, bl);
        }
    }

    public TreeInt collectFieldIDs(TreeInt treeInt, YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapWriter yapWriter, String string) {
        return this.collectDeclaredFieldIDs(treeInt, yapClass, (ObjectHeaderAttributes1)objectHeaderAttributes, yapWriter, string, 0);
    }

    public TreeInt collectDeclaredFieldIDs(TreeInt treeInt, YapClass yapClass, ObjectHeaderAttributes1 objectHeaderAttributes1, YapWriter yapWriter, String string, int n) {
        int n2 = yapClass.readFieldCount(yapWriter);
        for (int i = 0; i < n2; ++i) {
            if (!objectHeaderAttributes1.isNull(n)) {
                if (string.equals(yapClass.i_fields[i].getName())) {
                    treeInt = yapClass.i_fields[i].collectIDs(this._family, treeInt, yapWriter);
                } else {
                    yapClass.i_fields[i].incrementOffset(yapWriter);
                }
            }
            ++n;
        }
        if (yapClass.i_ancestor != null) {
            return this.collectDeclaredFieldIDs(treeInt, yapClass.i_ancestor, objectHeaderAttributes1, yapWriter, string, n);
        }
        return treeInt;
    }

    public void deleteMembers(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapWriter yapWriter, int n, boolean bl) {
        this.deleteDeclaredMembers(yapClass, (ObjectHeaderAttributes1)objectHeaderAttributes, yapWriter, n, 0, bl);
    }

    public void deleteDeclaredMembers(YapClass yapClass, ObjectHeaderAttributes1 objectHeaderAttributes1, YapWriter yapWriter, int n, int n2, boolean bl) {
        int n3 = yapClass.readFieldCount(yapWriter);
        for (int i = 0; i < n3; ++i) {
            if (objectHeaderAttributes1.isNull(n2)) {
                yapClass.i_fields[i].removeIndexEntry(yapWriter.getTransaction(), yapWriter.getID(), null);
            } else {
                yapClass.i_fields[i].delete(this._family, yapWriter, bl);
            }
            ++n2;
        }
        if (yapClass.i_ancestor != null) {
            this.deleteDeclaredMembers(yapClass.i_ancestor, objectHeaderAttributes1, yapWriter, n, n2, bl);
        }
    }

    public boolean findOffset(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapReader yapReader, YapField yapField) {
        return this.findDeclaredOffset(yapClass, (ObjectHeaderAttributes1)objectHeaderAttributes, yapReader, yapField, 0);
    }

    public boolean findDeclaredOffset(YapClass yapClass, ObjectHeaderAttributes1 objectHeaderAttributes1, YapReader yapReader, YapField yapField, int n) {
        int n2 = yapClass.readFieldCount(yapReader);
        for (int i = 0; i < n2; ++i) {
            if (yapClass.i_fields[i] == yapField) {
                return !objectHeaderAttributes1.isNull(n);
            }
            if (!objectHeaderAttributes1.isNull(n)) {
                yapReader.incrementOffset(yapClass.i_fields[i].linkLength());
            }
            ++n;
        }
        if (yapClass.i_ancestor == null) {
            return false;
        }
        return this.findDeclaredOffset(yapClass.i_ancestor, objectHeaderAttributes1, yapReader, yapField, n);
    }

    public void instantiateFields(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapObject yapObject, Object object, YapWriter yapWriter) {
        this.instantiateDeclaredFields(yapClass, (ObjectHeaderAttributes1)objectHeaderAttributes, yapObject, object, yapWriter, 0);
    }

    public void instantiateDeclaredFields(YapClass yapClass, ObjectHeaderAttributes1 objectHeaderAttributes1, YapObject yapObject, Object object, YapWriter yapWriter, int n) {
        int n2 = yapClass.readFieldCount(yapWriter);
        try {
            for (int i = 0; i < n2; ++i) {
                if (objectHeaderAttributes1.isNull(n)) {
                    yapClass.i_fields[i].set(object, null);
                } else {
                    yapClass.i_fields[i].instantiate(this._family, yapObject, object, yapWriter);
                }
                ++n;
            }
            if (yapClass.i_ancestor != null) {
                this.instantiateDeclaredFields(yapClass.i_ancestor, objectHeaderAttributes1, yapObject, object, yapWriter, n);
            }
        }
        catch (CorruptionException corruptionException) {
            // empty catch block
        }
    }

    private void marshall(YapObject yapObject, Object object, ObjectHeaderAttributes1 objectHeaderAttributes1, YapWriter yapWriter, int n, boolean bl) {
        YapClass yapClass = yapObject.getYapClass();
        yapWriter.writeInt(-yapClass.getID());
        objectHeaderAttributes1.write(yapWriter);
        yapClass.checkUpdateDepth(yapWriter);
        this.marshallDeclaredFields(yapClass, yapObject, object, objectHeaderAttributes1, yapWriter, n, bl);
    }

    private void marshallDeclaredFields(YapClass yapClass, YapObject yapObject, Object object, ObjectHeaderAttributes1 objectHeaderAttributes1, YapWriter yapWriter, int n, boolean bl) {
        Config4Class config4Class = yapClass.configOrAncestorConfig();
        Transaction transaction = yapWriter.getTransaction();
        int n2 = yapClass.i_fields.length;
        yapWriter.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            YapField yapField = yapClass.i_fields[i];
            if (!objectHeaderAttributes1.isNull(n)) {
                Object object2 = yapField.getOrCreate(transaction, object);
                if (object2 instanceof Db4oTypeImpl) {
                    object2 = ((Db4oTypeImpl)object2).storedTo(transaction);
                }
                yapField.marshall(yapObject, object2, this._family, yapWriter, config4Class, bl);
            } else {
                yapField.addIndexEntry(transaction, yapWriter.getID(), null);
            }
            ++n;
        }
        if (yapClass.i_ancestor != null) {
            this.marshallDeclaredFields(yapClass.i_ancestor, yapObject, object, objectHeaderAttributes1, yapWriter, n, bl);
        }
    }

    public YapWriter marshallNew(Transaction transaction, YapObject yapObject, int n) {
        ObjectHeaderAttributes1 objectHeaderAttributes1 = new ObjectHeaderAttributes1(yapObject);
        YapWriter yapWriter = this.createWriterForNew(transaction, yapObject, n, objectHeaderAttributes1.objectLength());
        this.marshall(yapObject, yapObject.getObject(), objectHeaderAttributes1, yapWriter, 0, true);
        return yapWriter;
    }

    public void marshallUpdate(Transaction transaction, int n, YapObject yapObject, Object object) {
        ObjectHeaderAttributes1 objectHeaderAttributes1 = new ObjectHeaderAttributes1(yapObject);
        YapWriter yapWriter = this.createWriterForUpdate(transaction, n, yapObject.getID(), 0, objectHeaderAttributes1.objectLength());
        if (transaction.i_file != null) {
            transaction.i_file.getSlotForUpdate(yapWriter);
        }
        this.marshall(yapObject, object, objectHeaderAttributes1, yapWriter, 0, false);
        this.marshallUpdateWrite(transaction, yapObject, object, yapWriter);
    }

    public ObjectHeaderAttributes readHeaderAttributes(YapReader yapReader) {
        return new ObjectHeaderAttributes1(yapReader);
    }

    public Object readIndexEntry(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapField yapField, YapWriter yapWriter) {
        if (yapClass == null) {
            return null;
        }
        if (!this.findOffset(yapClass, objectHeaderAttributes, yapWriter, yapField)) {
            return null;
        }
        return yapField.readIndexEntry(this._family, yapWriter);
    }

    public void readVirtualAttributes(Transaction transaction, YapClass yapClass, YapObject yapObject, ObjectHeaderAttributes objectHeaderAttributes, YapReader yapReader) {
        this.readVirtualAttributesDeclared(transaction, yapClass, yapObject, (ObjectHeaderAttributes1)objectHeaderAttributes, yapReader, 0);
    }

    private void readVirtualAttributesDeclared(Transaction transaction, YapClass yapClass, YapObject yapObject, ObjectHeaderAttributes1 objectHeaderAttributes1, YapReader yapReader, int n) {
        int n2 = yapClass.readFieldCount(yapReader);
        for (int i = 0; i < n2; ++i) {
            if (!objectHeaderAttributes1.isNull(n)) {
                yapClass.i_fields[i].readVirtualAttribute(transaction, yapReader, yapObject);
            }
            ++n;
        }
        if (yapClass.i_ancestor != null) {
            this.readVirtualAttributesDeclared(transaction, yapClass.i_ancestor, yapObject, objectHeaderAttributes1, yapReader, n);
        }
    }
}

