/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.handlers;

import com.db4o.YapStream;
import com.db4o.handlers.NetSimpleTypeHandler;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class NetDateTime
extends NetSimpleTypeHandler {
    private static final String ZEROES = "0000";
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final long ERA_DIFFERENCE_IN_MS = 62135596800000L;
    private static final long TICKS_TO_MS_RATIO = 10000L;

    public NetDateTime(YapStream yapStream) {
        super(yapStream, 25, 8);
    }

    public String toString(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = (l << 8) + (long)(byArray[i] & 0xFF);
        }
        long l2 = l / 10000L - 62135596800000L;
        Date date = new Date(l2);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer().append(this.prependZeroes(calendar.get(1), 4)).append('-').append(MONTHS[calendar.get(2)]).append('-').append(this.prependZeroes(calendar.get(5), 2)).append(", ").append(this.prependZeroes(calendar.get(11), 2)).append(':').append(this.prependZeroes(calendar.get(12), 2)).append(':').append(this.prependZeroes(calendar.get(13), 2)).append('.').append(this.prependZeroes(calendar.get(14), 3)).append(" UTC");
        return stringBuffer.toString();
    }

    private String prependZeroes(int n, int n2) {
        String string = String.valueOf(n);
        int n3 = n2 - string.length();
        if (n3 > 0) {
            string = ZEROES.substring(0, n3) + string;
        }
        return string;
    }
}

