/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.QueryResultImpl;
import com.db4o.Transaction;
import com.db4o.Tree;
import com.db4o.TreeInt;
import com.db4o.TreeIntObject;
import com.db4o.VisitorYapBytes;
import com.db4o.YapReader;
import com.db4o.YapStream;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.network.YapSocket;
import java.io.IOException;

public final class YapWriter
extends YapReader {
    private int i_address;
    private int _addressOffset;
    private int i_cascadeDelete;
    private Tree i_embedded;
    private int i_id;
    private int i_instantionDepth;
    private int i_length;
    Transaction i_trans;
    private int i_updateDepth = 1;
    public int _payloadOffset;

    public YapWriter(Transaction transaction, int n) {
        this.i_trans = transaction;
        this.i_length = n;
        this._buffer = new byte[this.i_length];
    }

    public YapWriter(Transaction transaction, int n, int n2) {
        this(transaction, n2);
        this.i_address = n;
    }

    YapWriter(YapWriter yapWriter, YapWriter[] yapWriterArray, int n) {
        yapWriterArray[n++] = this;
        int n2 = yapWriter.readInt();
        this.i_length = yapWriter.readInt();
        this.i_id = yapWriter.readInt();
        yapWriterArray[n2].addEmbedded(this);
        this.i_address = yapWriter.readInt();
        this.i_trans = yapWriter.getTransaction();
        this._buffer = new byte[this.i_length];
        System.arraycopy(yapWriter._buffer, yapWriter._offset, this._buffer, 0, this.i_length);
        yapWriter._offset += this.i_length;
        if (n < yapWriterArray.length) {
            new YapWriter(yapWriter, yapWriterArray, n);
        }
    }

    void addEmbedded(YapWriter yapWriter) {
        this.i_embedded = Tree.add(this.i_embedded, new TreeIntObject(yapWriter.getID(), yapWriter));
    }

    int appendTo(final YapWriter yapWriter, int n) {
        yapWriter.writeInt(this.i_length);
        yapWriter.writeInt(this.i_id);
        yapWriter.writeInt(this.i_address);
        yapWriter.append(this._buffer);
        final int[] nArray = new int[]{++n};
        final int n2 = n;
        this.forEachEmbedded(new VisitorYapBytes(){

            public void visit(YapWriter yapWriter2) {
                yapWriter.writeInt(n2);
                nArray[0] = yapWriter2.appendTo(yapWriter, nArray[0]);
            }
        });
        return nArray[0];
    }

    public int cascadeDeletes() {
        return this.i_cascadeDelete;
    }

    public void debugCheckBytes() {
    }

    int embeddedCount() {
        final int[] nArray = new int[]{0};
        this.forEachEmbedded(new VisitorYapBytes(){

            public void visit(YapWriter yapWriter) {
                nArray[0] = nArray[0] + (1 + yapWriter.embeddedCount());
            }
        });
        return nArray[0];
    }

    int embeddedLength() {
        final int[] nArray = new int[]{0};
        this.forEachEmbedded(new VisitorYapBytes(){

            public void visit(YapWriter yapWriter) {
                nArray[0] = nArray[0] + (yapWriter.getLength() + yapWriter.embeddedLength());
            }
        });
        return nArray[0];
    }

    void forEachEmbedded(final VisitorYapBytes visitorYapBytes) {
        if (this.i_embedded != null) {
            this.i_embedded.traverse(new Visitor4(){

                public void visit(Object object) {
                    visitorYapBytes.visit((YapWriter)((TreeIntObject)object)._object);
                }
            });
        }
    }

    public int getAddress() {
        return this.i_address;
    }

    public int addressOffset() {
        return this._addressOffset;
    }

    public int getID() {
        return this.i_id;
    }

    public int getInstantiationDepth() {
        return this.i_instantionDepth;
    }

    public int getLength() {
        return this.i_length;
    }

    public YapStream getStream() {
        return this.i_trans.i_stream;
    }

    public Transaction getTransaction() {
        return this.i_trans;
    }

    public int getUpdateDepth() {
        return this.i_updateDepth;
    }

    byte[] getWrittenBytes() {
        byte[] byArray = new byte[this._offset];
        System.arraycopy(this._buffer, 0, byArray, 0, this._offset);
        return byArray;
    }

    public int preparePayloadRead() {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this._offset;
        this._offset = n;
        this._payloadOffset += n2;
        return n3;
    }

    public void read() {
        this.i_trans.i_stream.readBytes(this._buffer, this.i_address, this._addressOffset, this.i_length);
    }

    final boolean read(YapSocket yapSocket) throws IOException {
        int n;
        int n2 = 0;
        for (int i = this.i_length; i > 0; i -= n) {
            n = yapSocket.read(this._buffer, n2, i);
            if (n < 0) {
                return false;
            }
            n2 += n;
        }
        return true;
    }

    public final YapWriter readEmbeddedObject() {
        int n = this.readInt();
        int n2 = this.readInt();
        YapWriter yapWriter = null;
        TreeInt treeInt = TreeInt.find(this.i_embedded, n);
        if (treeInt != null) {
            yapWriter = (YapWriter)((TreeIntObject)treeInt)._object;
        } else {
            yapWriter = this.i_trans.i_stream.readObjectWriterByAddress(this.i_trans, n, n2);
            if (yapWriter != null) {
                yapWriter.setID(n);
            }
        }
        if (yapWriter != null) {
            yapWriter.setUpdateDepth(this.getUpdateDepth());
            yapWriter.setInstantiationDepth(this.getInstantiationDepth());
        }
        return yapWriter;
    }

    final YapWriter readYapBytes() {
        int n = this.readInt();
        if (n == 0) {
            return null;
        }
        YapWriter yapWriter = new YapWriter(this.i_trans, n);
        System.arraycopy(this._buffer, this._offset, yapWriter._buffer, 0, n);
        this._offset += n;
        return yapWriter;
    }

    void removeFirstBytes(int n) {
        this.i_length -= n;
        byte[] byArray = new byte[this.i_length];
        System.arraycopy(this._buffer, n, byArray, 0, this.i_length);
        this._buffer = byArray;
        this._offset -= n;
        if (this._offset < 0) {
            this._offset = 0;
        }
    }

    void address(int n) {
        this.i_address = n;
    }

    public void setCascadeDeletes(int n) {
        this.i_cascadeDelete = n;
    }

    public void setID(int n) {
        this.i_id = n;
    }

    public void setInstantiationDepth(int n) {
        this.i_instantionDepth = n;
    }

    void setTransaction(Transaction transaction) {
        this.i_trans = transaction;
    }

    public void setUpdateDepth(int n) {
        this.i_updateDepth = n;
    }

    public void slotDelete() {
        this.i_trans.slotDelete(this.i_id, this.i_address, this.i_length);
    }

    void trim4(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this._buffer, n, byArray, 0, n2);
        this._buffer = byArray;
        this.i_length = n2;
    }

    void useSlot(int n) {
        this.i_address = n;
        this._offset = 0;
    }

    void useSlot(int n, int n2) {
        this.i_address = n;
        this._offset = 0;
        if (n2 > this._buffer.length) {
            this._buffer = new byte[n2];
        }
        this.i_length = n2;
    }

    public void useSlot(int n, int n2, int n3) {
        this.i_id = n;
        this.useSlot(n2, n3);
    }

    void write() {
        this.i_trans.i_file.writeBytes(this, this.i_address, this._addressOffset);
    }

    void writeEmbedded() {
        final YapWriter yapWriter = this;
        this.forEachEmbedded(new VisitorYapBytes(){

            public void visit(YapWriter yapWriter2) {
                yapWriter2.writeEmbedded();
                YapWriter.this.i_trans.i_stream.writeEmbedded(yapWriter, yapWriter2);
            }
        });
        this.i_embedded = null;
    }

    public void writeEmbeddedNull() {
        this.writeInt(0);
        this.writeInt(0);
    }

    public void writeEncrypt() {
        this.i_trans.i_stream.i_handlers.encrypt(this);
        this.i_trans.i_file.writeBytes(this, this.i_address, this._addressOffset);
        this.i_trans.i_stream.i_handlers.decrypt(this);
    }

    public void writePayload(YapWriter yapWriter, boolean bl) {
        this.checkMinimumPayLoadOffsetAndWritePointerAndLength(yapWriter.getLength(), bl);
        System.arraycopy(yapWriter._buffer, 0, this._buffer, this._payloadOffset, yapWriter._buffer.length);
        this.transferPayLoadAddress(yapWriter, this._payloadOffset);
        this._payloadOffset += yapWriter._buffer.length;
    }

    private void checkMinimumPayLoadOffsetAndWritePointerAndLength(int n, boolean bl) {
        if (this._payloadOffset <= this._offset + 8) {
            this._payloadOffset = this._offset + 8;
        }
        if (bl) {
            this._payloadOffset = this.getStream().alignToBlockSize(this._payloadOffset);
        }
        this.writeInt(this._payloadOffset);
        this.writeInt(n);
    }

    public int reserveAndPointToPayLoadSlot(int n) {
        this.checkMinimumPayLoadOffsetAndWritePointerAndLength(n, false);
        int n2 = this._offset;
        this._offset = this._payloadOffset;
        this._payloadOffset += n;
        return n2;
    }

    public YapWriter readPayloadWriter(int n, int n2) {
        YapWriter yapWriter = new YapWriter(this.i_trans, 0, n2);
        System.arraycopy(this._buffer, n, yapWriter._buffer, 0, n2);
        this.transferPayLoadAddress(yapWriter, n);
        return yapWriter;
    }

    private void transferPayLoadAddress(YapWriter yapWriter, int n) {
        int n2 = n / this.getStream().blockSize();
        yapWriter.i_id = yapWriter.i_address = this.i_address + n2;
        yapWriter._addressOffset = this._addressOffset;
    }

    final void writeQueryResult(QueryResultImpl queryResultImpl) {
        int n = queryResultImpl.size();
        this.writeInt(n);
        this._offset += (n - 1) * 4;
        int n2 = 8;
        for (int i = 0; i < n; ++i) {
            this.writeInt(queryResultImpl.nextInt());
            this._offset -= n2;
        }
    }

    void writeShortString(String string) {
        this.writeShortString(this.i_trans, string);
    }

    public void moveForward(int n) {
        this._addressOffset += n;
    }

    public void writeForward() {
        this.write();
        this._addressOffset += this.i_length;
        this._offset = 0;
    }

    public String toString() {
        return super.toString();
    }
}

