/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.ClassIndex;
import com.db4o.Config4Impl;
import com.db4o.CorruptionException;
import com.db4o.Db4o;
import com.db4o.Db4oTypeImpl;
import com.db4o.Debug;
import com.db4o.Internal4;
import com.db4o.Message;
import com.db4o.Messages;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.PBootRecord;
import com.db4o.Platform4;
import com.db4o.QQuery;
import com.db4o.QueryResultImpl;
import com.db4o.Rename;
import com.db4o.ReplicationImpl;
import com.db4o.Transaction;
import com.db4o.Tree;
import com.db4o.TreeInt;
import com.db4o.TreeIntObject;
import com.db4o.UseSystemTransaction;
import com.db4o.YapArray;
import com.db4o.YapClass;
import com.db4o.YapClassCollection;
import com.db4o.YapConst;
import com.db4o.YapField;
import com.db4o.YapHandlers;
import com.db4o.YapObject;
import com.db4o.YapObjectCarrier;
import com.db4o.YapReader;
import com.db4o.YapReferences;
import com.db4o.YapStream;
import com.db4o.YapStreamSpec;
import com.db4o.YapStringIO;
import com.db4o.YapWriter;
import com.db4o.config.Configuration;
import com.db4o.config.Entry;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oException;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ExtObjectContainer;
import com.db4o.ext.MemoryFile;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.Exceptions4;
import com.db4o.inside.marshall.MarshallerFamily;
import com.db4o.inside.query.NativeQueryHandler;
import com.db4o.inside.query.ObjectSetFacade;
import com.db4o.inside.replication.Db4oReplicationReferenceProvider;
import com.db4o.inside.replication.MigrationConnection;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.replication.ReplicationConflictHandler;
import com.db4o.replication.ReplicationProcess;
import com.db4o.types.Db4oCollections;
import com.db4o.types.Db4oType;
import com.db4o.types.SecondClass;
import com.db4o.types.TransientClass;

public abstract class YapStreamBase
implements TransientClass,
Internal4,
YapStreamSpec {
    public static final int HEADER_LENGTH = 18;
    private boolean i_amDuringFatalExit = false;
    public YapClassCollection i_classCollection;
    public Config4Impl i_config;
    protected int i_entryCounter;
    private YapObject i_hcTree;
    private YapObject i_idTree;
    private Tree[] i_justActivated;
    private Tree[] i_justDeactivated;
    private Tree i_justPeeked;
    private Tree i_justSet;
    final Object i_lock;
    private List4 i_needsUpdate;
    final YapStream i_parent;
    boolean i_refreshInsteadOfActivate;
    int i_showInternalClasses = 0;
    private List4 i_stillToActivate;
    private List4 i_stillToDeactivate;
    private List4 i_stillToSet;
    Transaction i_systemTrans;
    Transaction i_trans;
    private boolean i_instantiating;
    public YapHandlers i_handlers;
    int _replicationCallState;
    YapReferences i_references;
    private NativeQueryHandler _nativeQueryHandler;
    private final YapStream _this = YapStreamBase.cast(this);

    protected YapStreamBase(YapStream yapStream) {
        this.i_parent = yapStream == null ? this._this : yapStream;
        this.i_lock = yapStream == null ? new Object() : yapStream.i_lock;
        this.initialize0();
        this.createTransaction();
        this.initialize1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(Object object, int n) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.activate1(null, object, n);
        }
    }

    final void activate1(Transaction transaction, Object object) {
        this.activate1(transaction, object, this.i_config.activationDepth());
    }

    public final void activate1(Transaction transaction, Object object, int n) {
        transaction = this.checkTransaction(transaction);
        this.beginEndActivation();
        this.activate2(transaction, object, n);
        this.beginEndActivation();
    }

    final void beginEndActivation() {
        this.i_justActivated[0] = null;
    }

    final void beginEndSet(Transaction transaction) {
        this.i_justSet = null;
        if (transaction != null) {
            transaction.beginEndSet();
        }
    }

    final void activate2(Transaction transaction, Object object, int n) {
        ++this.i_entryCounter;
        try {
            this.stillToActivate(object, n);
            this.activate3CheckStill(transaction);
        }
        catch (Throwable throwable) {
            this.fatalException(throwable);
        }
        --this.i_entryCounter;
    }

    final void activate3CheckStill(Transaction transaction) {
        while (this.i_stillToActivate != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_stillToActivate);
            this.i_stillToActivate = null;
            while (iterator4Impl.hasNext()) {
                YapObject yapObject = (YapObject)iterator4Impl.next();
                int n = (Integer)iterator4Impl.next();
                Object object = yapObject.getObject();
                if (object == null) {
                    this.yapObjectGCd(yapObject);
                    continue;
                }
                yapObject.activate1(transaction, object, n, this.i_refreshInsteadOfActivate);
            }
        }
    }

    public int alignToBlockSize(int n) {
        return this.blocksFor(n) * this.blockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Object object, long l) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.bind1(null, object, l);
        }
    }

    final void bind1(Transaction transaction, Object object, long l) {
        YapObject yapObject;
        Object object2;
        transaction = this.checkTransaction(transaction);
        int n = (int)l;
        if (object != null && (object2 = this.getByID(l)) != null && (yapObject = this.getYapObject(n)) != null) {
            if (transaction.reflector().forObject(object) == yapObject.getYapClass().classReflector()) {
                this.bind2(yapObject, object);
            } else {
                throw new RuntimeException(Messages.get(57));
            }
        }
    }

    final void bind2(YapObject yapObject, Object object) {
        int n = yapObject.getID();
        this.yapObjectGCd(yapObject);
        yapObject = new YapObject(this.getYapClass(this.reflector().forObject(object), false), n);
        yapObject.setObjectWeak(this._this, object);
        yapObject.setStateDirty();
        this.idTreeAdd(yapObject);
        this.hcTreeAdd(yapObject);
    }

    public byte blockSize() {
        return 1;
    }

    public int blocksFor(long l) {
        byte by = this.blockSize();
        int n = (int)(l / (long)by);
        if (l % (long)by != 0L) {
            ++n;
        }
        return n;
    }

    public abstract PBootRecord bootRecord();

    private final boolean breakDeleteForEnum(YapObject yapObject, boolean bl) {
        if (bl) {
            return false;
        }
        if (yapObject == null) {
            return false;
        }
        return Platform4.jdk().isEnum(this.reflector(), yapObject.getYapClass().classReflector());
    }

    boolean canUpdate() {
        return true;
    }

    final void checkClosed() {
        if (this.i_classCollection == null) {
            Exceptions4.throwRuntimeException(20, this.toString());
        }
    }

    final void checkNeededUpdates() {
        if (this.i_needsUpdate != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_needsUpdate);
            while (iterator4Impl.hasNext()) {
                YapClass yapClass = (YapClass)iterator4Impl.next();
                yapClass.setStateDirty();
                yapClass.write(this.i_systemTrans);
            }
            this.i_needsUpdate = null;
        }
    }

    final Transaction checkTransaction(Transaction transaction) {
        this.checkClosed();
        if (transaction != null) {
            return transaction;
        }
        return this.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        Object object = Db4o.lock;
        synchronized (object) {
            Object object2 = this.i_lock;
            synchronized (object2) {
                boolean bl = this.close1();
                return bl;
            }
        }
    }

    final boolean close1() {
        if (this.i_classCollection == null) {
            return true;
        }
        Platform4.preClose(this._this);
        this.checkNeededUpdates();
        if (this.stateMessages()) {
            this.logMsg(2, this.toString());
        }
        boolean bl = this.close2();
        return bl;
    }

    boolean close2() {
        if (this.hasShutDownHook()) {
            Platform4.removeShutDownHook(this, this.i_lock);
        }
        this.i_classCollection = null;
        this.i_references.stopTimer();
        this.i_hcTree = null;
        this.i_idTree = null;
        this.i_systemTrans = null;
        this.i_trans = null;
        if (this.stateMessages()) {
            this.logMsg(3, this.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oCollections collections() {
        Object object = this.i_lock;
        synchronized (object) {
            if (this.i_handlers.i_collections == null) {
                this.i_handlers.i_collections = Platform4.collections(this);
            }
            return this.i_handlers.i_collections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this.i_lock;
        synchronized (object) {
            this.commit1();
        }
    }

    abstract void commit1();

    public Configuration configure() {
        return this.i_config;
    }

    abstract ClassIndex createClassIndex(YapClass var1);

    abstract QueryResultImpl createQResult(Transaction var1);

    void createStringIO(byte by) {
        this.setStringIo(YapStringIO.forEncoding(by));
    }

    void createTransaction() {
        this.i_systemTrans = new Transaction(this._this, null);
        this.i_trans = new Transaction(this._this, this.i_systemTrans);
    }

    abstract long currentVersion();

    boolean createYapClass(YapClass yapClass, ReflectClass reflectClass, YapClass yapClass2) {
        return yapClass.init(this._this, yapClass2, reflectClass, false);
    }

    public Db4oType db4oTypeStored(Transaction transaction, Object object) {
        if (object instanceof Db4oDatabase) {
            Db4oDatabase db4oDatabase = (Db4oDatabase)object;
            if (this.getYapObject(object) != null) {
                return db4oDatabase;
            }
            this.showInternalClasses(true);
            Db4oDatabase db4oDatabase2 = db4oDatabase.query(transaction);
            this.showInternalClasses(false);
            return db4oDatabase2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(Object object, int n) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.deactivate1(object, n);
        }
    }

    final void deactivate1(Object object, int n) {
        this.checkClosed();
        ++this.i_entryCounter;
        try {
            this.i_justDeactivated[0] = null;
            this.deactivate2(object, n);
            this.i_justDeactivated[0] = null;
        }
        catch (Throwable throwable) {
            this.fatalException(throwable);
        }
        --this.i_entryCounter;
    }

    private final void deactivate2(Object object, int n) {
        this.stillToDeactivate(object, n, true);
        while (this.i_stillToDeactivate != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_stillToDeactivate);
            this.i_stillToDeactivate = null;
            while (iterator4Impl.hasNext()) {
                ((YapObject)iterator4Impl.next()).deactivate(this.i_trans, (Integer)iterator4Impl.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            Transaction transaction = this.delete1(null, object, true);
            transaction.beginEndSet();
        }
    }

    final Transaction delete1(Transaction transaction, Object object, boolean bl) {
        transaction = this.checkTransaction(transaction);
        if (object != null) {
            ++this.i_entryCounter;
            try {
                this.delete2(transaction, object, bl);
            }
            catch (Throwable throwable) {
                this.fatalException(throwable);
            }
            --this.i_entryCounter;
        }
        return transaction;
    }

    private final void delete2(Transaction transaction, Object object, boolean bl) {
        YapObject yapObject = this.getYapObject(object);
        if (yapObject != null) {
            this.delete3(transaction, yapObject, object, 0, bl);
        }
    }

    final void delete3(Transaction transaction, YapObject yapObject, Object object, int n, boolean bl) {
        if (this.breakDeleteForEnum(yapObject, bl)) {
            return;
        }
        if (object instanceof SecondClass) {
            this.delete4(transaction, yapObject, object, n, bl);
        } else {
            transaction.delete(yapObject, n);
        }
    }

    final void delete4(Transaction transaction, YapObject yapObject, Object object, int n, boolean bl) {
        if (yapObject != null && yapObject.beginProcessing()) {
            if (this.breakDeleteForEnum(yapObject, bl)) {
                return;
            }
            YapClass yapClass = yapObject.getYapClass();
            Object object2 = yapObject.getObject();
            yapObject.endProcessing();
            if (!yapClass.dispatchEvent(this._this, object2, 0)) {
                return;
            }
            yapObject.beginProcessing();
            if (this.delete5(transaction, yapObject, n, bl)) {
                yapClass.dispatchEvent(this._this, object2, 1);
                if (this.i_config.messageLevel() > 1) {
                    this.message("" + yapObject.getID() + " delete " + yapObject.getYapClass().getName());
                }
            }
            yapObject.endProcessing();
        }
    }

    abstract boolean delete5(Transaction var1, YapObject var2, int var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object descend(Object object, String[] stringArray) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.descend1(this.checkTransaction(null), object, stringArray);
        }
    }

    private Object descend1(Transaction transaction, Object object, String[] stringArray) {
        String[] stringArray2;
        YapObject yapObject = this.getYapObject(object);
        if (yapObject == null) {
            return null;
        }
        Object object2 = null;
        final String string = stringArray[0];
        if (string == null) {
            return null;
        }
        YapClass yapClass = yapObject.getYapClass();
        final YapField[] yapFieldArray = new YapField[]{null};
        yapClass.forEachYapField(new Visitor4(){

            public void visit(Object object) {
                YapField yapField = (YapField)object;
                if (yapField.canAddToQuery(string)) {
                    yapFieldArray[0] = yapField;
                }
            }
        });
        if (yapFieldArray[0] == null) {
            return null;
        }
        if (yapObject.isActive()) {
            object2 = yapFieldArray[0].get(object);
        } else {
            stringArray2 = this.readReaderByID(transaction, yapObject.getID());
            if (stringArray2 == null) {
                return null;
            }
            MarshallerFamily marshallerFamily = yapClass.findOffset((YapReader)stringArray2, yapFieldArray[0]);
            if (marshallerFamily == null) {
                return null;
            }
            try {
                object2 = yapFieldArray[0].readQuery(transaction, marshallerFamily, (YapReader)stringArray2);
            }
            catch (CorruptionException corruptionException) {
                // empty catch block
            }
        }
        if (stringArray.length == 1) {
            return object2;
        }
        if (object2 == null) {
            return null;
        }
        stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        return this.descend1(transaction, object2, stringArray2);
    }

    boolean detectSchemaChanges() {
        return this.i_config.detectSchemaChanges();
    }

    public boolean dispatchsEvents() {
        return true;
    }

    protected boolean doFinalize() {
        return true;
    }

    void emergencyClose() {
        this.i_classCollection = null;
        this.i_references.stopTimer();
    }

    public ExtObjectContainer ext() {
        return this._this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failedToShutDown() {
        Object object = Db4o.lock;
        synchronized (object) {
            if (this.i_classCollection != null) {
                if (this.i_entryCounter == 0) {
                    Messages.logErr(this.i_config, 50, this.toString(), null);
                    while (!this.close()) {
                    }
                } else {
                    this.emergencyClose();
                    if (this.i_entryCounter > 0) {
                        Messages.logErr(this.i_config, 24, null, null);
                    }
                }
            }
        }
    }

    void fatalException(int n) {
        this.fatalException(null, n);
    }

    void fatalException(Throwable throwable) {
        this.fatalException(throwable, 44);
    }

    void fatalException(Throwable throwable, int n) {
        if (!this.i_amDuringFatalExit) {
            this.i_amDuringFatalExit = true;
            this.i_classCollection = null;
            this.emergencyClose();
            Messages.logErr(this.i_config, n == 44 ? 18 : n, null, throwable);
        }
        throw new RuntimeException(Messages.get(n));
    }

    protected void finalize() {
        if (this.doFinalize() && (this.i_config == null || this.i_config.automaticShutDown())) {
            this.failedToShutDown();
        }
    }

    void gc() {
        this.i_references.pollReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet get(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.get1(null, object);
        }
    }

    ObjectSetFacade get1(Transaction transaction, Object object) {
        transaction = this.checkTransaction(transaction);
        QueryResultImpl queryResultImpl = this.createQResult(transaction);
        ++this.i_entryCounter;
        try {
            this.get2(transaction, object, queryResultImpl);
        }
        catch (Throwable throwable) {
            Exceptions4.catchAll(throwable);
            this.fatalException(throwable);
        }
        --this.i_entryCounter;
        queryResultImpl.reset();
        return new ObjectSetFacade(queryResultImpl);
    }

    private final void get2(Transaction transaction, Object object, QueryResultImpl queryResultImpl) {
        if (object == null || object.getClass() == YapConst.CLASS_OBJECT) {
            this.getAll(transaction, queryResultImpl);
        } else {
            Query query = this.querySharpenBug(transaction);
            query.constrain(object);
            ((QQuery)query).execute1(queryResultImpl);
        }
    }

    abstract void getAll(Transaction var1, QueryResultImpl var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getByID(long l) {
        Object object = this.i_lock;
        synchronized (object) {
            return this.getByID1(null, l);
        }
    }

    final Object getByID1(Transaction transaction, long l) {
        transaction = this.checkTransaction(transaction);
        try {
            return this.getByID2(transaction, (int)l);
        }
        catch (Exception exception) {
            return null;
        }
    }

    final Object getByID2(Transaction transaction, int n) {
        if (n > 0) {
            YapObject yapObject = this.getYapObject(n);
            if (yapObject != null) {
                Object object = yapObject.getObject();
                if (object != null) {
                    return object;
                }
                this.yapObjectGCd(yapObject);
            }
            try {
                return new YapObject(n).read(transaction, null, null, 0, 1, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    final Object getActivatedObjectFromCache(Transaction transaction, int n) {
        Object object = this.getObjectFromCache(transaction, n);
        if (object == null) {
            return null;
        }
        this.beginEndActivation();
        this.activate2(transaction, object, this.i_config.activationDepth());
        this.beginEndActivation();
        return object;
    }

    final Object getObjectFromCache(Transaction transaction, int n) {
        if (n <= 0) {
            return null;
        }
        YapObject yapObject = this.getYapObject(n);
        if (yapObject == null) {
            return null;
        }
        Object object = yapObject.getObject();
        if (object == null) {
            this.yapObjectGCd(yapObject);
            return null;
        }
        return object;
    }

    final Object readActivatedObjectNotInCache(Transaction transaction, int n) {
        Object object = null;
        this.beginEndActivation();
        try {
            object = new YapObject(n).read(transaction, null, null, this.i_config.activationDepth(), 1, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.activate3CheckStill(transaction);
        this.beginEndActivation();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getByUUID(Db4oUUID db4oUUID) {
        Object object = this.i_lock;
        synchronized (object) {
            if (db4oUUID == null) {
                return null;
            }
            Transaction transaction = this.checkTransaction(null);
            Object[] objectArray = transaction.objectAndYapObjectBySignature(db4oUUID.getLongPart(), db4oUUID.getSignaturePart());
            return objectArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getID(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.getID1(null, object);
        }
    }

    public final int getID1(Transaction transaction, Object object) {
        this.checkClosed();
        if (object == null) {
            return 0;
        }
        YapObject yapObject = this.i_hcTree.hc_find(object);
        if (yapObject != null) {
            return yapObject.getID();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInfo getObjectInfo(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.getYapObject(object);
        }
    }

    final Object[] getObjectAndYapObjectByID(Transaction transaction, int n) {
        Object[] objectArray = new Object[2];
        if (n > 0) {
            YapObject yapObject = this.getYapObject(n);
            if (yapObject != null) {
                Object object = yapObject.getObject();
                if (object != null) {
                    objectArray[0] = object;
                    objectArray[1] = yapObject;
                    return objectArray;
                }
                this.yapObjectGCd(yapObject);
            }
            try {
                yapObject = new YapObject(n);
                objectArray[0] = yapObject.read(transaction, null, null, 0, 1, true);
                if (objectArray[0] == null) {
                    return objectArray;
                }
                if (objectArray[0] != yapObject.getObject()) {
                    return this.getObjectAndYapObjectByID(transaction, n);
                }
                objectArray[1] = yapObject;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return objectArray;
    }

    final YapWriter getWriter(Transaction transaction, int n) {
        return new YapWriter(transaction, n);
    }

    public final YapWriter getWriter(Transaction transaction, int n, int n2) {
        if (Debug.exceedsMaximumBlockSize(n2)) {
            return null;
        }
        return new YapWriter(transaction, n, n2);
    }

    public final Transaction getSystemTransaction() {
        return this.i_systemTrans;
    }

    public final Transaction getTransaction() {
        return this.i_trans;
    }

    final YapClass getYapClass(ReflectClass reflectClass, boolean bl) {
        if (reflectClass == null) {
            return null;
        }
        if (!this.showInternalClasses() && this.i_handlers.ICLASS_INTERNAL.isAssignableFrom(reflectClass)) {
            return null;
        }
        YapClass yapClass = this.i_handlers.getYapClassStatic(reflectClass);
        if (yapClass != null) {
            return yapClass;
        }
        return this.i_classCollection.getYapClass(reflectClass, bl);
    }

    final YapClass getActiveYapClass(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return null;
        }
        if (!this.showInternalClasses() && this.i_handlers.ICLASS_INTERNAL.isAssignableFrom(reflectClass)) {
            return null;
        }
        YapClass yapClass = this.i_handlers.getYapClassStatic(reflectClass);
        if (yapClass != null) {
            return yapClass;
        }
        return this.i_classCollection.getActiveYapClass(reflectClass);
    }

    public YapClass getYapClass(int n) {
        if (n == 0) {
            return null;
        }
        YapClass yapClass = this.i_handlers.getYapClassStatic(n);
        if (yapClass != null) {
            return yapClass;
        }
        return this.i_classCollection.getYapClass(n);
    }

    final YapObject getYapObject(int n) {
        return this.i_idTree.id_find(n);
    }

    public final YapObject getYapObject(Object object) {
        return this.i_hcTree.hc_find(object);
    }

    public YapHandlers handlers() {
        return this.i_handlers;
    }

    boolean needsLockFileThread() {
        if (!Platform4.hasLockFileThread()) {
            return false;
        }
        if (Platform4.hasNio()) {
            return false;
        }
        if (this.i_config.isReadOnly()) {
            return false;
        }
        return this.i_config.lockFile();
    }

    boolean hasShutDownHook() {
        return this.i_config.automaticShutDown();
    }

    final void hcTreeAdd(YapObject yapObject) {
        this.i_hcTree = this.i_hcTree.hc_add(yapObject);
    }

    final void hcTreeRemove(YapObject yapObject) {
        this.i_hcTree = this.i_hcTree.hc_remove(yapObject);
    }

    final void idTreeAdd(YapObject yapObject) {
        this.i_idTree = this.i_idTree.id_add(yapObject);
    }

    final void idTreeRemove(int n) {
        this.i_idTree = this.i_idTree.id_remove(n);
    }

    void initialize0() {
        this.initialize0b();
        this.i_stillToSet = null;
        this.i_justActivated = new Tree[1];
    }

    void initialize0b() {
        this.i_justDeactivated = new Tree[1];
    }

    void initialize1() {
        this.i_config = (Config4Impl)((DeepClone)((Object)Db4o.configure())).deepClone(this);
        this.i_handlers = new YapHandlers(this._this, this.i_config.encoding(), this.i_config.reflector());
        if (this.i_references != null) {
            this.gc();
            this.i_references.stopTimer();
        }
        this.i_references = new YapReferences(this._this);
        if (this.hasShutDownHook()) {
            Platform4.addShutDownHook(this, this.i_lock);
        }
        this.i_handlers.initEncryption(this.i_config);
        this.initialize2();
        this.i_stillToSet = null;
    }

    void initialize2() {
        this.i_idTree = new YapObject(0);
        this.i_idTree.setObject(new Object());
        this.i_hcTree = this.i_idTree;
        this.initialize2NObjectCarrier();
    }

    void initialize2NObjectCarrier() {
        this.i_classCollection = new YapClassCollection(this.i_systemTrans);
        this.i_references.startTimer();
    }

    void initialize3() {
        this.i_showInternalClasses = 100000;
        this.initialize4NObjectCarrier();
        this.i_showInternalClasses = 0;
    }

    void initialize4NObjectCarrier() {
        this.initializeEssentialClasses();
        this.rename(this.i_config);
        this.i_classCollection.initOnUp(this.i_systemTrans);
        if (this.i_config.detectSchemaChanges()) {
            this.i_systemTrans.commit();
        }
    }

    void initializeEssentialClasses() {
        for (int i = 0; i < YapConst.ESSENTIAL_CLASSES.length; ++i) {
            this.getYapClass(this.reflector().forClass(YapConst.ESSENTIAL_CLASSES[i]), true);
        }
    }

    final void instantiating(boolean bl) {
        this.i_instantiating = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.isActive1(object);
        }
    }

    final boolean isActive1(Object object) {
        YapObject yapObject;
        this.checkClosed();
        if (object != null && (yapObject = this.getYapObject(object)) != null) {
            return yapObject.isActive();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(long l) {
        Object object = this.i_lock;
        synchronized (object) {
            Object object2;
            YapObject yapObject;
            return l > 0L && (yapObject = this.getYapObject((int)l)) != null && (object2 = yapObject.getObject()) != null;
            {
            }
        }
    }

    public boolean isClient() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.i_lock;
        synchronized (object) {
            return this.i_classCollection == null;
        }
    }

    final boolean isInstantiating() {
        return this.i_instantiating;
    }

    boolean isServer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStored(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.isStored1(object);
        }
    }

    final boolean isStored1(Object object) {
        Transaction transaction = this.checkTransaction(null);
        if (object == null) {
            return false;
        }
        YapObject yapObject = this.getYapObject(object);
        if (yapObject == null) {
            return false;
        }
        return !transaction.isDeleted(yapObject.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectClass[] knownClasses() {
        Object object = this.i_lock;
        synchronized (object) {
            this.checkClosed();
            return this.reflector().knownClasses();
        }
    }

    public Object lock() {
        return this.i_lock;
    }

    final void logMsg(int n, String string) {
        Messages.logMsg(this.i_config, n, string);
    }

    boolean maintainsIndices() {
        return true;
    }

    YapWriter marshall(Transaction transaction, Object object) {
        int[] nArray = new int[]{0};
        byte[] byArray = this.marshall(object, nArray);
        YapWriter yapWriter = new YapWriter(transaction, byArray.length);
        yapWriter.append(byArray);
        yapWriter.useSlot(nArray[0], 0, byArray.length);
        return yapWriter;
    }

    byte[] marshall(Object object, int[] nArray) {
        MemoryFile memoryFile = new MemoryFile();
        memoryFile.setInitialSize(223);
        memoryFile.setIncrementSizeBy(300);
        this.getYapClass(this.reflector().forObject(object), true);
        YapObjectCarrier yapObjectCarrier = new YapObjectCarrier(this._this, memoryFile);
        yapObjectCarrier.i_showInternalClasses = this.i_showInternalClasses;
        yapObjectCarrier.set(object);
        nArray[0] = (int)yapObjectCarrier.getID(object);
        yapObjectCarrier.close();
        return memoryFile.getBytes();
    }

    void message(String string) {
        new Message(this._this, string);
    }

    public void migrateFrom(ObjectContainer objectContainer) {
        if (objectContainer == null) {
            if (this._replicationCallState == 0) {
                return;
            }
            this._replicationCallState = 0;
            if (this.i_handlers.i_migration != null) {
                this.i_handlers.i_migration.terminate();
            }
            this.i_handlers.i_migration = null;
        } else {
            YapStream yapStream = (YapStream)objectContainer;
            this._replicationCallState = -1;
            yapStream._replicationCallState = -1;
            yapStream.i_handlers.i_migration = this.i_handlers.i_migration = new MigrationConnection(this._this, (YapStream)objectContainer);
        }
    }

    final void needsUpdate(YapClass yapClass) {
        this.i_needsUpdate = new List4(this.i_needsUpdate, yapClass);
    }

    public abstract int newUserObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekPersisted(Object object, int n, boolean bl) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.checkClosed();
            ++this.i_entryCounter;
            this.i_justPeeked = null;
            Transaction transaction = bl ? this.i_systemTrans : this.checkTransaction(null);
            Object object3 = null;
            YapObject yapObject = this.getYapObject(object);
            if (yapObject != null) {
                object3 = this.peekPersisted1(transaction, yapObject.getID(), n);
            }
            this.i_justPeeked = null;
            --this.i_entryCounter;
            return object3;
        }
    }

    Object peekPersisted1(Transaction transaction, int n, int n2) {
        if (n2 < 0) {
            return null;
        }
        TreeInt treeInt = new TreeInt(n);
        TreeIntObject treeIntObject = (TreeIntObject)Tree.find(this.i_justPeeked, treeInt);
        if (treeIntObject == null) {
            return new YapObject(n).read(transaction, null, null, n2, -1, false);
        }
        return treeIntObject._object;
    }

    void peeked(int n, Object object) {
        this.i_justPeeked = Tree.add(this.i_justPeeked, new TreeIntObject(n, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Object object = this.i_lock;
        synchronized (object) {
            this.purge1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.purge1(object);
        }
    }

    final void purge1() {
        this.checkClosed();
        System.gc();
        System.runFinalization();
        System.gc();
        this.gc();
        this.i_classCollection.purge();
    }

    final void purge1(Object object) {
        if (object != null && this.i_hcTree != null) {
            YapObject yapObject = null;
            yapObject = object instanceof YapObject ? (YapObject)object : this.i_hcTree.hc_find(object);
            if (yapObject != null) {
                this.yapObjectGCd(yapObject);
            }
        }
    }

    public final NativeQueryHandler getNativeQueryHandler() {
        if (null == this._nativeQueryHandler) {
            this._nativeQueryHandler = new NativeQueryHandler(this._this);
        }
        return this._nativeQueryHandler;
    }

    public final ObjectSet query(Predicate predicate) {
        return this.query(predicate, (QueryComparator)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectSet query(Predicate predicate, QueryComparator queryComparator) {
        Object object = this.i_lock;
        synchronized (object) {
            return this.getNativeQueryHandler().execute(predicate, queryComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query query() {
        Object object = this.i_lock;
        synchronized (object) {
            return this.query((Transaction)null);
        }
    }

    public final ObjectSet query(Class clazz) {
        return this.get(clazz);
    }

    final Query query(Transaction transaction) {
        ++this.i_entryCounter;
        QQuery qQuery = new QQuery(this.checkTransaction(transaction), null, null);
        --this.i_entryCounter;
        return qQuery;
    }

    Query querySharpenBug() {
        return this.query();
    }

    public Query querySharpenBug(Transaction transaction) {
        return this.query(transaction);
    }

    public abstract void raiseVersion(long var1);

    abstract void readBytes(byte[] var1, int var2, int var3);

    abstract void readBytes(byte[] var1, int var2, int var3, int var4);

    public final YapReader readObjectReaderByAddress(int n, int n2) {
        if (n > 0) {
            YapReader yapReader = new YapReader(n2);
            this.readBytes(yapReader._buffer, n, n2);
            this.i_handlers.decrypt(yapReader);
            return yapReader;
        }
        return null;
    }

    public final YapWriter readObjectWriterByAddress(Transaction transaction, int n, int n2) {
        if (n > 0) {
            YapWriter yapWriter = this.getWriter(transaction, n, n2);
            yapWriter.readEncrypt(this._this, n);
            return yapWriter;
        }
        return null;
    }

    public abstract YapWriter readWriterByID(Transaction var1, int var2);

    public abstract YapReader readReaderByID(Transaction var1, int var2);

    private void reboot() {
        this.commit();
        int n = this.i_classCollection.getID();
        this.i_references.stopTimer();
        this.initialize2();
        this.i_classCollection.setID(n);
        this.i_classCollection.read(this.i_systemTrans);
    }

    public GenericReflector reflector() {
        return this.i_handlers._reflector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object object, int n) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.i_refreshInsteadOfActivate = true;
            try {
                this.activate1(null, object, n);
            }
            finally {
                this.i_refreshInsteadOfActivate = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refreshClasses() {
        Object object = this.i_lock;
        synchronized (object) {
            this.i_classCollection.refreshClasses();
        }
    }

    public abstract void releaseSemaphore(String var1);

    void rememberJustSet(int n) {
        this.i_justSet = this.i_justSet == null ? new TreeInt(n) : this.i_justSet.add(new TreeInt(n));
    }

    abstract void releaseSemaphores(Transaction var1);

    void rename(Config4Impl config4Impl) {
        boolean bl = false;
        if (config4Impl.rename() != null) {
            bl = this.rename1(config4Impl);
        }
        this.i_classCollection.checkChanges();
        if (bl) {
            this.reboot();
        }
    }

    protected boolean rename1(Config4Impl config4Impl) {
        boolean bl = false;
        try {
            Iterator4 iterator4 = config4Impl.rename().iterator();
            while (iterator4.hasNext()) {
                Object object;
                Rename rename = (Rename)iterator4.next();
                if (this.get(rename).size() != 0) continue;
                boolean bl2 = false;
                boolean bl3 = rename.rClass.length() > 0;
                YapClass yapClass = this.i_classCollection.getYapClass(bl3 ? rename.rClass : rename.rFrom);
                if (yapClass != null) {
                    if (bl3) {
                        bl2 = yapClass.renameField(rename.rFrom, rename.rTo);
                    } else {
                        object = this.i_classCollection.getYapClass(rename.rTo);
                        if (object == null) {
                            yapClass.setName(rename.rTo);
                            bl2 = true;
                        } else {
                            this.logMsg(9, "class " + rename.rTo);
                        }
                    }
                }
                if (!bl2) continue;
                bl = true;
                this.setDirty(yapClass);
                this.logMsg(8, rename.rFrom + " to " + rename.rTo);
                object = this.get(new Rename(rename.rClass, null, rename.rFrom));
                while (object.hasNext()) {
                    this.delete(object.next());
                }
                this.set(rename);
            }
        }
        catch (Throwable throwable) {
            Messages.logErr(this.i_config, 10, null, throwable);
        }
        return bl;
    }

    public ReplicationProcess replicationBegin(ObjectContainer objectContainer, ReplicationConflictHandler replicationConflictHandler) {
        return new ReplicationImpl(this._this, objectContainer, replicationConflictHandler);
    }

    final int oldReplicationHandles(Object object) {
        int n;
        if (this._replicationCallState != -1) {
            return 0;
        }
        if (this.i_handlers.i_replication == null) {
            return 0;
        }
        if (object instanceof Internal4) {
            return 0;
        }
        YapObject yapObject = this.getYapObject(object);
        if (yapObject != null && (n = yapObject.getID()) > 0 && TreeInt.find(this.i_justSet, n) != null) {
            return n;
        }
        return this.i_handlers.i_replication.tryToHandle(this._this, object);
    }

    void reserve(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Object object = this.i_lock;
        synchronized (object) {
            this.rollback1();
        }
    }

    abstract void rollback1();

    public void send(Object object) {
    }

    public void set(Object object) {
        this.set(object, -2147483548);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(Object object, int n) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.checkClosed();
            this.beginEndSet(this.i_trans);
            this.setInternal(this.i_trans, object, n, true);
            this.beginEndSet(this.i_trans);
        }
    }

    final int setInternal(Transaction transaction, Object object, boolean bl) {
        return this.setInternal(transaction, object, -2147483548, bl);
    }

    public final int setInternal(Transaction transaction, Object object, int n, boolean bl) {
        int n2 = this.oldReplicationHandles(object);
        if (n2 != 0) {
            if (n2 < 0) {
                return 0;
            }
            return n2;
        }
        return this.setAfterReplication(transaction, object, n, bl);
    }

    final int setAfterReplication(Transaction transaction, Object object, int n, boolean bl) {
        int n2;
        Db4oType db4oType;
        if (object instanceof Db4oType && (db4oType = this.db4oTypeStored(transaction, object)) != null) {
            return this.getID1(transaction, db4oType);
        }
        ++this.i_entryCounter;
        try {
            n2 = this.set2(transaction, object, n, bl);
        }
        catch (ObjectNotStorableException objectNotStorableException) {
            --this.i_entryCounter;
            throw objectNotStorableException;
        }
        catch (Db4oException db4oException) {
            boolean bl2 = false;
            throw db4oException;
        }
        catch (Throwable throwable) {
            n2 = 0;
            this.fatalException(throwable);
        }
        --this.i_entryCounter;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setByNewReplication(Db4oReplicationReferenceProvider db4oReplicationReferenceProvider, Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this._replicationCallState = 1;
            this.i_handlers._replicationReferenceProvider = db4oReplicationReferenceProvider;
            this.set2(this.checkTransaction(null), object, 1, false);
            this._replicationCallState = 0;
            this.i_handlers._replicationReferenceProvider = null;
        }
    }

    private final int set2(Transaction transaction, Object object, int n, boolean bl) {
        int n2 = this.set3(transaction, object, n, bl);
        if (this.stackIsSmall()) {
            this.checkStillToSet();
        }
        return n2;
    }

    void checkStillToSet() {
        List4 list4 = null;
        while (this.i_stillToSet != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_stillToSet);
            this.i_stillToSet = null;
            while (iterator4Impl.hasNext()) {
                Transaction transaction;
                Integer n = (Integer)iterator4Impl.next();
                YapObject yapObject = (YapObject)iterator4Impl.next();
                if (yapObject.continueSet(transaction = (Transaction)iterator4Impl.next(), n)) continue;
                list4 = new List4(list4, transaction);
                list4 = new List4(list4, yapObject);
                list4 = new List4(list4, n);
            }
        }
        this.i_stillToSet = list4;
    }

    private void notStorable(ReflectClass reflectClass, Object object) {
        if (!this.i_config.exceptionsOnNotStorable()) {
            return;
        }
    }

    public final int set3(Transaction transaction, Object object, int n, boolean bl) {
        int n2;
        if (object == null || object instanceof TransientClass) {
            return 0;
        }
        if (object instanceof Db4oTypeImpl) {
            ((Db4oTypeImpl)object).storedTo(transaction);
        }
        YapClass yapClass = null;
        YapObject yapObject = this.i_hcTree.hc_find(object);
        if (yapObject == null) {
            ReflectClass reflectClass = this.reflector().forObject(object);
            if (reflectClass == null) {
                this.notStorable(reflectClass, object);
                return 0;
            }
            yapClass = this.getActiveYapClass(reflectClass);
            if (yapClass == null) {
                yapClass = this.getYapClass(reflectClass, true);
                if (yapClass == null) {
                    this.notStorable(reflectClass, object);
                    return 0;
                }
                yapObject = this.i_hcTree.hc_find(object);
            }
        } else {
            yapClass = yapObject.getYapClass();
        }
        if (yapClass.getID() == 11 || yapClass.isPrimitive()) {
            this.notStorable(yapClass.classReflector(), object);
            return 0;
        }
        boolean bl2 = true;
        if (yapObject == null) {
            if (!yapClass.dispatchEvent(this._this, object, 8)) {
                return 0;
            }
            yapObject = new YapObject(0);
            if (yapObject.store(transaction, yapClass, object, n)) {
                this.idTreeAdd(yapObject);
                this.hcTreeAdd(yapObject);
                if (object instanceof Db4oTypeImpl) {
                    ((Db4oTypeImpl)object).setTrans(transaction);
                }
                if (this.i_config.messageLevel() > 1) {
                    this.message("" + yapObject.getID() + " new " + yapObject.getYapClass().getName());
                }
                if (bl && this.canUpdate() && !yapObject.getYapClass().isPrimitive()) {
                    this.rememberJustSet(yapObject.getID());
                    bl = false;
                }
                this.stillToSet(transaction, yapObject, n);
            }
        } else if (this.canUpdate()) {
            boolean bl3;
            n2 = yapObject.getID();
            if (bl && n2 > 0 && TreeInt.find(this.i_justSet, n2) != null) {
                return n2;
            }
            boolean bl4 = bl3 = n == -2147483548 || n > 0;
            if (bl3) {
                bl2 = false;
                transaction.dontDelete(yapObject.getYapClass().getID(), n2);
                if (bl) {
                    bl = false;
                    this.rememberJustSet(n2);
                }
                yapObject.writeUpdate(transaction, n);
            }
        }
        this.checkNeededUpdates();
        n2 = yapObject.getID();
        if (bl && this.canUpdate() && !yapObject.getYapClass().isPrimitive()) {
            this.rememberJustSet(n2);
        }
        if (bl2) {
            transaction.dontDelete(yapObject.getYapClass().getID(), n2);
        }
        return n2;
    }

    abstract void setDirty(UseSystemTransaction var1);

    public abstract boolean setSemaphore(String var1, int var2);

    void setStringIo(YapStringIO yapStringIO) {
        this.i_handlers.i_stringHandler.setStringIo(yapStringIO);
    }

    final boolean showInternalClasses() {
        return this.isServer() || this.i_showInternalClasses > 0;
    }

    public synchronized void showInternalClasses(boolean bl) {
        this.i_showInternalClasses = bl ? ++this.i_showInternalClasses : --this.i_showInternalClasses;
        if (this.i_showInternalClasses < 0) {
            this.i_showInternalClasses = 0;
        }
    }

    private final boolean stackIsSmall() {
        return this.i_entryCounter < 100;
    }

    boolean stateMessages() {
        return true;
    }

    List4 stillTo1(List4 list4, Tree[] treeArray, Object object, int n, boolean bl) {
        if (object != null && n > 0) {
            YapClass yapClass;
            YapObject yapObject = this.i_hcTree.hc_find(object);
            if (yapObject != null) {
                int n2 = yapObject.getID();
                if (treeArray[0] != null) {
                    if (((TreeInt)treeArray[0]).find(n2) != null) {
                        return list4;
                    }
                    treeArray[0] = treeArray[0].add(new TreeInt(n2));
                } else {
                    treeArray[0] = new TreeInt(n2);
                }
                return new List4(new List4(list4, new Integer(n)), yapObject);
            }
            ReflectClass reflectClass = this.reflector().forObject(object);
            if (reflectClass.isArray()) {
                if (!reflectClass.getComponentType().isPrimitive()) {
                    Object[] objectArray = YapArray.toArray(this._this, object);
                    for (int i = 0; i < objectArray.length; ++i) {
                        list4 = this.stillTo1(list4, treeArray, objectArray[i], n, bl);
                    }
                }
            } else if (object instanceof Entry) {
                list4 = this.stillTo1(list4, treeArray, ((Entry)object).key, n, false);
                list4 = this.stillTo1(list4, treeArray, ((Entry)object).value, n, false);
            } else if (bl && (yapClass = this.getYapClass(this.reflector().forObject(object), false)) != null) {
                yapClass.deactivate(this.i_trans, object, n);
            }
        }
        return list4;
    }

    void stillToActivate(Object object, int n) {
        this.i_stillToActivate = this.stillTo1(this.i_stillToActivate, this.i_justActivated, object, n, false);
    }

    void stillToDeactivate(Object object, int n, boolean bl) {
        this.i_stillToDeactivate = this.stillTo1(this.i_stillToDeactivate, this.i_justDeactivated, object, n, bl);
    }

    void stillToSet(Transaction transaction, YapObject yapObject, int n) {
        if (this.stackIsSmall() && yapObject.continueSet(transaction, n)) {
            return;
        }
        this.i_stillToSet = new List4(this.i_stillToSet, transaction);
        this.i_stillToSet = new List4(this.i_stillToSet, yapObject);
        this.i_stillToSet = new List4(this.i_stillToSet, new Integer(n));
    }

    void stopSession() {
        this.i_classCollection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass storedClass(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.checkClosed();
            return this.storedClass1(object);
        }
    }

    YapClass storedClass1(Object object) {
        try {
            ReflectClass reflectClass = this.i_config.reflectorFor(object);
            if (reflectClass != null) {
                return this.getYapClass(reflectClass, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses() {
        Object object = this.i_lock;
        synchronized (object) {
            this.checkClosed();
            return this.i_classCollection.storedClasses();
        }
    }

    public YapStringIO stringIO() {
        return this.i_handlers.i_stringHandler.i_stringIo;
    }

    Object unmarshall(YapWriter yapWriter) {
        return this.unmarshall(yapWriter._buffer, yapWriter.getID());
    }

    Object unmarshall(byte[] byArray, int n) {
        MemoryFile memoryFile = new MemoryFile(byArray);
        YapObjectCarrier yapObjectCarrier = new YapObjectCarrier(this._this, memoryFile);
        Object object = yapObjectCarrier.getByID(n);
        yapObjectCarrier.activate(object, Integer.MAX_VALUE);
        yapObjectCarrier.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long version() {
        Object object = this.i_lock;
        synchronized (object) {
            return this.currentVersion();
        }
    }

    abstract void write(boolean var1);

    abstract void writeDirty();

    public abstract void writeEmbedded(YapWriter var1, YapWriter var2);

    public abstract void writeNew(YapClass var1, YapWriter var2);

    abstract void writeTransactionPointer(int var1);

    public abstract void writeUpdate(YapClass var1, YapWriter var2);

    final void yapObjectGCd(YapObject yapObject) {
        this.hcTreeRemove(yapObject);
        this.idTreeRemove(yapObject.getID());
        yapObject.setID(-1);
        Platform4.killYapRef(yapObject.i_object);
    }

    private static YapStream cast(YapStreamBase yapStreamBase) {
        return (YapStream)yapStreamBase;
    }
}

