/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Db4oTypeImpl;
import com.db4o.Platform4;
import com.db4o.Transaction;
import com.db4o.VirtualAttributes;
import com.db4o.YapClass;
import com.db4o.YapClassPrimitive;
import com.db4o.YapMeta;
import com.db4o.YapReader;
import com.db4o.YapStream;
import com.db4o.YapWriter;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ObjectInfo;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.Exceptions4;
import com.db4o.inside.marshall.MarshallerFamily;
import com.db4o.inside.marshall.ObjectHeader;

public class YapObject
extends YapMeta
implements ObjectInfo {
    private YapClass i_yapClass;
    Object i_object;
    VirtualAttributes i_virtualAttributes;
    protected YapObject id_preceding;
    private YapObject id_subsequent;
    private int id_size;
    private YapObject hc_preceding;
    private YapObject hc_subsequent;
    private int hc_size;
    private int hc_code;

    public YapObject() {
    }

    YapObject(int n) {
        this.i_id = n;
    }

    YapObject(YapClass yapClass, int n) {
        this.i_yapClass = yapClass;
        this.i_id = n;
    }

    void activate(Transaction transaction, Object object, int n, boolean bl) {
        this.activate1(transaction, object, n, bl);
        transaction.i_stream.activate3CheckStill(transaction);
    }

    void activate1(Transaction transaction, Object object, int n, boolean bl) {
        if (object instanceof Db4oTypeImpl) {
            n = ((Db4oTypeImpl)object).adjustReadDepth(n);
        }
        if (n > 0) {
            YapStream yapStream = transaction.i_stream;
            if (bl) {
                if (yapStream.i_config.messageLevel() > 2) {
                    yapStream.message("" + this.getID() + " refresh " + this.i_yapClass.getName());
                }
            } else {
                if (this.isActive() && object != null) {
                    if (n > 1) {
                        if (this.i_yapClass.i_config != null) {
                            n = this.i_yapClass.i_config.adjustActivationDepth(n);
                        }
                        this.i_yapClass.activateFields(transaction, object, n);
                    }
                    return;
                }
                if (yapStream.i_config.messageLevel() > 2) {
                    yapStream.message("" + this.getID() + " activate " + this.i_yapClass.getName());
                }
            }
            this.read(transaction, null, object, n, 0, false);
        }
    }

    final void addToIDTree(YapStream yapStream) {
        if (!(this.i_yapClass instanceof YapClassPrimitive)) {
            yapStream.idTreeAdd(this);
        }
    }

    boolean continueSet(Transaction transaction, int n) {
        if (this.bitIsTrue(4)) {
            if (!this.i_yapClass.stateOKAndAncestors()) {
                return false;
            }
            this.bitFalse(4);
            YapWriter yapWriter = MarshallerFamily.current()._object.marshallNew(transaction, this, n);
            YapStream yapStream = transaction.i_stream;
            yapStream.writeNew(this.i_yapClass, yapWriter);
            Object object = this.getObject();
            this.i_yapClass.dispatchEvent(yapStream, object, 4);
            if (!this.i_yapClass.isPrimitive()) {
                this.i_object = yapStream.i_references.createYapRef(this, object);
            }
            this.setStateClean();
            this.endProcessing();
        }
        return true;
    }

    void deactivate(Transaction transaction, int n) {
        Object object;
        if (n > 0 && (object = this.getObject()) != null) {
            if (object instanceof Db4oTypeImpl) {
                ((Db4oTypeImpl)object).preDeactivate();
            }
            YapStream yapStream = transaction.i_stream;
            if (yapStream.i_config.messageLevel() > 2) {
                yapStream.message("" + this.getID() + " deactivate " + this.i_yapClass.getName());
            }
            this.setStateDeactivated();
            this.i_yapClass.deactivate(transaction, object, n);
        }
    }

    public byte getIdentifier() {
        return 79;
    }

    public Object getObject() {
        if (Platform4.hasWeakReferences()) {
            return Platform4.getYapRefObject(this.i_object);
        }
        return this.i_object;
    }

    public YapStream getStream() {
        if (this.i_yapClass == null) {
            return null;
        }
        return this.i_yapClass.getStream();
    }

    public Transaction getTrans() {
        YapStream yapStream = this.getStream();
        if (yapStream != null) {
            return yapStream.getTransaction();
        }
        return null;
    }

    public Db4oUUID getUUID() {
        VirtualAttributes virtualAttributes = this.virtualAttributes(this.getTrans());
        if (virtualAttributes != null && virtualAttributes.i_database != null) {
            return new Db4oUUID(virtualAttributes.i_uuid, virtualAttributes.i_database.i_signature);
        }
        return null;
    }

    public long getVersion() {
        VirtualAttributes virtualAttributes = this.virtualAttributes(this.getTrans());
        if (virtualAttributes == null) {
            return 0L;
        }
        return virtualAttributes.i_version;
    }

    public YapClass getYapClass() {
        return this.i_yapClass;
    }

    public int ownLength() {
        throw Exceptions4.shouldNeverBeCalled();
    }

    final Object read(Transaction transaction, YapWriter yapWriter, Object object, int n, int n2, boolean bl) {
        if (this.beginProcessing()) {
            YapStream yapStream = transaction.i_stream;
            if (yapWriter == null) {
                yapWriter = yapStream.readWriterByID(transaction, this.getID());
            }
            if (yapWriter != null) {
                YapObject yapObject;
                ObjectHeader objectHeader = new ObjectHeader(yapStream, yapWriter);
                this.i_yapClass = objectHeader._yapClass;
                if (this.i_yapClass == null) {
                    return null;
                }
                if (bl && (yapObject = yapStream.getYapObject(this.getID())) != null) {
                    Object object2 = yapObject.getObject();
                    if (object2 != null) {
                        return object2;
                    }
                    yapStream.yapObjectGCd(yapObject);
                }
                yapWriter.setInstantiationDepth(n);
                yapWriter.setUpdateDepth(n2);
                object = n2 == -1 ? this.i_yapClass.instantiateTransient(this, object, objectHeader._marshallerFamily, objectHeader._headerAttributes, yapWriter) : this.i_yapClass.instantiate(this, object, objectHeader._marshallerFamily, objectHeader._headerAttributes, yapWriter, n2 == 1);
            }
            this.endProcessing();
        }
        return object;
    }

    final Object readPrefetch(YapStream yapStream, Transaction transaction, YapWriter yapWriter) {
        Object object = null;
        if (this.beginProcessing()) {
            ObjectHeader objectHeader = new ObjectHeader(yapStream, yapWriter);
            this.i_yapClass = objectHeader._yapClass;
            if (this.i_yapClass == null) {
                return null;
            }
            yapWriter.setInstantiationDepth(this.i_yapClass.configOrAncestorConfig() == null ? 1 : 0);
            object = this.i_yapClass.instantiate(this, this.getObject(), objectHeader._marshallerFamily, objectHeader._headerAttributes, yapWriter, true);
            this.endProcessing();
        }
        return object;
    }

    public final void readThis(Transaction transaction, YapReader yapReader) {
    }

    void setObjectWeak(YapStream yapStream, Object object) {
        if (yapStream.i_references._weak) {
            if (this.i_object != null) {
                Platform4.killYapRef(this.i_object);
            }
            this.i_object = Platform4.createYapRef(yapStream.i_references._queue, this, object);
        } else {
            this.i_object = object;
        }
    }

    public void setObject(Object object) {
        this.i_object = object;
    }

    void setStateOnRead(YapWriter yapWriter) {
    }

    boolean store(Transaction transaction, YapClass yapClass, Object object, int n) {
        this.i_object = object;
        this.writeObjectBegin();
        YapStream yapStream = transaction.i_stream;
        this.i_yapClass = yapClass;
        this.setID(yapStream.newUserObject());
        this.beginProcessing();
        this.bitTrue(4);
        return true;
    }

    public VirtualAttributes virtualAttributes(Transaction transaction) {
        if (transaction == null) {
            return this.i_virtualAttributes;
        }
        if (this.i_virtualAttributes == null) {
            if (this.i_yapClass.hasVirtualAttributes()) {
                this.i_virtualAttributes = new VirtualAttributes();
                this.i_yapClass.readVirtualAttributes(transaction, this);
            }
        } else if (!this.i_virtualAttributes.suppliesUUID() && this.i_yapClass.hasVirtualAttributes()) {
            this.i_yapClass.readVirtualAttributes(transaction, this);
        }
        return this.i_virtualAttributes;
    }

    public void setVirtualAttributes(VirtualAttributes virtualAttributes) {
        this.i_virtualAttributes = virtualAttributes;
    }

    public void writeThis(Transaction transaction, YapReader yapReader) {
    }

    void writeUpdate(Transaction transaction, int n) {
        this.continueSet(transaction, n);
        if (this.beginProcessing()) {
            Object object = this.getObject();
            if (this.i_yapClass.dispatchEvent(transaction.i_stream, object, 9)) {
                if (!this.isActive() || object == null) {
                    this.endProcessing();
                    return;
                }
                if (transaction.i_stream.i_config.messageLevel() > 1) {
                    transaction.i_stream.message("" + this.getID() + " update " + this.i_yapClass.getName());
                }
                this.setStateClean();
                transaction.writeUpdateDeleteMembers(this.getID(), this.i_yapClass, transaction.i_stream.i_handlers.arrayType(object), 0);
                MarshallerFamily.current()._object.marshallUpdate(transaction, n, this, object);
            } else {
                this.endProcessing();
            }
        }
    }

    public YapObject hc_add(YapObject yapObject) {
        Object object = yapObject.getObject();
        if (object != null) {
            yapObject.hc_init(object);
            return this.hc_add1(yapObject);
        }
        return this;
    }

    public void hc_init(Object object) {
        this.hc_preceding = null;
        this.hc_subsequent = null;
        this.hc_size = 1;
        this.hc_code = this.hc_getCode(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private YapObject hc_add1(YapObject yapObject) {
        int n = this.hc_compare(yapObject);
        if (n < 0) {
            if (this.hc_preceding == null) {
                this.hc_preceding = yapObject;
                ++this.hc_size;
                return this;
            }
            this.hc_preceding = this.hc_preceding.hc_add1(yapObject);
            if (this.hc_subsequent != null) return this.hc_balance();
            return this.hc_rotateRight();
        }
        if (this.hc_subsequent == null) {
            this.hc_subsequent = yapObject;
            ++this.hc_size;
            return this;
        }
        this.hc_subsequent = this.hc_subsequent.hc_add1(yapObject);
        if (this.hc_preceding != null) return this.hc_balance();
        return this.hc_rotateLeft();
    }

    private YapObject hc_balance() {
        int n = this.hc_subsequent.hc_size - this.hc_preceding.hc_size;
        if (n < -2) {
            return this.hc_rotateRight();
        }
        if (n > 2) {
            return this.hc_rotateLeft();
        }
        this.hc_size = this.hc_preceding.hc_size + this.hc_subsequent.hc_size + 1;
        return this;
    }

    private void hc_calculateSize() {
        this.hc_size = this.hc_preceding == null ? (this.hc_subsequent == null ? 1 : this.hc_subsequent.hc_size + 1) : (this.hc_subsequent == null ? this.hc_preceding.hc_size + 1 : this.hc_preceding.hc_size + this.hc_subsequent.hc_size + 1);
    }

    private int hc_compare(YapObject yapObject) {
        int n = yapObject.hc_code - this.hc_code;
        if (n == 0) {
            n = yapObject.i_id - this.i_id;
        }
        return n;
    }

    public YapObject hc_find(Object object) {
        return this.hc_find(this.hc_getCode(object), object);
    }

    private YapObject hc_find(int n, Object object) {
        int n2 = n - this.hc_code;
        if (n2 < 0) {
            if (this.hc_preceding != null) {
                return this.hc_preceding.hc_find(n, object);
            }
        } else if (n2 > 0) {
            if (this.hc_subsequent != null) {
                return this.hc_subsequent.hc_find(n, object);
            }
        } else {
            YapObject yapObject;
            if (object == this.getObject()) {
                return this;
            }
            if (this.hc_preceding != null && (yapObject = this.hc_preceding.hc_find(n, object)) != null) {
                return yapObject;
            }
            if (this.hc_subsequent != null) {
                return this.hc_subsequent.hc_find(n, object);
            }
        }
        return null;
    }

    private int hc_getCode(Object object) {
        int n = System.identityHashCode(object);
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    private YapObject hc_rotateLeft() {
        YapObject yapObject = this.hc_subsequent;
        this.hc_subsequent = yapObject.hc_preceding;
        this.hc_calculateSize();
        yapObject.hc_preceding = this;
        yapObject.hc_size = yapObject.hc_subsequent == null ? 1 + this.hc_size : 1 + this.hc_size + yapObject.hc_subsequent.hc_size;
        return yapObject;
    }

    private YapObject hc_rotateRight() {
        YapObject yapObject = this.hc_preceding;
        this.hc_preceding = yapObject.hc_subsequent;
        this.hc_calculateSize();
        yapObject.hc_subsequent = this;
        yapObject.hc_size = yapObject.hc_preceding == null ? 1 + this.hc_size : 1 + this.hc_size + yapObject.hc_preceding.hc_size;
        return yapObject;
    }

    private YapObject hc_rotateSmallestUp() {
        if (this.hc_preceding != null) {
            this.hc_preceding = this.hc_preceding.hc_rotateSmallestUp();
            return this.hc_rotateRight();
        }
        return this;
    }

    YapObject hc_remove(YapObject yapObject) {
        if (this == yapObject) {
            return this.hc_remove();
        }
        int n = this.hc_compare(yapObject);
        if (n <= 0 && this.hc_preceding != null) {
            this.hc_preceding = this.hc_preceding.hc_remove(yapObject);
        }
        if (n >= 0 && this.hc_subsequent != null) {
            this.hc_subsequent = this.hc_subsequent.hc_remove(yapObject);
        }
        this.hc_calculateSize();
        return this;
    }

    public void hc_traverse(Visitor4 visitor4) {
        if (this.hc_preceding != null) {
            this.hc_preceding.hc_traverse(visitor4);
        }
        visitor4.visit(this);
        if (this.hc_subsequent != null) {
            this.hc_subsequent.hc_traverse(visitor4);
        }
    }

    private YapObject hc_remove() {
        if (this.hc_subsequent != null && this.hc_preceding != null) {
            this.hc_subsequent = this.hc_subsequent.hc_rotateSmallestUp();
            this.hc_subsequent.hc_preceding = this.hc_preceding;
            this.hc_subsequent.hc_calculateSize();
            return this.hc_subsequent;
        }
        if (this.hc_subsequent != null) {
            return this.hc_subsequent;
        }
        return this.hc_preceding;
    }

    YapObject id_add(YapObject yapObject) {
        yapObject.id_preceding = null;
        yapObject.id_subsequent = null;
        yapObject.id_size = 1;
        return this.id_add1(yapObject);
    }

    /*
     * Enabled aggressive block sorting
     */
    private YapObject id_add1(YapObject yapObject) {
        int n = yapObject.i_id - this.i_id;
        if (n < 0) {
            if (this.id_preceding == null) {
                this.id_preceding = yapObject;
                ++this.id_size;
                return this;
            }
            this.id_preceding = this.id_preceding.id_add1(yapObject);
            if (this.id_subsequent != null) return this.id_balance();
            return this.id_rotateRight();
        }
        if (this.id_subsequent == null) {
            this.id_subsequent = yapObject;
            ++this.id_size;
            return this;
        }
        this.id_subsequent = this.id_subsequent.id_add1(yapObject);
        if (this.id_preceding != null) return this.id_balance();
        return this.id_rotateLeft();
    }

    private YapObject id_balance() {
        int n = this.id_subsequent.id_size - this.id_preceding.id_size;
        if (n < -2) {
            return this.id_rotateRight();
        }
        if (n > 2) {
            return this.id_rotateLeft();
        }
        this.id_size = this.id_preceding.id_size + this.id_subsequent.id_size + 1;
        return this;
    }

    private void id_calculateSize() {
        this.id_size = this.id_preceding == null ? (this.id_subsequent == null ? 1 : this.id_subsequent.id_size + 1) : (this.id_subsequent == null ? this.id_preceding.id_size + 1 : this.id_preceding.id_size + this.id_subsequent.id_size + 1);
    }

    YapObject id_find(int n) {
        int n2 = n - this.i_id;
        if (n2 > 0) {
            if (this.id_subsequent != null) {
                return this.id_subsequent.id_find(n);
            }
        } else if (n2 < 0) {
            if (this.id_preceding != null) {
                return this.id_preceding.id_find(n);
            }
        } else {
            return this;
        }
        return null;
    }

    private YapObject id_rotateLeft() {
        YapObject yapObject = this.id_subsequent;
        this.id_subsequent = yapObject.id_preceding;
        this.id_calculateSize();
        yapObject.id_preceding = this;
        yapObject.id_size = yapObject.id_subsequent == null ? this.id_size + 1 : this.id_size + 1 + yapObject.id_subsequent.id_size;
        return yapObject;
    }

    private YapObject id_rotateRight() {
        YapObject yapObject = this.id_preceding;
        this.id_preceding = yapObject.id_subsequent;
        this.id_calculateSize();
        yapObject.id_subsequent = this;
        yapObject.id_size = yapObject.id_preceding == null ? this.id_size + 1 : this.id_size + 1 + yapObject.id_preceding.id_size;
        return yapObject;
    }

    private YapObject id_rotateSmallestUp() {
        if (this.id_preceding != null) {
            this.id_preceding = this.id_preceding.id_rotateSmallestUp();
            return this.id_rotateRight();
        }
        return this;
    }

    YapObject id_remove(int n) {
        int n2 = n - this.i_id;
        if (n2 < 0) {
            if (this.id_preceding != null) {
                this.id_preceding = this.id_preceding.id_remove(n);
            }
        } else if (n2 > 0) {
            if (this.id_subsequent != null) {
                this.id_subsequent = this.id_subsequent.id_remove(n);
            }
        } else {
            return this.id_remove();
        }
        this.id_calculateSize();
        return this;
    }

    private YapObject id_remove() {
        if (this.id_subsequent != null && this.id_preceding != null) {
            this.id_subsequent = this.id_subsequent.id_rotateSmallestUp();
            this.id_subsequent.id_preceding = this.id_preceding;
            this.id_subsequent.id_calculateSize();
            return this.id_subsequent;
        }
        if (this.id_subsequent != null) {
            return this.id_subsequent;
        }
        return this.id_preceding;
    }

    public String toString() {
        return super.toString();
    }
}

