/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Readable;
import com.db4o.VisitorBoolean;
import com.db4o.YapReader;
import com.db4o.foundation.ShallowClone;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.Exceptions4;

public abstract class Tree
implements ShallowClone,
Readable {
    public Tree _preceding;
    public int _size = 1;
    public Tree _subsequent;

    public static final Tree add(Tree tree, Tree tree2) {
        if (tree == null) {
            return tree2;
        }
        return tree.add(tree2);
    }

    public Tree add(Tree tree) {
        return this.add(tree, this.compare(tree));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tree add(Tree tree, int n) {
        if (n < 0) {
            if (this._subsequent == null) {
                this._subsequent = tree;
                ++this._size;
                return this;
            }
            this._subsequent = this._subsequent.add(tree);
            if (this._preceding != null) return this.balance();
            return this.rotateLeft();
        }
        if (n <= 0 && !tree.duplicates()) {
            tree.isDuplicateOf(this);
            return this;
        }
        if (this._preceding == null) {
            this._preceding = tree;
            ++this._size;
            return this;
        }
        this._preceding = this._preceding.add(tree);
        if (this._subsequent != null) return this.balance();
        return this.rotateRight();
    }

    public Tree duplicateOrThis() {
        if (this._size == 0) {
            return this._preceding;
        }
        return this;
    }

    public final Tree balance() {
        int n = this._subsequent.nodes() - this._preceding.nodes();
        if (n < -2) {
            return this.rotateRight();
        }
        if (n > 2) {
            return this.rotateLeft();
        }
        this.setSizeOwnPrecedingSubsequent();
        return this;
    }

    public Tree balanceCheckNulls() {
        if (this._subsequent == null) {
            if (this._preceding == null) {
                this.setSizeOwn();
                return this;
            }
            return this.rotateRight();
        }
        if (this._preceding == null) {
            return this.rotateLeft();
        }
        return this.balance();
    }

    public static int byteCount(Tree tree) {
        if (tree == null) {
            return 4;
        }
        return tree.byteCount();
    }

    public final int byteCount() {
        if (this.variableLength()) {
            final int[] nArray = new int[]{4};
            this.traverse(new Visitor4(){

                public void visit(Object object) {
                    nArray[0] = nArray[0] + ((Tree)object).ownLength();
                }
            });
            return nArray[0];
        }
        return 4 + this.size() * this.ownLength();
    }

    public void calculateSize() {
        if (this._preceding == null) {
            if (this._subsequent == null) {
                this.setSizeOwn();
            } else {
                this.setSizeOwnSubsequent();
            }
        } else if (this._subsequent == null) {
            this.setSizeOwnPreceding();
        } else {
            this.setSizeOwnPrecedingSubsequent();
        }
    }

    public abstract int compare(Tree var1);

    public static Tree deepClone(Tree tree, Object object) {
        if (tree == null) {
            return null;
        }
        Tree tree2 = tree.deepClone(object);
        tree2._size = tree._size;
        tree2.nodes(tree.nodes());
        tree2._preceding = Tree.deepClone(tree._preceding, object);
        tree2._subsequent = Tree.deepClone(tree._subsequent, object);
        return tree2;
    }

    public Tree deepClone(Object object) {
        return (Tree)this.shallowClone();
    }

    public boolean duplicates() {
        return true;
    }

    final Tree filter(VisitorBoolean visitorBoolean) {
        if (this._preceding != null) {
            this._preceding = this._preceding.filter(visitorBoolean);
        }
        if (this._subsequent != null) {
            this._subsequent = this._subsequent.filter(visitorBoolean);
        }
        if (!visitorBoolean.isVisit(this)) {
            return this.remove();
        }
        return this;
    }

    public static final Tree find(Tree tree, Tree tree2) {
        if (tree == null) {
            return null;
        }
        return tree.find(tree2);
    }

    public final Tree find(Tree tree) {
        int n = this.compare(tree);
        if (n < 0) {
            if (this._subsequent != null) {
                return this._subsequent.find(tree);
            }
        } else if (n > 0) {
            if (this._preceding != null) {
                return this._preceding.find(tree);
            }
        } else {
            return this;
        }
        return null;
    }

    public static final Tree findGreaterOrEqual(Tree tree, Tree tree2) {
        if (tree == null) {
            return null;
        }
        int n = tree.compare(tree2);
        if (n == 0) {
            return tree;
        }
        if (n > 0) {
            Tree tree3 = Tree.findGreaterOrEqual(tree._preceding, tree2);
            if (tree3 != null) {
                return tree3;
            }
            return tree;
        }
        return Tree.findGreaterOrEqual(tree._subsequent, tree2);
    }

    public static final Tree findSmaller(Tree tree, Tree tree2) {
        if (tree == null) {
            return null;
        }
        int n = tree.compare(tree2);
        if (n < 0) {
            Tree tree3 = Tree.findSmaller(tree._subsequent, tree2);
            if (tree3 != null) {
                return tree3;
            }
            return tree;
        }
        return Tree.findSmaller(tree._preceding, tree2);
    }

    public final Tree first() {
        if (this._preceding == null) {
            return this;
        }
        return this._preceding.first();
    }

    void isDuplicateOf(Tree tree) {
        this._size = 0;
        this._preceding = tree;
    }

    public int nodes() {
        return this._size;
    }

    public void nodes(int n) {
    }

    public int ownLength() {
        throw Exceptions4.virtualException();
    }

    public int ownSize() {
        return 1;
    }

    static Tree read(Tree tree, YapReader yapReader) {
        throw Exceptions4.virtualException();
    }

    public Object read(YapReader yapReader) {
        throw Exceptions4.virtualException();
    }

    public Tree remove() {
        if (this._subsequent != null && this._preceding != null) {
            this._subsequent = this._subsequent.rotateSmallestUp();
            this._subsequent._preceding = this._preceding;
            this._subsequent.calculateSize();
            return this._subsequent;
        }
        if (this._subsequent != null) {
            return this._subsequent;
        }
        return this._preceding;
    }

    public void removeChildren() {
        this._preceding = null;
        this._subsequent = null;
        this.setSizeOwn();
    }

    public Tree removeFirst() {
        if (this._preceding == null) {
            return this._subsequent;
        }
        this._preceding = this._preceding.removeFirst();
        this.calculateSize();
        return this;
    }

    static Tree removeLike(Tree tree, Tree tree2) {
        if (tree == null) {
            return null;
        }
        return tree.removeLike(tree2);
    }

    public final Tree removeLike(Tree tree) {
        int n = this.compare(tree);
        if (n == 0) {
            return this.remove();
        }
        if (n > 0) {
            if (this._preceding != null) {
                this._preceding = this._preceding.removeLike(tree);
            }
        } else if (this._subsequent != null) {
            this._subsequent = this._subsequent.removeLike(tree);
        }
        this.calculateSize();
        return this;
    }

    public final Tree removeNode(Tree tree) {
        if (this == tree) {
            return this.remove();
        }
        int n = this.compare(tree);
        if (n >= 0 && this._preceding != null) {
            this._preceding = this._preceding.removeNode(tree);
        }
        if (n <= 0 && this._subsequent != null) {
            this._subsequent = this._subsequent.removeNode(tree);
        }
        this.calculateSize();
        return this;
    }

    public final Tree rotateLeft() {
        Tree tree = this._subsequent;
        this._subsequent = tree._preceding;
        this.calculateSize();
        tree._preceding = this;
        if (tree._subsequent == null) {
            tree.setSizeOwnPlus(this);
        } else {
            tree.setSizeOwnPlus(this, tree._subsequent);
        }
        return tree;
    }

    public final Tree rotateRight() {
        Tree tree = this._preceding;
        this._preceding = tree._subsequent;
        this.calculateSize();
        tree._subsequent = this;
        if (tree._preceding == null) {
            tree.setSizeOwnPlus(this);
        } else {
            tree.setSizeOwnPlus(this, tree._preceding);
        }
        return tree;
    }

    private final Tree rotateSmallestUp() {
        if (this._preceding != null) {
            this._preceding = this._preceding.rotateSmallestUp();
            return this.rotateRight();
        }
        return this;
    }

    public void setSizeOwn() {
        this._size = this.ownSize();
    }

    public void setSizeOwnPrecedingSubsequent() {
        this._size = this.ownSize() + this._preceding._size + this._subsequent._size;
    }

    public void setSizeOwnPreceding() {
        this._size = this.ownSize() + this._preceding._size;
    }

    public void setSizeOwnSubsequent() {
        this._size = this.ownSize() + this._subsequent._size;
    }

    public void setSizeOwnPlus(Tree tree) {
        this._size = this.ownSize() + tree._size;
    }

    public void setSizeOwnPlus(Tree tree, Tree tree2) {
        this._size = this.ownSize() + tree._size + tree2._size;
    }

    public static int size(Tree tree) {
        if (tree == null) {
            return 0;
        }
        return tree.size();
    }

    public int size() {
        return this._size;
    }

    public static final void traverse(Tree tree, Visitor4 visitor4) {
        if (tree == null) {
            return;
        }
        tree.traverse(visitor4);
    }

    public final void traverse(Visitor4 visitor4) {
        if (this._preceding != null) {
            this._preceding.traverse(visitor4);
        }
        visitor4.visit(this);
        if (this._subsequent != null) {
            this._subsequent.traverse(visitor4);
        }
    }

    public final void traverseFromLeaves(Visitor4 visitor4) {
        if (this._preceding != null) {
            this._preceding.traverseFromLeaves(visitor4);
        }
        if (this._subsequent != null) {
            this._subsequent.traverseFromLeaves(visitor4);
        }
        visitor4.visit(this);
    }

    boolean variableLength() {
        throw Exceptions4.virtualException();
    }

    public static void write(YapReader yapReader, Tree tree) {
        Tree.write(yapReader, tree, tree == null ? 0 : tree.size());
    }

    public static void write(final YapReader yapReader, Tree tree, int n) {
        if (tree == null) {
            yapReader.writeInt(0);
            return;
        }
        yapReader.writeInt(n);
        tree.traverse(new Visitor4(){

            public void visit(Object object) {
                ((Tree)object).write(yapReader);
            }
        });
    }

    public void write(YapReader yapReader) {
        throw Exceptions4.virtualException();
    }

    protected Tree shallowCloneInternal(Tree tree) {
        tree._preceding = this._preceding;
        tree._size = this._size;
        tree._subsequent = this._subsequent;
        return tree;
    }
}

