/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.YapStream;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectMethod;

public final class EventDispatcher {
    private static final String[] events = new String[]{"objectCanDelete", "objectOnDelete", "objectOnActivate", "objectOnDeactivate", "objectOnNew", "objectOnUpdate", "objectCanActivate", "objectCanDeactivate", "objectCanNew", "objectCanUpdate"};
    static final int CAN_DELETE = 0;
    static final int DELETE = 1;
    static final int SERVER_COUNT = 2;
    static final int ACTIVATE = 2;
    static final int DEACTIVATE = 3;
    static final int NEW = 4;
    public static final int UPDATE = 5;
    static final int CAN_ACTIVATE = 6;
    static final int CAN_DEACTIVATE = 7;
    static final int CAN_NEW = 8;
    static final int CAN_UPDATE = 9;
    static final int COUNT = 10;
    private final ReflectMethod[] methods;

    private EventDispatcher(ReflectMethod[] reflectMethodArray) {
        this.methods = reflectMethodArray;
    }

    boolean dispatch(YapStream yapStream, Object object, int n) {
        if (this.methods[n] != null) {
            Object[] objectArray = new Object[]{yapStream};
            try {
                Object object2 = this.methods[n].invoke(object, objectArray);
                if (object2 != null && object2 instanceof Boolean) {
                    return (Boolean)object2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    static EventDispatcher forClass(YapStream yapStream, ReflectClass reflectClass) {
        if (yapStream == null || reflectClass == null) {
            return null;
        }
        EventDispatcher eventDispatcher = null;
        int n = 0;
        if (yapStream.i_config.callbacks()) {
            n = 10;
        } else if (yapStream.i_config.isServer()) {
            n = 2;
        }
        if (n > 0) {
            ReflectClass[] reflectClassArray = new ReflectClass[]{yapStream.i_handlers.ICLASS_OBJECTCONTAINER};
            ReflectMethod[] reflectMethodArray = new ReflectMethod[10];
            for (int i = 9; i >= 0; --i) {
                try {
                    ReflectMethod reflectMethod = reflectClass.getMethod(events[i], reflectClassArray);
                    if (null == reflectMethod) {
                        reflectMethod = reflectClass.getMethod(EventDispatcher.toPascalCase(events[i]), reflectClassArray);
                    }
                    reflectMethodArray[i] = reflectMethod;
                    if (eventDispatcher != null) continue;
                    eventDispatcher = new EventDispatcher(reflectMethodArray);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return eventDispatcher;
    }

    private static String toPascalCase(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }
}

