/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.generic;

import com.db4o.Platform4;
import com.db4o.foundation.DeepClone;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectConstructor;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.ReflectMethod;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericArrayClass;
import com.db4o.reflect.generic.GenericConverter;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericObject;
import com.db4o.reflect.generic.GenericReflector;

public class GenericClass
implements ReflectClass,
DeepClone {
    private static final GenericField[] NO_FIELDS = new GenericField[0];
    private final GenericReflector _reflector;
    private final ReflectClass _delegate;
    private final String _name;
    private GenericClass _superclass;
    private GenericClass _array;
    private boolean _isSecondClass;
    private boolean _isPrimitive;
    private int _isCollection;
    private GenericConverter _converter;
    private GenericField[] _fields = NO_FIELDS;
    private int _declaredFieldCount = -1;
    private int _fieldCount = -1;
    private final int _hashCode;

    public GenericClass(GenericReflector genericReflector, ReflectClass reflectClass, String string, GenericClass genericClass) {
        this._reflector = genericReflector;
        this._delegate = reflectClass;
        this._name = string;
        this._superclass = genericClass;
        this._hashCode = this._name.hashCode();
    }

    public GenericClass arrayClass() {
        if (this._array != null) {
            return this._array;
        }
        this._array = new GenericArrayClass(this._reflector, this, this._name, this._superclass);
        this._array._isSecondClass = this._isSecondClass;
        return this._array;
    }

    public Object deepClone(Object object) {
        GenericReflector genericReflector = (GenericReflector)object;
        GenericClass genericClass = null;
        if (this._superclass != null) {
            this._superclass = (GenericClass)genericReflector.forName(this._superclass.getName());
        }
        GenericClass genericClass2 = new GenericClass(genericReflector, this._delegate, this._name, genericClass);
        genericClass2._isSecondClass = this._isSecondClass;
        GenericField[] genericFieldArray = new GenericField[this._fields.length];
        for (int i = 0; i < genericFieldArray.length; ++i) {
            genericFieldArray[i] = (GenericField)this._fields[i].deepClone(genericReflector);
        }
        genericClass2.initFields(genericFieldArray);
        return genericClass2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof GenericClass)) {
            return false;
        }
        GenericClass genericClass = (GenericClass)object;
        if (this._hashCode != genericClass.hashCode()) {
            return false;
        }
        return this._name.equals(genericClass._name);
    }

    public ReflectClass getComponentType() {
        if (this._delegate != null) {
            return this._delegate.getComponentType();
        }
        return null;
    }

    public ReflectConstructor[] getDeclaredConstructors() {
        if (this._delegate != null) {
            return this._delegate.getDeclaredConstructors();
        }
        return null;
    }

    public ReflectField getDeclaredField(String string) {
        if (this._delegate != null) {
            return this._delegate.getDeclaredField(string);
        }
        for (int i = 0; i < this._fields.length; ++i) {
            if (!this._fields[i].getName().equals(string)) continue;
            return this._fields[i];
        }
        return null;
    }

    public ReflectField[] getDeclaredFields() {
        if (this._delegate != null) {
            return this._delegate.getDeclaredFields();
        }
        return this._fields;
    }

    public ReflectClass getDelegate() {
        if (this._delegate != null) {
            return this._delegate;
        }
        return this;
    }

    int getFieldCount() {
        if (this._fieldCount != -1) {
            return this._fieldCount;
        }
        this._fieldCount = 0;
        if (this._superclass != null) {
            this._fieldCount = this._superclass.getFieldCount();
        }
        if (this._declaredFieldCount == -1) {
            this._declaredFieldCount = this.getDeclaredFields().length;
        }
        this._fieldCount += this._declaredFieldCount;
        return this._fieldCount;
    }

    public ReflectMethod getMethod(String string, ReflectClass[] reflectClassArray) {
        if (this._delegate != null) {
            return this._delegate.getMethod(string, reflectClassArray);
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public ReflectClass getSuperclass() {
        if (this._superclass != null) {
            return this._superclass;
        }
        if (this._delegate == null) {
            return null;
        }
        ReflectClass reflectClass = this._delegate.getSuperclass();
        if (reflectClass != null) {
            this._superclass = this._reflector.ensureDelegate(reflectClass);
        }
        return this._superclass;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public void initFields(GenericField[] genericFieldArray) {
        int n = 0;
        if (this._superclass != null) {
            n = this._superclass.getFieldCount();
        }
        this._fields = genericFieldArray;
        for (int i = 0; i < this._fields.length; ++i) {
            this._fields[i].setIndex(n + i);
        }
    }

    public boolean isAbstract() {
        if (this._delegate != null) {
            return this._delegate.isAbstract();
        }
        return false;
    }

    public boolean isArray() {
        if (this._delegate != null) {
            return this._delegate.isArray();
        }
        return false;
    }

    public boolean isAssignableFrom(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return false;
        }
        if (this.equals(reflectClass)) {
            return true;
        }
        if (this._delegate != null) {
            if (reflectClass instanceof GenericClass) {
                reflectClass = ((GenericClass)reflectClass).getDelegate();
            }
            return this._delegate.isAssignableFrom(reflectClass);
        }
        if (!(reflectClass instanceof GenericClass)) {
            return false;
        }
        return this.isAssignableFrom(reflectClass.getSuperclass());
    }

    public boolean isCollection() {
        if (this._isCollection == 1) {
            return true;
        }
        if (this._isCollection == -1) {
            return false;
        }
        this._isCollection = this._reflector.isCollection(this) ? 1 : -1;
        return this.isCollection();
    }

    public boolean isInstance(Object object) {
        if (this._delegate != null) {
            return this._delegate.isInstance(object);
        }
        if (!(object instanceof GenericObject)) {
            return false;
        }
        return this.isAssignableFrom(((GenericObject)object)._class);
    }

    public boolean isInterface() {
        if (this._delegate != null) {
            return this._delegate.isInterface();
        }
        return false;
    }

    public boolean isPrimitive() {
        if (this._delegate != null) {
            return this._delegate.isPrimitive();
        }
        return this._isPrimitive;
    }

    public boolean isSecondClass() {
        if (this.isPrimitive()) {
            return true;
        }
        return this._isSecondClass;
    }

    public Object newInstance() {
        if (this._delegate != null) {
            return this._delegate.newInstance();
        }
        return new GenericObject(this);
    }

    public Reflector reflector() {
        if (this._delegate != null) {
            return this._delegate.reflector();
        }
        return this._reflector;
    }

    void setConverter(GenericConverter genericConverter) {
        this._converter = genericConverter;
    }

    void setDeclaredFieldCount(int n) {
        this._declaredFieldCount = n;
    }

    void setPrimitive() {
        this._isPrimitive = true;
    }

    void setSecondClass() {
        this._isSecondClass = true;
    }

    public boolean skipConstructor(boolean bl) {
        if (this._delegate != null) {
            return this._delegate.skipConstructor(bl);
        }
        return false;
    }

    public String toString() {
        return "GenericClass " + this._name;
    }

    public String toString(GenericObject genericObject) {
        if (this._converter == null) {
            return "(G) " + this.getName();
        }
        return this._converter.toString(genericObject);
    }

    public void useConstructor(ReflectConstructor reflectConstructor, Object[] objectArray) {
        if (this._delegate != null) {
            this._delegate.useConstructor(reflectConstructor, objectArray);
        }
    }

    public Object[] toArray(Object object) {
        if (!this.isCollection()) {
            return new Object[]{object};
        }
        return Platform4.collectionToArray(this._reflector.getStream(), object);
    }
}

