/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.slots;

import com.db4o.Transaction;
import com.db4o.TreeInt;
import com.db4o.YapFile;
import com.db4o.YapReader;
import com.db4o.inside.slots.ReferencedSlot;
import com.db4o.inside.slots.Slot;

public class SlotChange
extends TreeInt {
    private int _action;
    private Slot _newSlot;
    private ReferencedSlot _shared;
    private static final int FREE_ON_COMMIT_BIT = 1;
    private static final int FREE_ON_ROLLBACK_BIT = 2;
    private static final int SET_POINTER_BIT = 3;

    public SlotChange(int n) {
        super(n);
    }

    public Object shallowClone() {
        SlotChange slotChange = new SlotChange(0);
        slotChange._action = this._action;
        slotChange._newSlot = this._newSlot;
        slotChange._shared = this._shared;
        return super.shallowCloneInternal(slotChange);
    }

    private final void doFreeOnCommit() {
        this.setBit(1);
    }

    private final void doFreeOnRollback() {
        this.setBit(2);
    }

    private final void doSetPointer() {
        this.setBit(3);
    }

    public void freeDuringCommit(YapFile yapFile) {
        if (this.isFreeOnCommit()) {
            yapFile.freeDuringCommit(this._shared, this._newSlot);
        }
    }

    public void freeOnCommit(YapFile yapFile, Slot slot) {
        if (this._shared != null) {
            yapFile.free(slot);
            return;
        }
        this.doFreeOnCommit();
        ReferencedSlot referencedSlot = yapFile.produceFreeOnCommitEntry(this._key);
        if (referencedSlot.addReferenceIsFirst()) {
            referencedSlot.pointTo(slot);
        }
        this._shared = referencedSlot;
    }

    public void freeOnRollback(int n, int n2) {
        this.doFreeOnRollback();
        this._newSlot = new Slot(n, n2);
    }

    public void freeOnRollbackSetPointer(int n, int n2) {
        this.doSetPointer();
        this.freeOnRollback(n, n2);
    }

    private final boolean isBitSet(int n) {
        return (this._action | 1 << n) == this._action;
    }

    public boolean isDeleted() {
        return this.isSetPointer() && this._newSlot._address == 0;
    }

    private final boolean isFreeOnCommit() {
        return this.isBitSet(1);
    }

    private final boolean isFreeOnRollback() {
        return this.isBitSet(2);
    }

    public final boolean isSetPointer() {
        return this.isBitSet(3);
    }

    public Slot newSlot() {
        return this._newSlot;
    }

    public Object read(YapReader yapReader) {
        SlotChange slotChange = new SlotChange(yapReader.readInt());
        slotChange._newSlot = new Slot(yapReader.readInt(), yapReader.readInt());
        slotChange.doSetPointer();
        return slotChange;
    }

    public void rollback(YapFile yapFile) {
        if (this._shared != null) {
            yapFile.reduceFreeOnCommitReferences(this._shared);
        }
        if (this.isFreeOnRollback()) {
            yapFile.free(this._newSlot);
        }
    }

    private final void setBit(int n) {
        this._action |= 1 << n;
    }

    public void setPointer(int n, int n2) {
        this.doSetPointer();
        this._newSlot = new Slot(n, n2);
    }

    public void write(YapReader yapReader) {
        if (this.isSetPointer()) {
            yapReader.writeInt(this._key);
            yapReader.writeInt(this._newSlot._address);
            yapReader.writeInt(this._newSlot._length);
        }
    }

    public void writePointer(Transaction transaction) {
        if (this.isSetPointer()) {
            transaction.writePointer(this._key, this._newSlot._address, this._newSlot._length);
        }
    }
}

