/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.marshall;

import com.db4o.Transaction;
import com.db4o.YapClass;
import com.db4o.YapField;
import com.db4o.YapObject;
import com.db4o.YapReader;
import com.db4o.YapWriter;
import com.db4o.foundation.BitMap4;
import com.db4o.inside.marshall.ObjectHeaderAttributes;

public class ObjectHeaderAttributes1
extends ObjectHeaderAttributes {
    private static final byte VERSION = 1;
    private final int _fieldCount;
    private final BitMap4 _nullBitMap;
    private int _baseLength;
    private int _payLoadLength;

    public ObjectHeaderAttributes1(YapObject yapObject) {
        this._fieldCount = yapObject.getYapClass().fieldCount();
        this._nullBitMap = new BitMap4(this._fieldCount);
        this.calculateLengths(yapObject);
    }

    public ObjectHeaderAttributes1(YapReader yapReader) {
        this._fieldCount = yapReader.readInt();
        this._nullBitMap = yapReader.readBitMap(this._fieldCount);
    }

    public void addBaseLength(int n) {
        this._baseLength += n;
    }

    public void addPayLoadLength(int n) {
        this._payLoadLength += n;
    }

    private void calculateLengths(YapObject yapObject) {
        this._baseLength = this.headerLength() + this.nullBitMapLength();
        this._payLoadLength = 0;
        YapClass yapClass = yapObject.getYapClass();
        Transaction transaction = yapObject.getTrans();
        Object object = yapObject.getObject();
        this.calculateLengths(transaction, yapClass, object, 0);
        this._baseLength = yapObject.getStream().alignToBlockSize(this._baseLength);
    }

    private void calculateLengths(Transaction transaction, YapClass yapClass, Object object, int n) {
        this._baseLength += 4;
        if (yapClass.i_fields != null) {
            for (int i = 0; i < yapClass.i_fields.length; ++i) {
                YapField yapField = yapClass.i_fields[i];
                Object object2 = yapField.getOrCreate(transaction, object);
                if (object2 == null && yapField.canUseNullBitmap()) {
                    this._nullBitMap.setTrue(n);
                } else {
                    yapField.calculateLengths(transaction, this, object2);
                }
                ++n;
            }
        }
        if (yapClass.i_ancestor == null) {
            return;
        }
        this.calculateLengths(transaction, yapClass.i_ancestor, object, n);
    }

    private int headerLength() {
        return 5;
    }

    public boolean isNull(int n) {
        return this._nullBitMap.isTrue(n);
    }

    private int nullBitMapLength() {
        return 4 + this._nullBitMap.marshalledLength();
    }

    public int objectLength() {
        return this._baseLength + this._payLoadLength;
    }

    public void prepareIndexedPayLoadEntry(Transaction transaction) {
        this._payLoadLength = transaction.i_stream.alignToBlockSize(this._payLoadLength);
    }

    public void write(YapWriter yapWriter) {
        yapWriter.append((byte)1);
        yapWriter.writeInt(this._fieldCount);
        yapWriter.writeBitMap(this._nullBitMap);
        yapWriter._payloadOffset = this._baseLength;
    }
}

