/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.freespace;

import com.db4o.YapFile;
import com.db4o.YapWriter;
import com.db4o.inside.freespace.FreespaceManagerIx;
import com.db4o.inside.freespace.FreespaceManagerRam;

public abstract class FreespaceManager {
    final YapFile _file;
    public static final byte FM_DEFAULT = 0;
    public static final byte FM_LEGACY_RAM = 1;
    public static final byte FM_RAM = 2;
    public static final byte FM_IX = 3;
    private static final int INTS_IN_SLOT = 12;

    FreespaceManager(YapFile yapFile) {
        this._file = yapFile;
    }

    public static byte checkType(byte by) {
        if (by == 0) {
            return 2;
        }
        return by;
    }

    public static FreespaceManager createNew(YapFile yapFile, byte by) {
        by = FreespaceManager.checkType(by);
        switch (by) {
            case 1: 
            case 2: {
                return new FreespaceManagerRam(yapFile);
            }
        }
        return new FreespaceManagerIx(yapFile);
    }

    public static int initSlot(YapFile yapFile) {
        int n = yapFile.getSlot(FreespaceManager.slotLength());
        FreespaceManager.slotEntryToZeroes(yapFile, n);
        return n;
    }

    static void slotEntryToZeroes(YapFile yapFile, int n) {
        YapWriter yapWriter = new YapWriter(yapFile.getSystemTransaction(), n, FreespaceManager.slotLength());
        for (int i = 0; i < 12; ++i) {
            yapWriter.writeInt(0);
        }
        yapWriter.writeEncrypt();
    }

    static final int slotLength() {
        return 48;
    }

    public abstract void beginCommit();

    final int blockSize() {
        return this._file.blockSize();
    }

    public abstract void debug();

    final int discardLimit() {
        return this._file.i_config.discardFreeSpace();
    }

    public abstract void endCommit();

    public abstract void free(int var1, int var2);

    public abstract void freeSelf();

    public abstract int getSlot(int var1);

    public abstract void migrate(FreespaceManager var1);

    public abstract void read(int var1);

    public abstract void start(int var1);

    public abstract byte systemType();

    public abstract int write(boolean var1);
}

