/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Config4Impl;
import com.db4o.Db4o;
import com.db4o.Msg;
import com.db4o.MsgD;
import com.db4o.Transaction;
import com.db4o.User;
import com.db4o.YapFile;
import com.db4o.YapServer;
import com.db4o.YapStreamBase;
import com.db4o.foundation.network.YapSocket;
import java.io.IOException;

final class YapServerThread
extends Thread {
    private String i_clientName;
    private boolean i_loggedin;
    private long i_lastClientMessage;
    private final YapFile i_mainStream;
    private Transaction i_mainTrans;
    private int i_pingAttempts = 0;
    private int i_nullMessages;
    private boolean i_rollbackOnClose = true;
    private boolean i_sendCloseMessage = true;
    private final YapServer i_server;
    private YapSocket i_socket;
    private YapFile i_substituteStream;
    private Transaction i_substituteTrans;
    private Config4Impl i_config;
    final int i_threadID;

    YapServerThread(YapServer yapServer, YapFile yapFile, YapSocket yapSocket, int n, boolean bl) throws Exception {
        this.i_loggedin = bl;
        this.i_lastClientMessage = System.currentTimeMillis();
        this.i_server = yapServer;
        this.i_config = (Config4Impl)this.i_server.configure();
        this.i_mainStream = yapFile;
        this.i_threadID = n;
        this.setName("db4o message server " + n);
        this.i_mainTrans = new Transaction(yapFile, yapFile.getSystemTransaction());
        try {
            this.i_socket = yapSocket;
            this.i_socket.setSoTimeout(((Config4Impl)yapServer.configure()).timeoutServerSocket());
        }
        catch (Exception exception) {
            this.i_socket.close();
            throw exception;
        }
    }

    public void close() {
        this.closeSubstituteStream();
        try {
            if (this.i_sendCloseMessage) {
                Msg.CLOSE.write(this.i_mainStream, this.i_socket);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.i_mainStream != null && this.i_mainTrans != null) {
            this.i_mainTrans.close(this.i_rollbackOnClose);
        }
        try {
            this.i_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.i_socket = null;
        try {
            this.i_server.removeThread(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSubstituteStream() {
        if (this.i_substituteStream != null) {
            if (this.i_substituteTrans != null) {
                this.i_substituteTrans.close(this.i_rollbackOnClose);
                this.i_substituteTrans = null;
            }
            try {
                this.i_substituteStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.i_substituteStream = null;
        }
    }

    private final YapFile getStream() {
        if (this.i_substituteStream != null) {
            return this.i_substituteStream;
        }
        return this.i_mainStream;
    }

    Transaction getTransaction() {
        if (this.i_substituteTrans != null) {
            return this.i_substituteTrans;
        }
        return this.i_mainTrans;
    }

    public void run() {
        while (this.i_socket != null) {
            try {
                if (!this.messageProcessor()) {
                    break;
                }
            }
            catch (Exception exception) {
                if (this.i_mainStream == null || this.i_mainStream.isClosed() || !this.i_socket.isConnected()) break;
                ++this.i_nullMessages;
            }
            if (this.i_nullMessages <= 20 && !this.pingClientTimeoutReached()) continue;
            if (this.i_pingAttempts > 5) {
                this.getStream().logMsg(33, this.i_clientName);
                break;
            }
            if (null == this.i_socket) break;
            Msg.PING.write(this.getStream(), this.i_socket);
            ++this.i_pingAttempts;
        }
        this.close();
    }

    private boolean pingClientTimeoutReached() {
        return System.currentTimeMillis() - this.i_lastClientMessage > (long)this.i_config.timeoutPingClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean messageProcessor() throws IOException {
        Msg msg = Msg.readMessage(this.getTransaction(), this.i_socket);
        if (msg == null) {
            ++this.i_nullMessages;
            return true;
        }
        this.i_lastClientMessage = System.currentTimeMillis();
        this.i_nullMessages = 0;
        this.i_pingAttempts = 0;
        if (!this.i_loggedin) {
            if (!Msg.LOGIN.equals(msg)) return true;
            String string = ((MsgD)msg).readString();
            String string2 = ((MsgD)msg).readString();
            User user = new User();
            user.name = string;
            this.i_mainStream.showInternalClasses(true);
            User user2 = (User)this.i_mainStream.get(user).next();
            this.i_mainStream.showInternalClasses(false);
            if (user2 == null) {
                Msg.FAILED.write(this.i_mainStream, this.i_socket);
                return false;
            }
            if (!user2.password.equals(string2)) {
                Msg.FAILED.write(this.i_mainStream, this.i_socket);
                return false;
            }
            this.i_clientName = string;
            this.i_mainStream.logMsg(32, this.i_clientName);
            byte by = this.i_mainStream.blockSize();
            int n = this.i_mainStream.i_handlers.i_encrypt ? 1 : 0;
            Msg.LOGIN_OK.getWriterForInts(this.getTransaction(), new int[]{by, n}).write(this.i_mainStream, this.i_socket);
            this.i_loggedin = true;
            this.setName("db4o server socket for client " + this.i_clientName);
            return true;
        }
        if (msg.processMessageAtServer(this.i_socket)) {
            return true;
        }
        if (Msg.PING.equals(msg)) {
            Msg.OK.write(this.getStream(), this.i_socket);
            return true;
        }
        if (Msg.CLOSE.equals(msg)) {
            Msg.CLOSE.write(this.getStream(), this.i_socket);
            this.getTransaction().commit();
            this.i_sendCloseMessage = false;
            this.getStream().logMsg(34, this.i_clientName);
            return false;
        }
        if (Msg.IDENTITY.equals(msg)) {
            this.respondInt((int)this.getStream().getID(this.getStream().bootRecord().i_db));
            return true;
        }
        if (Msg.CURRENT_VERSION.equals(msg)) {
            YapFile yapFile = this.getStream();
            long l = 0L;
            YapFile yapFile2 = yapFile;
            synchronized (yapFile2) {
                l = this.getStream().bootRecord().currentVersion();
            }
            Msg.ID_LIST.getWriterForLong(this.getTransaction(), l).write(this.getStream(), this.i_socket);
            return true;
        }
        if (Msg.RAISE_VERSION.equals(msg)) {
            YapFile yapFile;
            long l = ((MsgD)msg).readLong();
            YapFile yapFile3 = yapFile = this.getStream();
            synchronized (yapFile3) {
                ((YapStreamBase)yapFile).raiseVersion(l);
                return true;
            }
        }
        if (Msg.GET_THREAD_ID.equals(msg)) {
            this.respondInt(this.i_threadID);
            return true;
        }
        if (Msg.SWITCH_TO_FILE.equals(msg)) {
            this.switchToFile(msg);
            return true;
        }
        if (Msg.SWITCH_TO_MAIN_FILE.equals(msg)) {
            this.switchToMainFile();
            return true;
        }
        if (!Msg.USE_TRANSACTION.equals(msg)) return true;
        this.useTransaction(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchToFile(Msg msg) {
        Object object = this.i_mainStream.i_lock;
        synchronized (object) {
            String string = ((MsgD)msg).readString();
            try {
                this.closeSubstituteStream();
                this.i_substituteStream = (YapFile)Db4o.openFile(string);
                this.i_substituteTrans = new Transaction(this.i_substituteStream, this.i_substituteStream.getSystemTransaction());
                this.i_substituteStream.i_config.setMessageRecipient(this.i_mainStream.i_config.messageRecipient());
                Msg.OK.write(this.getStream(), this.i_socket);
            }
            catch (Exception exception) {
                this.closeSubstituteStream();
                Msg.ERROR.write(this.getStream(), this.i_socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchToMainFile() {
        Object object = this.i_mainStream.i_lock;
        synchronized (object) {
            this.closeSubstituteStream();
            Msg.OK.write(this.getStream(), this.i_socket);
        }
    }

    private void useTransaction(Msg msg) {
        int n = ((MsgD)msg).readInt();
        YapServerThread yapServerThread = this.i_server.findThread(n);
        if (yapServerThread != null) {
            Transaction transaction = yapServerThread.getTransaction();
            if (this.i_substituteTrans != null) {
                this.i_substituteTrans = transaction;
            } else {
                this.i_mainTrans = transaction;
            }
            this.i_rollbackOnClose = false;
        }
    }

    private void respondInt(int n) {
        Msg.ID_LIST.getWriterForInt(this.getTransaction(), n).write(this.getStream(), this.i_socket);
    }
}

