/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Config4Class;
import com.db4o.Config4Impl;
import com.db4o.Db4o;
import com.db4o.JDK;
import com.db4o.JavaOnly;
import com.db4o.Messages;
import com.db4o.ObjectContainer;
import com.db4o.P1Collection;
import com.db4o.QConEvaluation;
import com.db4o.ShutDownRunnable;
import com.db4o.Transaction;
import com.db4o.YapArray;
import com.db4o.YapArrayN;
import com.db4o.YapObject;
import com.db4o.YapStream;
import com.db4o.YapTypeAbstract;
import com.db4o.config.Configuration;
import com.db4o.config.ObjectAttribute;
import com.db4o.config.ObjectClass;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Visitor4;
import com.db4o.handlers.NetDateTime;
import com.db4o.handlers.NetDecimal;
import com.db4o.handlers.NetSByte;
import com.db4o.handlers.NetUInt;
import com.db4o.handlers.NetULong;
import com.db4o.handlers.NetUShort;
import com.db4o.inside.Exceptions4;
import com.db4o.query.Candidate;
import com.db4o.query.Evaluation;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.types.Db4oCollections;
import java.net.Socket;
import java.util.Date;

public final class Platform4 {
    private static int collectionCheck;
    private static JDK jdkWrapper;
    private static int nioCheck;
    private static int setAccessibleCheck;
    private static int shutDownHookCheck;
    static int callConstructorCheck;
    static ShutDownRunnable shutDownRunnable;
    static Thread shutDownThread;
    static final String ACCESSIBLEOBJECT = "java.lang.reflect.AccessibleObject";
    static final String REFLECTIONFACTORY = "sun.reflect.ReflectionFactory";
    static final String GETCONSTRUCTOR = "newConstructorForSerialization";
    static final String UTIL = "java.util.";
    static final String DB4O_PACKAGE = "com.db4o.";
    static final String DB4O_CONFIG = "com.db4o.config.";
    static final String DB4O_ASSEMBLY = ", db4o";
    private static int weakReferenceCheck;
    private static final Class[] SIMPLE_CLASSES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void addShutDownHook(Object object, Object object2) {
        Object object3 = object2;
        synchronized (object3) {
            if (Platform4.hasShutDownHook()) {
                if (shutDownThread == null) {
                    shutDownRunnable = new ShutDownRunnable();
                    shutDownThread = Platform4.jdk().addShutdownHook(shutDownRunnable);
                }
                shutDownRunnable.ensure(object);
            }
        }
    }

    public static final boolean canSetAccessible() {
        if (setAccessibleCheck == 0) {
            if (Platform4.jdk().ver() >= 2) {
                setAccessibleCheck = 1;
            } else {
                setAccessibleCheck = -1;
                if (Db4o.i_config.messageLevel() >= 0) {
                    Messages.logErr(Db4o.i_config, 47, null, null);
                }
            }
        }
        return setAccessibleCheck == 1;
    }

    static final boolean classIsAvailable(String string) {
        try {
            return Class.forName(string) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static Db4oCollections collections(Object object) {
        return Platform4.jdk().collections((YapStream)object);
    }

    static final Reflector createReflector(Object object) {
        return Platform4.jdk().createReflector(object);
    }

    static final Object createReferenceQueue() {
        return Platform4.jdk().createReferenceQueue();
    }

    public static Object createWeakReference(Object object) {
        return Platform4.jdk().createWeakReference(object);
    }

    static final Object createYapRef(Object object, Object object2, Object object3) {
        return Platform4.jdk().createYapRef(object, (YapObject)object2, object3);
    }

    static Object deserialize(byte[] byArray) {
        return Platform4.jdk().deserialize(byArray);
    }

    static final long doubleToLong(double d) {
        return Double.doubleToLongBits(d);
    }

    static final QConEvaluation evaluationCreate(Transaction transaction, Object object) {
        if (object instanceof Evaluation) {
            return new QConEvaluation(transaction, object);
        }
        return null;
    }

    static final void evaluationEvaluate(Object object, Candidate candidate) {
        ((Evaluation)object).evaluate(candidate);
    }

    public static Object[] collectionToArray(YapStream yapStream, Object object) {
        Collection4 collection4 = Platform4.flattenCollection(yapStream, object);
        Object[] objectArray = new Object[collection4.size()];
        collection4.toArray(objectArray);
        return objectArray;
    }

    static final Collection4 flattenCollection(YapStream yapStream, Object object) {
        Collection4 collection4 = new Collection4();
        Platform4.flattenCollection1(yapStream, object, collection4);
        return collection4;
    }

    public static Config4Class extendConfiguration(ReflectClass reflectClass, Configuration configuration, Config4Class config4Class) {
        return Platform4.jdk().extendConfiguration(reflectClass, configuration, config4Class);
    }

    static final void flattenCollection1(YapStream yapStream, Object object, Collection4 collection4) {
        if (object == null) {
            collection4.add(null);
        } else {
            ReflectClass reflectClass = yapStream.reflector().forObject(object);
            if (reflectClass.isArray()) {
                Object[] objectArray = reflectClass.getComponentType().isArray() ? new YapArrayN(yapStream, null, false).allElements(object) : new YapArray(yapStream, null, false).allElements(object);
                for (int i = 0; i < objectArray.length; ++i) {
                    Platform4.flattenCollection1(yapStream, objectArray[i], collection4);
                }
            } else {
                Platform4.flattenCollection2(yapStream, object, collection4);
            }
        }
    }

    static final void flattenCollection2(final YapStream yapStream, Object object, final Collection4 collection4) {
        GenericReflector genericReflector = yapStream.reflector();
        if (genericReflector.forObject(object).isCollection()) {
            Platform4.forEachCollectionElement(object, new Visitor4(){

                public void visit(Object object) {
                    Platform4.flattenCollection1(yapStream, object, collection4);
                }
            });
        } else {
            collection4.add(object);
        }
    }

    static final void forEachCollectionElement(Object object, Visitor4 visitor4) {
        Platform4.jdk().forEachCollectionElement(object, visitor4);
    }

    static final String format(Date date, boolean bl) {
        return Platform4.jdk().format(date, bl);
    }

    public static Object getClassForType(Object object) {
        return object;
    }

    static final void getDefaultConfiguration(Config4Impl config4Impl) {
        Platform4.jdk();
        Platform4.hasWeakReferences();
        Platform4.hasNio();
        Platform4.hasCollections();
        Platform4.hasShutDownHook();
        if (config4Impl.reflector() == null) {
            config4Impl.reflectWith(Platform4.jdk().createReflector(null));
        }
        config4Impl.objectClass("java.lang.StringBuffer").compare(new ObjectAttribute(){

            public Object attribute(Object object) {
                if (object instanceof StringBuffer) {
                    return ((StringBuffer)object).toString();
                }
                return object;
            }
        });
        Platform4.translate(config4Impl, config4Impl.objectClass("java.lang.Class"), "TClass");
        Platform4.translateCollection(config4Impl, "Hashtable", "THashtable", true);
        if (Platform4.jdk().ver() >= 2) {
            try {
                Platform4.translateCollection(config4Impl, "AbstractCollection", "TCollection", false);
                Platform4.translateUtilNull(config4Impl, "AbstractList");
                Platform4.translateUtilNull(config4Impl, "AbstractSequentialList");
                Platform4.translateUtilNull(config4Impl, "LinkedList");
                Platform4.translateUtilNull(config4Impl, "ArrayList");
                Platform4.translateUtilNull(config4Impl, "Vector");
                Platform4.translateUtilNull(config4Impl, "Stack");
                Platform4.translateUtilNull(config4Impl, "AbstractSet");
                Platform4.translateUtilNull(config4Impl, "HashSet");
                Platform4.translate(config4Impl, "java.util.TreeSet", "TTreeSet");
                Platform4.translateCollection(config4Impl, "AbstractMap", "TMap", true);
                Platform4.translateUtilNull(config4Impl, "HashMap");
                Platform4.translateUtilNull(config4Impl, "WeakHashMap");
                Platform4.translate(config4Impl, "java.util.TreeMap", "TTreeMap");
            }
            catch (Exception exception) {}
        } else {
            Platform4.translateCollection(config4Impl, "Vector", "TVector", false);
        }
        Platform4.netReadAsJava(config4Impl, "ext.Db4oDatabase");
        Platform4.netReadAsJava(config4Impl, "MetaClass");
        Platform4.netReadAsJava(config4Impl, "MetaField");
        Platform4.netReadAsJava(config4Impl, "MetaIndex");
        Platform4.netReadAsJava(config4Impl, "P1Object");
        Platform4.netReadAsJava(config4Impl, "P1Collection");
        Platform4.netReadAsJava(config4Impl, "P1HashElement");
        Platform4.netReadAsJava(config4Impl, "P1ListElement");
        Platform4.netReadAsJava(config4Impl, "P2HashMap");
        Platform4.netReadAsJava(config4Impl, "P2LinkedList");
        Platform4.netReadAsJava(config4Impl, "PBootRecord");
        Platform4.netReadAsJava(config4Impl, "StaticClass");
        Platform4.netReadAsJava(config4Impl, "StaticField");
    }

    public static Object getTypeForClass(Object object) {
        return object;
    }

    static final Object getYapRefObject(Object object) {
        return Platform4.jdk().getYapRefObject(object);
    }

    static final synchronized boolean hasCollections() {
        if (collectionCheck == 0) {
            if (Platform4.classIsAvailable("java.util.Collection")) {
                collectionCheck = 1;
                return true;
            }
            collectionCheck = -1;
        }
        return collectionCheck == 1;
    }

    static final boolean hasLockFileThread() {
        return true;
    }

    static final boolean hasNio() {
        if (nioCheck == 0) {
            if (Platform4.jdk().ver() >= 4 && !Platform4.noNIO()) {
                nioCheck = 1;
                return true;
            }
            nioCheck = -1;
        }
        return nioCheck == 1;
    }

    static final boolean hasShutDownHook() {
        if (shutDownHookCheck == 0) {
            if (Platform4.jdk().ver() >= 3) {
                shutDownHookCheck = 1;
                return true;
            }
            JavaOnly.runFinalizersOnExit();
            shutDownHookCheck = -1;
        }
        return shutDownHookCheck == 1;
    }

    static final boolean hasWeakReferences() {
        if (weakReferenceCheck == 0) {
            if (Platform4.classIsAvailable(ACCESSIBLEOBJECT) && Platform4.classIsAvailable("java.lang.ref.ReferenceQueue") && Platform4.jdk().ver() >= 2) {
                weakReferenceCheck = 1;
                return true;
            }
            weakReferenceCheck = -1;
        }
        return weakReferenceCheck == 1;
    }

    static final boolean ignoreAsConstraint(Object object) {
        return false;
    }

    static final boolean isCollectionTranslator(Config4Class config4Class) {
        return Platform4.jdk().isCollectionTranslator(config4Class);
    }

    public static boolean isConnected(Socket socket) {
        return Platform4.jdk().isConnected(socket);
    }

    public static final boolean isValueType(ReflectClass reflectClass) {
        return false;
    }

    public static JDK jdk() {
        if (jdkWrapper == null) {
            Platform4.createJdk();
        }
        return jdkWrapper;
    }

    private static void createJdk() {
        if (Platform4.classIsAvailable("java.lang.reflect.Method")) {
            jdkWrapper = (JDK)Platform4.createInstance("com.db4o.JDKReflect");
        }
        if (Platform4.classIsAvailable(ACCESSIBLEOBJECT)) {
            jdkWrapper = Platform4.createJDKWrapper("1_2");
        }
        if (Platform4.jdk().methodIsAvailable("java.lang.Runtime", "addShutdownHook", new Class[]{Thread.class})) {
            jdkWrapper = Platform4.createJDKWrapper("1_3");
        }
        if (Platform4.classIsAvailable("java.nio.channels.FileLock")) {
            jdkWrapper = Platform4.createJDKWrapper("1_4");
        }
        if (Platform4.classIsAvailable("java.lang.Enum")) {
            jdkWrapper = Platform4.createJDKWrapper("5");
        }
    }

    private static JDK createJDKWrapper(String string) {
        JDK jDK = (JDK)Platform4.createInstance("com.db4o.JDK_" + string);
        if (jDK != null) {
            return jDK;
        }
        return jdkWrapper;
    }

    private static final Object createInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz != null) {
                return clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isSimple(Class clazz) {
        for (int i = 0; i < SIMPLE_CLASSES.length; ++i) {
            if (clazz != SIMPLE_CLASSES[i]) continue;
            return true;
        }
        return false;
    }

    static final void killYapRef(Object object) {
        Platform4.jdk().killYapRef(object);
    }

    public static void link() {
        JavaOnly.link();
    }

    public static final void lockFile(Object object) {
        if (!Platform4.hasNio()) {
            return;
        }
        String string = System.getProperty("java.fullversion");
        if (string != null && string.indexOf("GNU libgcj") >= 0) {
            System.err.println("Warning: Running in libgcj 3.x--not locking database file!");
            return;
        }
        Platform4.jdk().lockFile(object);
    }

    public static final void unlockFile(Object object) {
        if (Platform4.hasNio()) {
            Platform4.jdk().unlockFile(object);
        }
    }

    static final double longToDouble(long l) {
        return Double.longBitsToDouble(l);
    }

    static void markTransient(String string) {
    }

    static boolean callConstructor() {
        if (callConstructorCheck == 0) {
            if (Platform4.jdk().methodIsAvailable(REFLECTIONFACTORY, GETCONSTRUCTOR, new Class[]{Class.class, Platform4.jdk().constructorClass()})) {
                callConstructorCheck = -1;
                return false;
            }
            callConstructorCheck = 1;
        }
        return callConstructorCheck == 1;
    }

    private static final void netReadAsJava(Config4Impl config4Impl, String string) {
        Config4Class config4Class = (Config4Class)config4Impl.objectClass(DB4O_PACKAGE + string + DB4O_ASSEMBLY);
        if (config4Class == null) {
            return;
        }
        config4Class.maintainMetaClass(false);
        config4Class.readAs(DB4O_PACKAGE + string);
    }

    private static final boolean noNIO() {
        try {
            return Platform4.propertyIs("java.vendor", "Sun") && Platform4.propertyIs("java.version", "1.4.0") && (Platform4.propertyIs("os.name", "Linux") || Platform4.propertyIs("os.name", "Windows 95") || Platform4.propertyIs("os.name", "Windows 98"));
        }
        catch (Exception exception) {
            return true;
        }
    }

    static final void pollReferenceQueue(Object object, Object object2) {
        Platform4.jdk().pollReferenceQueue((YapStream)object, object2);
    }

    static void postOpen(ObjectContainer objectContainer) {
    }

    static void preClose(ObjectContainer objectContainer) {
    }

    private static final boolean propertyIs(String string, String string2) {
        String string3 = System.getProperty(string);
        return string3 != null && string3.indexOf(string2) == 0;
    }

    public static void registerCollections(GenericReflector genericReflector) {
        genericReflector.registerCollection(P1Collection.class);
        Platform4.jdk().registerCollections(genericReflector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void removeShutDownHook(Object object, Object object2) {
        Object object3 = object2;
        synchronized (object3) {
            if (Platform4.hasShutDownHook()) {
                if (shutDownRunnable != null) {
                    shutDownRunnable.remove(object);
                }
                if (shutDownRunnable.size() == 0) {
                    if (!Platform4.shutDownRunnable.dontRemove) {
                        try {
                            Platform4.jdk().removeShutdownHook(shutDownThread);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    shutDownThread = null;
                    shutDownRunnable = null;
                }
            }
        }
    }

    static final byte[] serialize(Object object) throws Exception {
        return Platform4.jdk().serialize(object);
    }

    public static final void setAccessible(Object object) {
        if (setAccessibleCheck == 0) {
            Platform4.canSetAccessible();
        }
        if (setAccessibleCheck == 1) {
            Platform4.jdk().setAccessible(object);
        }
    }

    public static boolean storeStaticFieldValues(Reflector reflector, ReflectClass reflectClass) {
        return Platform4.jdk().isEnum(reflector, reflectClass);
    }

    private static final void translate(Config4Impl config4Impl, ObjectClass objectClass, String string) {
        ((Config4Class)objectClass).translateOnDemand(DB4O_CONFIG + string);
    }

    private static final void translate(Config4Impl config4Impl, String string, String string2) {
        Platform4.translate(config4Impl, config4Impl.objectClass(string), string2);
    }

    private static final void translateCollection(Config4Impl config4Impl, String string, String string2, boolean bl) {
        ObjectClass objectClass = config4Impl.objectClass(UTIL + string);
        objectClass.updateDepth(3);
        if (bl) {
            objectClass.cascadeOnDelete(true);
        }
        Platform4.translate(config4Impl, objectClass, string2);
    }

    private static final void translateUtilNull(Config4Impl config4Impl, String string) {
        Platform4.translate(config4Impl, UTIL + string, "TNull");
    }

    static final YapTypeAbstract[] types(YapStream yapStream) {
        return new YapTypeAbstract[]{new NetDateTime(yapStream), new NetDecimal(yapStream), new NetSByte(yapStream), new NetUInt(yapStream), new NetULong(yapStream), new NetUShort(yapStream)};
    }

    static byte[] updateClassName(byte[] byArray) {
        return byArray;
    }

    public static Object weakReferenceTarget(Object object) {
        return Platform4.jdk().weakReferenceTarget(object);
    }

    public static Object wrapEvaluation(Object object) {
        throw Exceptions4.virtualException();
    }

    public static boolean isTransient(ReflectClass reflectClass) {
        return false;
    }

    static {
        SIMPLE_CLASSES = JavaOnly.SIMPLE_CLASSES;
    }
}

