/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.ta.instrumentation;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.EditorVisitor;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Type;
import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.foundation.ObjectByRef;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.core.InstrumentationStatus;
import com.db4o.instrumentation.util.BloatUtil;
import com.db4o.instrumentation.util.LoadStoreInstructions;
import com.db4o.ta.ActivatableInstrumented;
import com.db4o.ta.instrumentation.FieldAccess;
import java.util.Comparator;
import java.util.TreeMap;

class InstrumentFieldAccessEdit
implements BloatClassEdit {
    private ClassFilter _filter;

    public InstrumentFieldAccessEdit(ClassFilter filter) {
        this._filter = filter;
    }

    public InstrumentationStatus enhance(ClassEditor ce, ClassLoader origLoader, BloatLoaderContext loaderContext) {
        if (this.isAlreadyInstrumented(ce)) {
            return InstrumentationStatus.FAILED;
        }
        return this.instrumentAllMethods(ce, origLoader, loaderContext);
    }

    private boolean isAlreadyInstrumented(ClassEditor ce) {
        return BloatUtil.implementsDirectly(ce, ActivatableInstrumented.class);
    }

    private InstrumentationStatus instrumentAllMethods(ClassEditor ce, final ClassLoader origLoader, final BloatLoaderContext loaderContext) {
        final MemberRef activateMethod = this.createMethodReference(ce.type(), "activate", new Type[0], Type.VOID);
        final MemberRef bindMethod = this.createMethodReference(ce.type(), "bind", new Type[]{Type.getType(Activator.class)}, Type.VOID);
        final ObjectByRef<InstrumentationStatus> instrumented = new ObjectByRef<InstrumentationStatus>(InstrumentationStatus.NOT_INSTRUMENTED);
        ce.visit(new EditorVisitor(){

            public void visitClassEditor(ClassEditor editor) {
                editor.addInterface(ActivatableInstrumented.class);
            }

            public void visitFieldEditor(FieldEditor editor) {
            }

            public void visitMethodEditor(MethodEditor editor) {
                if (editor.isAbstract()) {
                    return;
                }
                MemberRef methodRef = editor.memberRef();
                if (methodRef.equals(activateMethod) || methodRef.equals(bindMethod)) {
                    return;
                }
                TreeMap<Integer, FieldAccess> fieldAccessIndexes = new TreeMap<Integer, FieldAccess>(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return -((Comparable)o1).compareTo(o2);
                    }
                });
                for (int codeIdx = 0; codeIdx < editor.codeLength(); ++codeIdx) {
                    Object curCode = editor.codeElementAt(codeIdx);
                    MemberRef fieldRef = this.fieldRef(curCode);
                    if (fieldRef == null || !this.accept(fieldRef)) continue;
                    boolean writeAccess = ((Instruction)curCode).origOpcode() == 181;
                    fieldAccessIndexes.put(new Integer(codeIdx), new FieldAccess(fieldRef, writeAccess ? ActivationPurpose.WRITE : ActivationPurpose.READ));
                }
                if (fieldAccessIndexes.isEmpty()) {
                    return;
                }
                try {
                    int modifiedCount = 0;
                    for (Integer idx : fieldAccessIndexes.keySet()) {
                        FieldAccess fieldAccess;
                        if (!this.instrumentFieldAccess(loaderContext, editor, idx, fieldAccess = (FieldAccess)fieldAccessIndexes.get(idx))) continue;
                        ++modifiedCount;
                    }
                    editor.commit();
                    if (modifiedCount > 0) {
                        instrumented.value = InstrumentationStatus.INSTRUMENTED;
                    }
                }
                catch (ClassNotFoundException e) {
                    instrumented.value = InstrumentationStatus.FAILED;
                    return;
                }
            }

            private boolean instrumentFieldAccess(BloatLoaderContext loaderContext2, MethodEditor editor, Integer idx, FieldAccess fieldAccess) throws ClassNotFoundException {
                MemberRef fieldRef = fieldAccess.fieldRef;
                ClassEditor fieldParentClassEditor = loaderContext2.classEditor(fieldRef.declaringClass());
                if (!this.isPersistentField(loaderContext2, fieldParentClassEditor, fieldRef)) {
                    return false;
                }
                if (editor.isConstructor() && editor.declaringClass().name().equals(fieldParentClassEditor.name())) {
                    return false;
                }
                MemberRef targetActivateMethod = InstrumentFieldAccessEdit.this.createMethodReference(fieldRef.declaringClass(), "activate", new Type[]{Type.getType(ActivationPurpose.class)}, Type.VOID);
                if (targetActivateMethod == null) {
                    return false;
                }
                int insertionPoint = idx;
                if (ActivationPurpose.WRITE == fieldAccess.purpose) {
                    LoadStoreInstructions instructions = BloatUtil.loadStoreInstructionsFor(fieldRef.type());
                    LocalVariable temp = editor.newLocal(fieldRef.type());
                    editor.insertCodeAt(new Instruction(instructions.store, temp), insertionPoint++);
                    insertionPoint = this.insertActivateCall(editor, targetActivateMethod, insertionPoint, ActivationPurpose.WRITE);
                    editor.insertCodeAt(new Instruction(instructions.load, temp), insertionPoint);
                } else {
                    this.insertActivateCall(editor, targetActivateMethod, insertionPoint, ActivationPurpose.READ);
                }
                return true;
            }

            private int insertActivateCall(MethodEditor editor, MemberRef targetActivateMethod, int insertionPoint, ActivationPurpose purpose) {
                editor.insertCodeAt(new Instruction(89), insertionPoint);
                editor.insertCodeAt(new Instruction(178, this.purposeFieldFor(purpose)), ++insertionPoint);
                editor.insertCodeAt(new Instruction(182, targetActivateMethod), ++insertionPoint);
                return ++insertionPoint;
            }

            private MemberRef purposeFieldFor(ActivationPurpose purpose) {
                String fieldName = ActivationPurpose.READ == purpose ? "READ" : "WRITE";
                return InstrumentFieldAccessEdit.this.createMemberRef(Type.getType(ActivationPurpose.class), fieldName, Type.getType(ActivationPurpose.class));
            }

            private boolean isPersistentField(BloatLoaderContext loaderContext2, ClassEditor ce, MemberRef fieldRef) throws ClassNotFoundException {
                FieldEditor fieldEdit = loaderContext2.field(ce, fieldRef.name(), fieldRef.type());
                return !fieldEdit.isTransient() && !fieldEdit.isStatic();
            }

            private boolean accept(MemberRef fieldRef) {
                String className = fieldRef.declaringClass().className();
                String normalizedClassName = BloatUtil.normalizeClassName(className);
                try {
                    Class<?> clazz = origLoader.loadClass(normalizedClassName);
                    if (clazz.isEnum()) {
                        return false;
                    }
                    return InstrumentFieldAccessEdit.this._filter.accept(clazz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            private MemberRef fieldRef(Object code) {
                if (!(code instanceof Instruction)) {
                    return null;
                }
                Instruction curInstr = (Instruction)code;
                if (curInstr.origOpcode() == 180 || curInstr.origOpcode() == 181) {
                    return (MemberRef)curInstr.operand();
                }
                return null;
            }
        });
        if (((InstrumentationStatus)instrumented.value).isInstrumented()) {
            ce.commit();
        }
        return (InstrumentationStatus)instrumented.value;
    }

    private MemberRef createMethodReference(Type parent, String name, Type[] args, Type ret) {
        return this.createMemberRef(parent, name, Type.getType(args, ret));
    }

    private MemberRef createMemberRef(Type parent, String name, Type type) {
        NameAndType nameAndType = new NameAndType(name, type);
        return new MemberRef(parent, nameAndType);
    }
}

