/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.optimization;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.instrumentation.api.NativeClassFactory;
import com.db4o.instrumentation.api.ReferenceResolver;
import com.db4o.nativequery.expr.AndExpression;
import com.db4o.nativequery.expr.BoolConstExpression;
import com.db4o.nativequery.expr.ComparisonExpression;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.expr.ExpressionVisitor;
import com.db4o.nativequery.expr.NotExpression;
import com.db4o.nativequery.expr.OrExpression;
import com.db4o.nativequery.expr.cmp.ComparisonOperator;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperandAnchor;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import com.db4o.nativequery.optimization.ComparisonQueryGeneratingVisitor;
import com.db4o.query.Constraint;
import com.db4o.query.Query;

public class SODAQueryBuilder {
    public void optimizeQuery(Expression expr, Query query, Object predicate, NativeClassFactory classSource, ReferenceResolver referenceResolver) {
        expr.accept(new SODAQueryVisitor(query, predicate, classSource, referenceResolver));
    }

    private static class SODAQueryVisitor
    implements ExpressionVisitor {
        private Object _predicate;
        private Query _query;
        private Constraint _constraint;
        private NativeClassFactory _classSource;
        private ReferenceResolver _referenceResolver;

        SODAQueryVisitor(Query query, Object predicate, NativeClassFactory classSource, ReferenceResolver referenceResolver) {
            this._query = query;
            this._predicate = predicate;
            this._classSource = classSource;
            this._referenceResolver = referenceResolver;
        }

        public void visit(AndExpression expression) {
            expression.left().accept(this);
            Constraint left = this._constraint;
            expression.right().accept(this);
            left.and(this._constraint);
            this._constraint = left;
        }

        public void visit(BoolConstExpression expression) {
        }

        public void visit(OrExpression expression) {
            expression.left().accept(this);
            Constraint left = this._constraint;
            expression.right().accept(this);
            left.or(this._constraint);
            this._constraint = left;
        }

        public void visit(ComparisonExpression expression) {
            Query subQuery = this.descend(expression.left());
            ComparisonQueryGeneratingVisitor visitor = new ComparisonQueryGeneratingVisitor(this._predicate, this._classSource, this._referenceResolver);
            expression.right().accept(visitor);
            this._constraint = subQuery.constrain(visitor.value());
            ComparisonOperator op = expression.op();
            if (op.equals(ComparisonOperator.VALUE_EQUALITY)) {
                return;
            }
            if (op.equals(ComparisonOperator.REFERENCE_EQUALITY)) {
                this._constraint.identity();
                return;
            }
            if (op.equals(ComparisonOperator.GREATER)) {
                this._constraint.greater();
                return;
            }
            if (op.equals(ComparisonOperator.SMALLER)) {
                this._constraint.smaller();
                return;
            }
            if (op.equals(ComparisonOperator.CONTAINS)) {
                this._constraint.contains();
                return;
            }
            if (op.equals(ComparisonOperator.STARTS_WITH)) {
                this._constraint.startsWith(true);
                return;
            }
            if (op.equals(ComparisonOperator.ENDS_WITH)) {
                this._constraint.endsWith(true);
                return;
            }
            throw new RuntimeException("Can't handle constraint: " + op);
        }

        private Query descend(FieldValue left) {
            Query subQuery = this._query;
            Iterator4 fieldNameIterator = this.fieldNames(left);
            while (fieldNameIterator.moveNext()) {
                subQuery = subQuery.descend((String)fieldNameIterator.current());
            }
            return subQuery;
        }

        public void visit(NotExpression expression) {
            expression.expr().accept(this);
            this._constraint.not();
        }

        private Iterator4 fieldNames(FieldValue fieldValue) {
            Collection4<String> coll = new Collection4<String>();
            ComparisonOperandAnchor curOp = fieldValue;
            while (curOp instanceof FieldValue) {
                FieldValue curField = curOp;
                coll.prepend(curField.fieldName());
                curOp = curField.parent();
            }
            return coll.iterator();
        }
    }
}

