/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.instrumentation;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.instrumentation.api.CallingConvention;
import com.db4o.instrumentation.api.InstrumentationException;
import com.db4o.instrumentation.api.MethodBuilder;
import com.db4o.instrumentation.api.MethodRef;
import com.db4o.instrumentation.api.TypeEditor;
import com.db4o.instrumentation.api.TypeRef;
import com.db4o.internal.query.Db4oEnhancedFilter;
import com.db4o.nativequery.expr.AndExpression;
import com.db4o.nativequery.expr.BoolConstExpression;
import com.db4o.nativequery.expr.ComparisonExpression;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.expr.ExpressionVisitor;
import com.db4o.nativequery.expr.NotExpression;
import com.db4o.nativequery.expr.OrExpression;
import com.db4o.nativequery.expr.cmp.ComparisonOperator;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperandAnchor;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import com.db4o.nativequery.instrumentation.ComparisonBytecodeGeneratingVisitor;
import com.db4o.nativequery.optimization.NativeQueriesPlatform;
import com.db4o.query.Constraint;
import com.db4o.query.Query;

public class SODAMethodBuilder {
    private static final boolean LOG_BYTECODE = false;
    private MethodRef descendRef;
    private MethodRef constrainRef;
    private MethodRef greaterRef;
    private MethodRef smallerRef;
    private MethodRef containsRef;
    private MethodRef startsWithRef;
    private MethodRef endsWithRef;
    private MethodRef notRef;
    private MethodRef andRef;
    private MethodRef orRef;
    private MethodRef identityRef;
    private final TypeEditor _editor;
    private MethodBuilder _builder;
    public static final String OPTIMIZE_QUERY_METHOD_NAME = "optimizeQuery";

    public SODAMethodBuilder(TypeEditor editor) {
        this._editor = editor;
        this.buildMethodReferences();
    }

    public void injectOptimization(Expression expr) {
        this._editor.addInterface(this.typeRef(Db4oEnhancedFilter.class));
        this._builder = this._editor.newPublicMethod(this.platformName(OPTIMIZE_QUERY_METHOD_NAME), this.typeRef(Void.TYPE), new TypeRef[]{this.typeRef(Query.class)});
        TypeRef predicateClass = this._editor.type();
        expr.accept(new SODAExpressionBuilder(predicateClass));
        this._builder.pop();
        this._builder.endMethod();
    }

    private TypeRef typeRef(Class type) {
        return this._editor.references().forType(type);
    }

    private String platformName(String name) {
        return NativeQueriesPlatform.toPlatformName(name);
    }

    private void loadArgument(int index) {
        this._builder.loadArgument(index);
    }

    private void invoke(MethodRef method) {
        this._builder.invoke(method, CallingConvention.INTERFACE);
    }

    private void ldc(Object value) {
        this._builder.ldc(value);
    }

    private void buildMethodReferences() {
        this.descendRef = this.methodRef(Query.class, "descend", new Class[]{String.class});
        this.constrainRef = this.methodRef(Query.class, "constrain", new Class[]{Object.class});
        this.greaterRef = this.methodRef(Constraint.class, "greater", new Class[0]);
        this.smallerRef = this.methodRef(Constraint.class, "smaller", new Class[0]);
        this.containsRef = this.methodRef(Constraint.class, "contains", new Class[0]);
        this.startsWithRef = this.methodRef(Constraint.class, "startsWith", new Class[]{Boolean.TYPE});
        this.endsWithRef = this.methodRef(Constraint.class, "endsWith", new Class[]{Boolean.TYPE});
        this.notRef = this.methodRef(Constraint.class, "not", new Class[0]);
        this.andRef = this.methodRef(Constraint.class, "and", new Class[]{Constraint.class});
        this.orRef = this.methodRef(Constraint.class, "or", new Class[]{Constraint.class});
        this.identityRef = this.methodRef(Constraint.class, "identity", new Class[0]);
    }

    private MethodRef methodRef(Class parent, String name, Class[] args) {
        try {
            return this._editor.references().forMethod(parent.getMethod(this.platformName(name), args));
        }
        catch (Exception e) {
            throw new InstrumentationException(e);
        }
    }

    private class SODAExpressionBuilder
    implements ExpressionVisitor {
        private TypeRef predicateClass;

        public SODAExpressionBuilder(TypeRef predicateClass) {
            this.predicateClass = predicateClass;
        }

        public void visit(AndExpression expression) {
            expression.left().accept(this);
            expression.right().accept(this);
            SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.andRef);
        }

        public void visit(BoolConstExpression expression) {
            this.loadQuery();
        }

        private void loadQuery() {
            SODAMethodBuilder.this.loadArgument(1);
        }

        public void visit(OrExpression expression) {
            expression.left().accept(this);
            expression.right().accept(this);
            SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.orRef);
        }

        public void visit(ComparisonExpression expression) {
            this.loadQuery();
            this.descend(this.fieldNames(expression.left()));
            expression.right().accept(this.comparisonEmitter());
            this.constrain(expression.op());
        }

        private void descend(Iterator4 fieldNames) {
            while (fieldNames.moveNext()) {
                this.descend(fieldNames.current());
            }
        }

        private ComparisonBytecodeGeneratingVisitor comparisonEmitter() {
            return new ComparisonBytecodeGeneratingVisitor(SODAMethodBuilder.this._builder, this.predicateClass);
        }

        private void constrain(ComparisonOperator op) {
            SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.constrainRef);
            if (op.equals(ComparisonOperator.VALUE_EQUALITY)) {
                return;
            }
            if (op.equals(ComparisonOperator.REFERENCE_EQUALITY)) {
                SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.identityRef);
                return;
            }
            if (op.equals(ComparisonOperator.GREATER)) {
                SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.greaterRef);
                return;
            }
            if (op.equals(ComparisonOperator.SMALLER)) {
                SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.smallerRef);
                return;
            }
            if (op.equals(ComparisonOperator.CONTAINS)) {
                SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.containsRef);
                return;
            }
            if (op.equals(ComparisonOperator.STARTS_WITH)) {
                SODAMethodBuilder.this.ldc(new Integer(1));
                SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.startsWithRef);
                return;
            }
            if (op.equals(ComparisonOperator.ENDS_WITH)) {
                SODAMethodBuilder.this.ldc(new Integer(1));
                SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.endsWithRef);
                return;
            }
            throw new RuntimeException("Cannot interpret constraint: " + op);
        }

        private void descend(Object fieldName) {
            SODAMethodBuilder.this.ldc(fieldName);
            SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.descendRef);
        }

        public void visit(NotExpression expression) {
            expression.expr().accept(this);
            SODAMethodBuilder.this.invoke(SODAMethodBuilder.this.notRef);
        }

        private Iterator4 fieldNames(FieldValue fieldValue) {
            Collection4<String> coll = new Collection4<String>();
            ComparisonOperandAnchor curOp = fieldValue;
            while (curOp instanceof FieldValue) {
                FieldValue curField = curOp;
                coll.prepend(curField.fieldName());
                curOp = curField.parent();
            }
            return coll.iterator();
        }
    }
}

