/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.expr;

import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.expr.ExpressionVisitor;
import com.db4o.nativequery.expr.cmp.ComparisonOperator;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperand;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;

public class ComparisonExpression
implements Expression {
    private FieldValue _left;
    private ComparisonOperand _right;
    private ComparisonOperator _op;

    public ComparisonExpression(FieldValue left, ComparisonOperand right, ComparisonOperator op) {
        if (left == null || right == null || op == null) {
            throw new NullPointerException();
        }
        this._left = left;
        this._right = right;
        this._op = op;
    }

    public FieldValue left() {
        return this._left;
    }

    public ComparisonOperand right() {
        return this._right;
    }

    public ComparisonOperator op() {
        return this._op;
    }

    public String toString() {
        return this._left + " " + this._op + " " + this._right;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ComparisonExpression casted = (ComparisonExpression)other;
        return this._left.equals(casted._left) && this._right.equals(casted._right) && this._op.equals(casted._op);
    }

    public int hashCode() {
        return (this._left.hashCode() * 29 + this._right.hashCode()) * 29 + this._op.hashCode();
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

