/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.example;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.config.ObjectClass;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.query.Db4oQueryExecutionListener;
import com.db4o.internal.query.NQOptimizationInfo;
import com.db4o.nativequery.example.Student;
import com.db4o.query.Predicate;
import java.io.File;

public class SimpleMain {
    private static final String FILENAME = "simple.db4o";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.setProperty("db4o.dynamicnq", "true");
        new File(FILENAME).delete();
        Configuration config = Db4o.newConfiguration();
        ObjectClass classConfig = config.objectClass(Student.class);
        classConfig.objectField("name").indexed(true);
        classConfig.objectField("age").indexed(true);
        ObjectContainer db = Db4o.openFile(config, FILENAME);
        try {
            Student mumon = new Student(100, "Mumon", 1.5f);
            Student tortoise = new Student(101, "Tortoise", 0.85f, mumon);
            Student achilles = new Student(30, "Achilles", 1.8f, tortoise);
            db.store(mumon);
            db.store(tortoise);
            db.store(achilles);
            db.commit();
            db.close();
            db = Db4o.openFile(config, FILENAME);
            String protoName = "Achilles";
            Predicate<Student> filter = new Predicate<Student>(){
                private int protoAge = 203;

                @Override
                public boolean match(Student candidate) {
                    return candidate.tortue != null && candidate.getTortue().getAge() >= this.protoAge / 2 || candidate.getName().equals("Achilles") || candidate.getSize() < 1.0f;
                }
            };
            ((InternalObjectContainer)db).getNativeQueryHandler().addListener(new Db4oQueryExecutionListener(){

                public void notifyQueryExecuted(NQOptimizationInfo info) {
                    System.err.println(info.message());
                }
            });
            long startTime = System.currentTimeMillis();
            ObjectSet<Student> filtered = db.query(filter);
            for (Student student : filtered) {
                System.out.println(student);
            }
            System.out.println("Took " + (System.currentTimeMillis() - startTime) + " ms");
        }
        finally {
            db.close();
        }
    }
}

