/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring.internal;

import com.db4o.foundation.Environments;
import com.db4o.monitoring.internal.Clock;

public class TimedReading {
    private static final int IDENTITY_MS_FACTOR = 1;
    private final Clock _clock = Environments.my(Clock.class);
    private final int _msFactor;
    private int _count;
    private long _lastAccessTime = this.currentTimeMillis();

    public TimedReading() {
        this(1);
    }

    public TimedReading(int msFactor) {
        this._msFactor = msFactor;
    }

    public void incrementBy(int count) {
        this._count += count;
    }

    public void increment() {
        ++this._count;
    }

    public double read() {
        long curTime = this.currentTimeMillis();
        long timeDiff = curTime - this._lastAccessTime;
        double reading = timeDiff > 0L ? (double)this._count * (double)this._msFactor / (double)timeDiff : 0.0;
        this._lastAccessTime = curTime;
        this._count = 0;
        return reading;
    }

    public int peek() {
        return this._count;
    }

    private long currentTimeMillis() {
        return this._clock.currentTimeMillis();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._count + ")";
    }

    public static TimedReading newPerSecond() {
        return new TimedReading(1000);
    }

    public void resetCount() {
        this._count = 0;
        this._lastAccessTime = this.currentTimeMillis();
    }
}

