/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring;

import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectInfoEventArgs;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.monitoring.Db4oMBeans;
import com.db4o.monitoring.ObjectLifecycle;

public class ObjectLifecycleMonitoringSupport
implements ConfigurationItem {
    public void apply(InternalObjectContainer container) {
        final ObjectLifecycle objectLifecycle = Db4oMBeans.newObjectLifecycleMBean(container);
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer(container);
        eventRegistry.created().addListener(new EventListener4<ObjectInfoEventArgs>(){

            @Override
            public void onEvent(Event4<ObjectInfoEventArgs> e, ObjectInfoEventArgs args) {
                objectLifecycle.notifyStored();
            }
        });
        eventRegistry.updated().addListener(new EventListener4<ObjectInfoEventArgs>(){

            @Override
            public void onEvent(Event4<ObjectInfoEventArgs> e, ObjectInfoEventArgs args) {
                objectLifecycle.notifyStored();
            }
        });
        eventRegistry.activated().addListener(new EventListener4<ObjectInfoEventArgs>(){

            @Override
            public void onEvent(Event4<ObjectInfoEventArgs> e, ObjectInfoEventArgs args) {
                objectLifecycle.notifyActivated();
            }
        });
        eventRegistry.deactivated().addListener(new EventListener4<ObjectInfoEventArgs>(){

            @Override
            public void onEvent(Event4<ObjectInfoEventArgs> e, ObjectInfoEventArgs args) {
                objectLifecycle.notifyDeactivated();
            }
        });
        if (container.isClient()) {
            return;
        }
        eventRegistry.deleted().addListener(new EventListener4<ObjectInfoEventArgs>(){

            @Override
            public void onEvent(Event4<ObjectInfoEventArgs> e, ObjectInfoEventArgs args) {
                objectLifecycle.notifyDeleted();
            }
        });
    }

    public void prepare(Configuration configuration) {
    }
}

