/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.monitoring.IOMBean;
import com.db4o.monitoring.MBeanRegistrationSupport;
import com.db4o.monitoring.internal.TimedReading;
import javax.management.JMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IO
extends MBeanRegistrationSupport
implements IOMBean {
    private TimedReading _numBytesReadPerSec = TimedReading.newPerSecond();
    private TimedReading _numBytesWrittenPerSec = TimedReading.newPerSecond();
    private TimedReading _numReadsPerSec = TimedReading.newPerSecond();
    private TimedReading _numWritesPerSec = TimedReading.newPerSecond();
    private TimedReading _numSyncsPerSec = TimedReading.newPerSecond();

    public IO(ObjectContainer db, Class<?> type) throws JMException {
        super(db, type);
    }

    @Override
    public double getBytesReadPerSecond() {
        return this._numBytesReadPerSec.read();
    }

    @Override
    public double getBytesWrittenPerSecond() {
        return this._numBytesWrittenPerSec.read();
    }

    @Override
    public double getReadsPerSecond() {
        return this._numReadsPerSec.read();
    }

    @Override
    public double getWritesPerSecond() {
        return this._numWritesPerSec.read();
    }

    @Override
    public double getSyncsPerSecond() {
        return this._numSyncsPerSec.read();
    }

    public void notifyBytesRead(int numBytesRead) {
        this._numBytesReadPerSec.incrementBy(numBytesRead);
        this._numReadsPerSec.increment();
    }

    public void notifyBytesWritten(int numBytesWritten) {
        this._numBytesWrittenPerSec.incrementBy(numBytesWritten);
        this._numWritesPerSec.increment();
    }

    public void notifySync() {
        this._numSyncsPerSec.increment();
    }
}

