/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.internal.freespace.FreespaceListener;
import com.db4o.monitoring.FreespaceMBean;
import com.db4o.monitoring.MBeanRegistrationSupport;
import com.db4o.monitoring.internal.TimedReading;
import javax.management.JMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Freespace
extends MBeanRegistrationSupport
implements FreespaceMBean,
FreespaceListener {
    private final TimedReading _reusedSlots = TimedReading.newPerSecond();
    private int _slotCount;
    private int _totalFreespace;

    public Freespace(ObjectContainer db, Class<?> type) throws JMException {
        super(db, type);
    }

    @Override
    public double getAverageSlotSize() {
        double slotCount = this._slotCount;
        if (slotCount == 0.0) {
            return 0.0;
        }
        return (double)this._totalFreespace / slotCount;
    }

    @Override
    public double getReusedSlotsPerSecond() {
        return this._reusedSlots.read();
    }

    @Override
    public int getSlotCount() {
        return this._slotCount;
    }

    @Override
    public int getTotalFreespace() {
        return this._totalFreespace;
    }

    @Override
    public void slotAdded(int size) {
        ++this._slotCount;
        this._totalFreespace += size;
    }

    @Override
    public void slotRemoved(int size) {
        this._reusedSlots.increment();
        --this._slotCount;
        this._totalFreespace -= size;
    }
}

