/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.slots;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.TransactionalIdSystemImpl;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SystemSlotChange;

public class IdSystemSlotChange
extends SystemSlotChange {
    private Collection4 _freed;

    public IdSystemSlotChange(int id) {
        super(id);
    }

    protected void free(FreespaceManager freespaceManager, Slot slot) {
        if (slot.isNull()) {
            return;
        }
        if (this._freed == null) {
            this._freed = new Collection4();
        }
        this._freed.add(slot);
    }

    public void accumulateFreeSlot(TransactionalIdSystemImpl idSystem, FreespaceCommitter freespaceCommitter, boolean forFreespace) {
        if (this.forFreespace() != forFreespace) {
            return;
        }
        super.accumulateFreeSlot(idSystem, freespaceCommitter, forFreespace);
        if (this._freed == null) {
            return;
        }
        Iterator4 iterator = this._freed.iterator();
        while (iterator.moveNext()) {
            freespaceCommitter.delayedFree((Slot)iterator.current(), this.freeToSystemFreespaceSystem());
        }
    }

    protected boolean freeToSystemFreespaceSystem() {
        return true;
    }
}

