/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.ObjectSet;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.ByRef;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.CompositeIterator4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.IntByRef;
import com.db4o.foundation.IntComparator;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.List4;
import com.db4o.foundation.MappingIterator;
import com.db4o.foundation.NoDuplicatesQueue;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Handlers4;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.query.ObjectSetFacade;
import com.db4o.internal.query.SodaQueryComparator;
import com.db4o.internal.query.processor.InternalQuery;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QConClass;
import com.db4o.internal.query.processor.QConEvaluation;
import com.db4o.internal.query.processor.QConJoin;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.query.processor.QConPath;
import com.db4o.internal.query.processor.QConUnconditional;
import com.db4o.internal.query.processor.QConstraints;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.IdListQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.query.Constraint;
import com.db4o.query.Constraints;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;
import com.db4o.types.Unversioned;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QQueryBase
implements InternalQuery,
Unversioned {
    transient Transaction _trans;
    private Collection4 i_constraints = new Collection4();
    private QQuery i_parent;
    private String i_field;
    private transient QueryEvaluationMode _evaluationMode;
    private int _prefetchDepth;
    private int _prefetchCount;
    private int _evaluationModeAsInt;
    private QueryComparator _comparator;
    private final transient QQuery _this = QQueryBase.cast(this);
    private List<SodaQueryComparator.Ordering> _orderings;

    protected QQueryBase() {
    }

    protected QQueryBase(Transaction a_trans, QQuery a_parent, String a_field) {
        this._trans = a_trans;
        this.i_parent = a_parent;
        this.i_field = a_field;
    }

    public void captureQueryResultConfig() {
        Config4Impl config = this._trans.container().config();
        this._evaluationMode = config.evaluationMode();
        this._prefetchDepth = config.prefetchDepth();
        this._prefetchCount = config.prefetchObjectCount();
    }

    void addConstraint(QCon a_constraint) {
        this.i_constraints.add(a_constraint);
    }

    private void addConstraint(Collection4 col, Object obj) {
        if (this.attachToExistingConstraints(col, obj, true)) {
            return;
        }
        if (this.attachToExistingConstraints(col, obj, false)) {
            return;
        }
        QConObject newConstraint = new QConObject(this._trans, null, null, obj);
        this.addConstraint(newConstraint);
        col.add(newConstraint);
    }

    private boolean attachToExistingConstraints(Collection4 newConstraintsCollector, Object obj, boolean onlyForPaths) {
        boolean found = false;
        Iterator4 j = this.iterateConstraints();
        while (j.moveNext()) {
            QCon newConstraint;
            QCon existingConstraint = (QCon)j.current();
            BooleanByRef removeExisting = new BooleanByRef(false);
            if (onlyForPaths && !(existingConstraint instanceof QConPath) || (newConstraint = existingConstraint.shareParent(obj, removeExisting)) == null) continue;
            newConstraintsCollector.add(newConstraint);
            this.addConstraint(newConstraint);
            if (removeExisting.value) {
                this.removeConstraint(existingConstraint);
            }
            found = true;
            if (onlyForPaths) continue;
            break;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint constrain(Object example) {
        Object object = this.streamLock();
        synchronized (object) {
            ReflectClass claxx = this.reflectClassForClass(example);
            if (claxx != null) {
                return this.addClassConstraint(claxx);
            }
            QConEvaluation eval = Platform4.evaluationCreate(this._trans, example);
            if (eval != null) {
                return this.addEvaluationToAllConstraints(eval);
            }
            Collection4 constraints = new Collection4();
            this.addConstraint(constraints, example);
            return this.toConstraint(constraints);
        }
    }

    private Constraint addEvaluationToAllConstraints(QConEvaluation eval) {
        if (this.i_constraints.size() == 0) {
            this._trans.container().classCollection().iterateTopLevelClasses(new Visitor4(){

                public void visit(Object obj) {
                    ClassMetadata classMetadata = (ClassMetadata)obj;
                    QConClass qcc = new QConClass(QQueryBase.this._trans, classMetadata.classReflector());
                    QQueryBase.this.addConstraint(qcc);
                    QQueryBase.this.toConstraint(QQueryBase.this.i_constraints).or(qcc);
                }
            });
        }
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).addConstraint(eval);
        }
        return null;
    }

    private Constraint addClassConstraint(ReflectClass claxx) {
        if (this.isTheObjectClass(claxx)) {
            return null;
        }
        if (claxx.isInterface()) {
            return this.addInterfaceConstraint(claxx);
        }
        Collection4 newConstraints = this.introduceClassConstrain(claxx);
        if (newConstraints.isEmpty()) {
            QConClass qcc = new QConClass(this._trans, claxx);
            this.addConstraint(qcc);
            return qcc;
        }
        return this.toConstraint(newConstraints);
    }

    private Collection4 introduceClassConstrain(ReflectClass claxx) {
        Collection4<QConClass> newConstraints = new Collection4<QConClass>();
        Iterator4 existingConstraints = this.iterateConstraints();
        while (existingConstraints.moveNext()) {
            BooleanByRef removeExisting;
            QConObject existingConstraint = (QConObject)existingConstraints.current();
            QConClass newConstraint = ((QCon)existingConstraint).shareParentForClass(claxx, removeExisting = new BooleanByRef(false));
            if (newConstraint == null) continue;
            newConstraints.add(newConstraint);
            this.addConstraint(newConstraint);
            if (!removeExisting.value) continue;
            this.removeConstraint(existingConstraint);
        }
        return newConstraints;
    }

    private boolean isTheObjectClass(ReflectClass claxx) {
        return claxx.equals(this.stream()._handlers.ICLASS_OBJECT);
    }

    private Constraint addInterfaceConstraint(ReflectClass claxx) {
        Collection4 classes = this.stream().classCollection().forInterface(claxx);
        if (classes.size() == 0) {
            QConClass qcc = new QConClass(this._trans, null, null, claxx);
            this.addConstraint(qcc);
            return qcc;
        }
        Iterator4 i = classes.iterator();
        Constraint constr = null;
        while (i.moveNext()) {
            ClassMetadata classMetadata = (ClassMetadata)i.current();
            ReflectClass classMetadataClaxx = classMetadata.classReflector();
            if (classMetadataClaxx == null || classMetadataClaxx.isInterface()) continue;
            if (constr == null) {
                constr = this.constrain(classMetadataClaxx);
                continue;
            }
            constr = constr.or(this.constrain(classMetadata.classReflector()));
        }
        return constr;
    }

    private ReflectClass reflectClassForClass(Object example) {
        if (example instanceof ReflectClass) {
            return (ReflectClass)example;
        }
        if (example instanceof Class) {
            return this._trans.reflector().forClass((Class)example);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraints constraints() {
        Object object = this.streamLock();
        synchronized (object) {
            Constraint[] constraints = new Constraint[this.i_constraints.size()];
            this.i_constraints.toArray(constraints);
            return new QConstraints(this._trans, constraints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query descend(String a_field) {
        Object object = this.streamLock();
        synchronized (object) {
            QQuery query = new QQuery(this._trans, this._this, a_field);
            IntByRef run = new IntByRef(1);
            if (!this.descend1(query, a_field, run) && run.value == 1) {
                run.value = 2;
                if (!this.descend1(query, a_field, run)) {
                    new QConUnconditional(this._trans, false).attach(query, a_field);
                }
            }
            return query;
        }
    }

    private boolean descend1(QQuery query, String fieldName, IntByRef run) {
        if (run.value == 2 || this.i_constraints.size() == 0) {
            run.value = 0;
            this.stream().classCollection().attachQueryNode(fieldName, new Visitor4(){
                boolean untypedFieldConstraintCollected = false;

                public void visit(Object obj) {
                    Object[] pair = (Object[])obj;
                    ClassMetadata containingClass = (ClassMetadata)pair[0];
                    FieldMetadata field = (FieldMetadata)pair[1];
                    if (this.isTyped(field)) {
                        this.addFieldConstraint(containingClass, field);
                        return;
                    }
                    if (this.untypedFieldConstraintCollected) {
                        return;
                    }
                    this.addFieldConstraint(containingClass, field);
                    this.untypedFieldConstraintCollected = true;
                }

                private boolean isTyped(FieldMetadata field) {
                    return !Handlers4.isUntyped(field.getHandler());
                }

                private void addFieldConstraint(ClassMetadata containingClass, FieldMetadata field) {
                    QConClass qcc = new QConClass(QQueryBase.this._trans, null, field.qField(QQueryBase.this._trans), containingClass.classReflector());
                    QQueryBase.this.addConstraint(qcc);
                    QQueryBase.this.toConstraint(QQueryBase.this.i_constraints).or(qcc);
                }
            });
        }
        this.checkConstraintsEvaluationMode();
        BooleanByRef foundClass = new BooleanByRef(false);
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            if (!((QCon)i.current()).attach(query, fieldName)) continue;
            foundClass.value = true;
        }
        return foundClass.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet execute() {
        Object object = this.streamLock();
        synchronized (object) {
            return this.triggeringQueryEvents(new Closure4<ObjectSet>(){

                @Override
                public ObjectSet run() {
                    return new ObjectSetFacade(QQueryBase.this.getQueryResult());
                }
            });
        }
    }

    public void executeLocal(final IdListQueryResult result) {
        this.checkConstraintsEvaluationMode();
        CreateCandidateCollectionResult r = this.createCandidateCollection();
        boolean checkDuplicates = r.checkDuplicates;
        boolean topLevel = r.topLevel;
        List4 candidateCollection = r.candidateCollection;
        if (candidateCollection != null) {
            final Collection4 executionPath = topLevel ? null : this.fieldPathFromTop();
            Iterator4Impl i = new Iterator4Impl(candidateCollection);
            while (i.moveNext()) {
                ((QCandidates)i.current()).execute();
            }
            if (candidateCollection._next != null) {
                checkDuplicates = true;
            }
            if (checkDuplicates) {
                result.checkDuplicates();
            }
            final ObjectContainerBase stream = this.stream();
            i = new Iterator4Impl(candidateCollection);
            while (i.moveNext()) {
                QCandidates candidates = (QCandidates)i.current();
                if (topLevel) {
                    candidates.traverse(result);
                    continue;
                }
                candidates.traverse(new Visitor4(){

                    public void visit(Object a_object) {
                        QCandidate candidate = (QCandidate)a_object;
                        if (candidate.include()) {
                            TreeInt ids = new TreeInt(candidate._key);
                            final ByRef idsNew = new ByRef();
                            Iterator4 itPath = executionPath.iterator();
                            while (itPath.moveNext()) {
                                idsNew.value = null;
                                final String fieldName = (String)itPath.current();
                                if (ids != null) {
                                    ids.traverse(new Visitor4(){

                                        public void visit(Object treeInt) {
                                            int id = ((TreeInt)treeInt)._key;
                                            StatefulBuffer reader = stream.readStatefulBufferById(QQueryBase.this._trans, id);
                                            if (reader != null) {
                                                ObjectHeader oh = new ObjectHeader(stream, (ReadWriteBuffer)reader);
                                                CollectIdContext context = new CollectIdContext(QQueryBase.this._trans, oh, reader);
                                                oh.classMetadata().collectIDs(context, fieldName);
                                                Tree.traverse(context.ids(), new Visitor4<TreeInt>(){

                                                    @Override
                                                    public void visit(TreeInt node) {
                                                        idsNew.value = TreeInt.add((TreeInt)idsNew.value, node._key);
                                                    }
                                                });
                                            }
                                        }
                                    });
                                }
                                ids = (TreeInt)idsNew.value;
                            }
                            if (ids != null) {
                                ids.traverse(new Visitor4(){

                                    public void visit(Object treeInt) {
                                        result.addKeyCheckDuplicates(((TreeInt)treeInt)._key);
                                    }
                                });
                            }
                        }
                    }
                });
            }
        }
        this.sort(result);
    }

    private void triggerQueryOnFinished() {
        this.stream().callbacks().queryOnFinished(this._trans, QQueryBase.cast(this));
    }

    private void triggerQueryOnStarted() {
        this.stream().callbacks().queryOnStarted(this._trans, QQueryBase.cast(this));
    }

    public Iterator4 executeLazy() {
        this.checkConstraintsEvaluationMode();
        CreateCandidateCollectionResult r = this.createCandidateCollection();
        final Collection4 executionPath = this.executionPath(r);
        Iterator4Impl candidateCollection = new Iterator4Impl(r.candidateCollection);
        MappingIterator executeCandidates = new MappingIterator(candidateCollection){

            protected Object map(Object current) {
                return ((QCandidates)current).executeLazy(executionPath);
            }
        };
        CompositeIterator4 resultingIDs = new CompositeIterator4(executeCandidates);
        if (!r.checkDuplicates) {
            return resultingIDs;
        }
        return this.checkDuplicates(resultingIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult getQueryResult() {
        Object object = this.streamLock();
        synchronized (object) {
            if (this.i_constraints.size() == 0) {
                return this.executeAllObjectsQuery();
            }
            QueryResult result = this.executeClassOnlyQuery();
            if (result != null) {
                return result;
            }
            this.optimizeJoins();
            return this.executeQuery();
        }
    }

    protected final QueryResult executeQuery() {
        return this.stream().executeQuery(this._this);
    }

    private QueryResult executeAllObjectsQuery() {
        return this.stream().queryAllObjects(this._trans);
    }

    protected ObjectContainerBase stream() {
        return this._trans.container();
    }

    @Override
    public InternalObjectContainer container() {
        return this.stream();
    }

    private QueryResult executeClassOnlyQuery() {
        ClassMetadata clazz = this.singleClassConstraint();
        if (null == clazz) {
            return null;
        }
        QueryResult queryResult = this.stream().classOnlyQuery(this, clazz);
        this.sort(queryResult);
        return queryResult;
    }

    private ClassMetadata singleClassConstraint() {
        if (this.requiresSort()) {
            return null;
        }
        QConClass clazzconstr = this.classConstraint();
        if (clazzconstr == null) {
            return null;
        }
        ClassMetadata clazz = clazzconstr._classMetadata;
        if (clazz == null) {
            return null;
        }
        if (clazzconstr.hasChildren() || clazz.isArray()) {
            return null;
        }
        return clazz;
    }

    private QConClass classConstraint() {
        if (this.i_constraints.size() != 1) {
            return null;
        }
        Constraint constr = this.singleConstraint();
        if (constr.getClass() != QConClass.class) {
            return null;
        }
        return (QConClass)constr;
    }

    private Constraint singleConstraint() {
        return (Constraint)this.i_constraints.singleElement();
    }

    public Iterator4 executeSnapshot() {
        CreateCandidateCollectionResult r = this.createCandidateCollection();
        Collection4 executionPath = this.executionPath(r);
        Iterator4Impl candidatesIterator = new Iterator4Impl(r.candidateCollection);
        Collection4<Iterator4> snapshots = new Collection4<Iterator4>();
        while (candidatesIterator.moveNext()) {
            QCandidates candidates = (QCandidates)candidatesIterator.current();
            snapshots.add(candidates.executeSnapshot(executionPath));
        }
        Iterator4 snapshotsIterator = snapshots.iterator();
        CompositeIterator4 resultingIDs = new CompositeIterator4(snapshotsIterator);
        if (!r.checkDuplicates) {
            return resultingIDs;
        }
        return this.checkDuplicates(resultingIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T triggeringQueryEvents(Closure4<T> closure) {
        this.triggerQueryOnStarted();
        try {
            T t = closure.run();
            return t;
        }
        finally {
            this.triggerQueryOnFinished();
        }
    }

    private Iterator4 checkDuplicates(CompositeIterator4 executeAllCandidates) {
        return Iterators.filter(executeAllCandidates, new Predicate4(){
            private TreeInt ids = new TreeInt(0);

            public boolean match(Object current) {
                int id = (Integer)current;
                if (this.ids.find(id) != null) {
                    return false;
                }
                this.ids = this.ids.add(new TreeInt(id));
                return true;
            }
        });
    }

    private Collection4 executionPath(CreateCandidateCollectionResult r) {
        return r.topLevel ? null : this.fieldPathFromTop();
    }

    public void checkConstraintsEvaluationMode() {
        Iterator4 constraints = this.iterateConstraints();
        while (constraints.moveNext()) {
            ((QConObject)constraints.current()).setEvaluationMode();
        }
    }

    private Collection4 fieldPathFromTop() {
        QQueryBase q = this;
        Collection4<String> fieldPath = new Collection4<String>();
        while (q.i_parent != null) {
            fieldPath.prepend(q.i_field);
            q = q.i_parent;
        }
        return fieldPath;
    }

    private void logConstraints() {
    }

    public CreateCandidateCollectionResult createCandidateCollection() {
        List4 candidatesList = this.createQCandidatesList();
        boolean checkDuplicates = false;
        boolean topLevel = true;
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ClassMetadata classMetadata;
            QCon constraint;
            QCon old = constraint = (QCon)i.current();
            if ((constraint = constraint.getRoot()) != old) {
                checkDuplicates = true;
                topLevel = false;
            }
            if ((classMetadata = constraint.getYapClass()) == null) break;
            this.addConstraintToCandidatesList(candidatesList, constraint);
        }
        return new CreateCandidateCollectionResult(candidatesList, checkDuplicates, topLevel);
    }

    private void addConstraintToCandidatesList(List4 candidatesList, QCon qcon) {
        if (candidatesList == null) {
            return;
        }
        Iterator4Impl j = new Iterator4Impl(candidatesList);
        while (j.moveNext()) {
            QCandidates candidates = (QCandidates)j.current();
            candidates.addConstraint(qcon);
        }
    }

    private List4 createQCandidatesList() {
        List4<QCandidates> candidatesList = null;
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            QCon constraint = (QCon)i.current();
            ClassMetadata classMetadata = (constraint = constraint.getRoot()).getYapClass();
            if (classMetadata == null || this.constraintCanBeAddedToExisting(candidatesList, constraint)) continue;
            QCandidates candidates = new QCandidates((LocalTransaction)this._trans, classMetadata, null);
            candidatesList = new List4<QCandidates>(candidatesList, candidates);
        }
        return candidatesList;
    }

    private boolean constraintCanBeAddedToExisting(List4 candidatesList, QCon constraint) {
        Iterator4Impl j = new Iterator4Impl(candidatesList);
        while (j.moveNext()) {
            QCandidates candidates = (QCandidates)j.current();
            if (!candidates.fitsIntoExistingConstraintHierarchy(constraint)) continue;
            return true;
        }
        return false;
    }

    public final Transaction transaction() {
        return this._trans;
    }

    public Iterator4 iterateConstraints() {
        return new Collection4(this.i_constraints).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query orderAscending() {
        if (this.i_parent == null) {
            throw new IllegalStateException("Cannot apply ordering at top level.");
        }
        Object object = this.streamLock();
        synchronized (object) {
            this.addOrdering(SodaQueryComparator.Direction.ASCENDING);
            return this._this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query orderDescending() {
        if (this.i_parent == null) {
            throw new IllegalStateException("Cannot apply ordering at top level.");
        }
        Object object = this.streamLock();
        synchronized (object) {
            this.addOrdering(SodaQueryComparator.Direction.DESCENDING);
            return this._this;
        }
    }

    private void addOrdering(SodaQueryComparator.Direction direction) {
        this.addOrdering(direction, new ArrayList<String>());
    }

    protected final void addOrdering(SodaQueryComparator.Direction direction, List<String> path) {
        if (this.i_field != null) {
            path.add(this.i_field);
        }
        if (this.i_parent != null) {
            this.i_parent.addOrdering(direction, path);
            return;
        }
        String[] fieldPath = this.reverseFieldPath(path);
        this.removeExistingOrderingFor(fieldPath);
        this.orderings().add(new SodaQueryComparator.Ordering(direction, fieldPath));
    }

    private void removeExistingOrderingFor(String[] fieldPath) {
        for (SodaQueryComparator.Ordering ordering : this.orderings()) {
            if (!Arrays.equals(ordering.fieldPath(), fieldPath)) continue;
            this.orderings().remove(ordering);
            break;
        }
    }

    public final List<SodaQueryComparator.Ordering> orderings() {
        if (null == this._orderings) {
            this._orderings = new ArrayList<SodaQueryComparator.Ordering>();
        }
        return this._orderings;
    }

    private String[] reverseFieldPath(List<String> path) {
        String[] reversedPath = new String[path.size()];
        for (int i = 0; i < reversedPath.length; ++i) {
            reversedPath[i] = path.get(path.size() - i - 1);
        }
        return reversedPath;
    }

    public void marshall() {
        this.checkConstraintsEvaluationMode();
        this._evaluationModeAsInt = this._evaluationMode.asInt();
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).getRoot().marshall();
        }
    }

    public void unmarshall(Transaction a_trans) {
        this._evaluationMode = QueryEvaluationMode.fromInt(this._evaluationModeAsInt);
        this._trans = a_trans;
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).unmarshall(a_trans);
        }
    }

    void removeConstraint(QCon a_constraint) {
        this.i_constraints.remove(a_constraint);
    }

    Constraint toConstraint(Collection4 constraints) {
        if (constraints.size() == 1) {
            return (Constraint)constraints.singleElement();
        }
        if (constraints.size() > 0) {
            Constraint[] constraintArray = new Constraint[constraints.size()];
            constraints.toArray(constraintArray);
            return new QConstraints(this._trans, constraintArray);
        }
        return null;
    }

    protected Object streamLock() {
        return this.stream().lock();
    }

    public Query sortBy(QueryComparator comparator) {
        this._comparator = comparator;
        return this._this;
    }

    private void sort(QueryResult result) {
        if (this._orderings != null) {
            result.sortIds(this.newSodaQueryComparator());
        }
        if (this._comparator != null) {
            result.sort(this._comparator);
        }
    }

    private IntComparator newSodaQueryComparator() {
        return new SodaQueryComparator((LocalObjectContainer)this.transaction().container(), this.extentType(), this._orderings.toArray(new SodaQueryComparator.Ordering[this._orderings.size()]));
    }

    private ClassMetadata extentType() {
        return this.classConstraint().getYapClass();
    }

    private static QQuery cast(QQueryBase obj) {
        return (QQuery)obj;
    }

    public boolean requiresSort() {
        return this._comparator != null || this._orderings != null;
    }

    public QueryComparator comparator() {
        return this._comparator;
    }

    public QueryEvaluationMode evaluationMode() {
        return this._evaluationMode;
    }

    public void evaluationMode(QueryEvaluationMode mode) {
        this._evaluationMode = mode;
    }

    private void optimizeJoins() {
        if (!this.hasOrJoins()) {
            this.removeJoins();
        }
    }

    private boolean hasOrJoins() {
        return this.forEachConstraintRecursively(new Function4(){

            public Object apply(Object obj) {
                QCon constr = (QCon)obj;
                Iterator4 joinIter = constr.iterateJoins();
                while (joinIter.moveNext()) {
                    QConJoin join = (QConJoin)joinIter.current();
                    if (!join.isOr()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private void removeJoins() {
        this.forEachConstraintRecursively(new Function4(){

            public Object apply(Object obj) {
                QCon constr = (QCon)obj;
                constr.i_joins = null;
                return Boolean.FALSE;
            }
        });
    }

    private boolean forEachConstraintRecursively(Function4 block) {
        NoDuplicatesQueue queue = new NoDuplicatesQueue(new NonblockingQueue());
        Iterator4 constrIter = this.iterateConstraints();
        while (constrIter.moveNext()) {
            queue.add(constrIter.current());
        }
        while (queue.hasNext()) {
            QCon constr = (QCon)queue.next();
            Boolean cancel = (Boolean)block.apply(constr);
            if (cancel.booleanValue()) {
                return true;
            }
            Iterator4 childIter = constr.iterateChildren();
            while (childIter.moveNext()) {
                queue.add(childIter.current());
            }
            Iterator4 joinIter = constr.iterateJoins();
            while (joinIter.moveNext()) {
                queue.add(joinIter.current());
            }
        }
        return false;
    }

    public int prefetchDepth() {
        return this._prefetchDepth;
    }

    public int prefetchCount() {
        return this._prefetchCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("QQueryBase\n");
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            QCon constraint = (QCon)i.current();
            sb.append(constraint);
            sb.append("\n");
        }
        return sb.toString();
    }

    public QQuery parent() {
        return this.i_parent;
    }

    public static class CreateCandidateCollectionResult {
        public final boolean checkDuplicates;
        public final boolean topLevel;
        public final List4 candidateCollection;

        public CreateCandidateCollectionResult(List4 candidateCollection_, boolean checkDuplicates_, boolean topLevel_) {
            this.candidateCollection = candidateCollection_;
            this.topLevel = topLevel_;
            this.checkDuplicates = checkDuplicates_;
        }
    }
}

