/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.metadata;

import com.db4o.internal.ClassAspect;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.metadata.AspectTraversalStrategy;
import com.db4o.internal.metadata.HierarchyAnalyzer;
import com.db4o.internal.metadata.TraverseAspectCommand;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifiedAspectTraversalStrategy
implements AspectTraversalStrategy {
    private final List<HierarchyAnalyzer.Diff> _classDiffs = new ArrayList<HierarchyAnalyzer.Diff>();

    public ModifiedAspectTraversalStrategy(ClassMetadata classMetadata, List<HierarchyAnalyzer.Diff> ancestors) {
        this._classDiffs.add(new HierarchyAnalyzer.Same(classMetadata));
        this._classDiffs.addAll(ancestors);
    }

    @Override
    public void traverseAllAspects(TraverseAspectCommand command) {
        int currentSlot = 0;
        for (HierarchyAnalyzer.Diff diff : this._classDiffs) {
            ClassMetadata classMetadata = diff.classMetadata();
            if (diff.isRemoved()) {
                currentSlot = this.skipAspectsOf(classMetadata, command, currentSlot);
                continue;
            }
            currentSlot = this.traverseAspectsOf(classMetadata, command, currentSlot);
            if (!command.cancelled()) continue;
            return;
        }
    }

    private int traverseAspectsOf(ClassMetadata classMetadata, TraverseAspectCommand command, int currentSlot) {
        return this.processAspectsOf(classMetadata, command, currentSlot, new TraverseAspectCommandProcessor(){

            public void process(TraverseAspectCommand command, ClassAspect currentAspect, int currentSlot) {
                command.processAspect(currentAspect, currentSlot);
            }
        });
    }

    private int processAspectsOf(ClassMetadata classMetadata, TraverseAspectCommand command, int currentSlot, TraverseAspectCommandProcessor processor) {
        int aspectCount = command.declaredAspectCount(classMetadata);
        for (int i = 0; i < aspectCount && !command.cancelled(); ++i) {
            processor.process(command, classMetadata._aspects[i], currentSlot);
            ++currentSlot;
        }
        return currentSlot;
    }

    private int skipAspectsOf(ClassMetadata classMetadata, TraverseAspectCommand command, int currentSlot) {
        return this.processAspectsOf(classMetadata, command, currentSlot, new TraverseAspectCommandProcessor(){

            public void process(TraverseAspectCommand command, ClassAspect currentAspect, int currentSlot) {
                command.processAspectOnMissingClass(currentAspect, currentSlot);
            }
        });
    }

    static interface TraverseAspectCommandProcessor {
        public void process(TraverseAspectCommand var1, ClassAspect var2, int var3);
    }
}

