/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.metadata;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ReflectPlatform;
import com.db4o.reflect.ReflectClass;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyAnalyzer {
    private ClassMetadata _storedClass;
    private ReflectClass _runtimeClass;
    private final ReflectClass _objectClass;

    public HierarchyAnalyzer(ClassMetadata storedClass, ReflectClass runtimeClass) {
        if (storedClass == null || runtimeClass == null) {
            throw new ArgumentNullException();
        }
        this._storedClass = storedClass;
        this._runtimeClass = runtimeClass;
        this._objectClass = runtimeClass.reflector().forClass(Object.class);
    }

    public List<Diff> analyze() {
        ArrayList<Diff> ancestors = new ArrayList<Diff>();
        ClassMetadata storedAncestor = this._storedClass.getAncestor();
        ReflectClass runtimeAncestor = this._runtimeClass.getSuperclass();
        while (storedAncestor != null) {
            if (runtimeAncestor == storedAncestor.classReflector()) {
                ancestors.add(new Same(storedAncestor));
            } else {
                do {
                    ancestors.add(new Removed(storedAncestor));
                    storedAncestor = storedAncestor.getAncestor();
                    if (null == storedAncestor) {
                        if (this.isObject(runtimeAncestor)) {
                            return ancestors;
                        }
                        this.throwUnsupportedAdd(runtimeAncestor);
                    }
                    if (runtimeAncestor != storedAncestor.classReflector()) continue;
                    ancestors.add(new Same(storedAncestor));
                    break;
                } while (storedAncestor != null);
            }
            storedAncestor = storedAncestor.getAncestor();
            runtimeAncestor = runtimeAncestor.getSuperclass();
        }
        if (runtimeAncestor != null && !this.isObject(runtimeAncestor)) {
            this.throwUnsupportedAdd(runtimeAncestor);
        }
        return ancestors;
    }

    private void throwUnsupportedAdd(ReflectClass runtimeAncestor) {
        throw new IllegalStateException("Unsupported class hierarchy change. Class " + runtimeAncestor.getName() + " was added to hierarchy of " + this._runtimeClass.getName());
    }

    private boolean isObject(ReflectClass clazz) {
        return this._objectClass == clazz;
    }

    public static class Removed
    extends Diff {
        public Removed(ClassMetadata classMetadata) {
            super(classMetadata);
        }

        public boolean isRemoved() {
            return true;
        }
    }

    public static class Same
    extends Diff {
        public Same(ClassMetadata classMetadata) {
            super(classMetadata);
        }
    }

    public static class Diff {
        private final ClassMetadata _classMetadata;

        public Diff(ClassMetadata classMetadata) {
            if (classMetadata == null) {
                throw new ArgumentNullException();
            }
            this._classMetadata = classMetadata;
        }

        public boolean equals(Object obj) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Diff other = (Diff)obj;
            return this._classMetadata == other._classMetadata;
        }

        public String toString() {
            return ReflectPlatform.simpleName(this.getClass()) + "(" + this._classMetadata.getName() + ")";
        }

        public ClassMetadata classMetadata() {
            return this._classMetadata;
        }

        public boolean isRemoved() {
            return false;
        }
    }
}

