/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.BitMap4;
import com.db4o.internal.marshall.AspectType;

public class RawFieldSpec {
    private final AspectType _type;
    private final String _name;
    private final int _fieldTypeID;
    private final boolean _isPrimitive;
    private final boolean _isArray;
    private final boolean _isNArray;
    private final boolean _isVirtual;
    private int _indexID;

    public RawFieldSpec(AspectType aspectType, String name, int fieldTypeID, byte attribs) {
        this._type = aspectType;
        this._name = name;
        this._fieldTypeID = fieldTypeID;
        BitMap4 bitmap = new BitMap4(attribs);
        this._isPrimitive = bitmap.isTrue(0);
        this._isArray = bitmap.isTrue(1);
        this._isNArray = bitmap.isTrue(2);
        this._isVirtual = false;
        this._indexID = 0;
    }

    public RawFieldSpec(AspectType aspectType, String name) {
        this._type = aspectType;
        this._name = name;
        this._fieldTypeID = 0;
        this._isPrimitive = false;
        this._isArray = false;
        this._isNArray = false;
        this._isVirtual = true;
        this._indexID = 0;
    }

    public String name() {
        return this._name;
    }

    public int fieldTypeID() {
        return this._fieldTypeID;
    }

    public boolean isPrimitive() {
        return this._isPrimitive;
    }

    public boolean isArray() {
        return this._isArray;
    }

    public boolean isNArray() {
        return this._isNArray;
    }

    public boolean isVirtual() {
        return this._isVirtual;
    }

    public boolean isVirtualField() {
        return this.isVirtual() && this.isField();
    }

    public boolean isField() {
        return this._type.isField();
    }

    public int indexID() {
        return this._indexID;
    }

    void indexID(int indexID) {
        this._indexID = indexID;
    }

    public String toString() {
        return "RawFieldSpec(" + this.name() + ")";
    }

    public boolean isFieldMetadata() {
        return this._type.isFieldMetadata();
    }

    public boolean isTranslator() {
        return this._type.isTranslator();
    }
}

