/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Platform4;
import com.db4o.internal.marshall.MarshallingConstants0;
import com.db4o.internal.marshall.PrimitiveMarshaller;
import java.util.Date;

public class PrimitiveMarshaller0
extends PrimitiveMarshaller {
    public boolean useNormalClassRead() {
        return true;
    }

    public Date readDate(ByteArrayBuffer bytes) {
        long value = bytes.readLong();
        if (value == Long.MAX_VALUE) {
            return MarshallingConstants0.NULL_DATE;
        }
        return new Date(value);
    }

    public Object readInteger(ByteArrayBuffer bytes) {
        int value = bytes.readInt();
        if (value == Integer.MAX_VALUE) {
            return null;
        }
        return new Integer(value);
    }

    public Object readFloat(ByteArrayBuffer bytes) {
        Float value = PrimitiveMarshaller0.unmarshallFloat(bytes);
        if (value.isNaN()) {
            return null;
        }
        return value;
    }

    public Object readDouble(ByteArrayBuffer buffer) {
        Double value = PrimitiveMarshaller0.unmarshalDouble(buffer);
        if (value.isNaN()) {
            return null;
        }
        return value;
    }

    public Object readLong(ByteArrayBuffer buffer) {
        long value = buffer.readLong();
        if (value == Long.MAX_VALUE) {
            return null;
        }
        return new Long(value);
    }

    public Object readShort(ByteArrayBuffer buffer) {
        short value = PrimitiveMarshaller0.unmarshallShort(buffer);
        if (value == Short.MAX_VALUE) {
            return null;
        }
        return new Short(value);
    }

    public static Double unmarshalDouble(ByteArrayBuffer buffer) {
        return new Double(Platform4.longToDouble(buffer.readLong()));
    }

    public static Float unmarshallFloat(ByteArrayBuffer buffer) {
        return new Float(Float.intBitsToFloat(buffer.readInt()));
    }

    public static short unmarshallShort(ByteArrayBuffer buffer) {
        int ret = 0;
        for (int i = 0; i < 2; ++i) {
            ret = (ret << 8) + (buffer._buffer[buffer._offset++] & 0xFF);
        }
        return (short)ret;
    }
}

