/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.internal.CallbackInfoCollector;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChangeFactory;

public final class TransportIdSystem
implements TransactionalIdSystem {
    private final LocalObjectContainer _container;

    public TransportIdSystem(LocalObjectContainer localObjectContainer) {
        this._container = localObjectContainer;
    }

    public int newId(SlotChangeFactory slotChangeFactory) {
        return this._container.allocatePointerSlot();
    }

    public void notifySlotCreated(int id, Slot slot, SlotChangeFactory slotChangeFactory) {
        this.writePointer(id, slot);
    }

    private void writePointer(int id, Slot slot) {
        this._container.writePointer(id, slot);
    }

    public void notifySlotUpdated(int id, Slot slot, SlotChangeFactory slotChangeFactory) {
        this.writePointer(id, slot);
    }

    public void notifySlotDeleted(int id, SlotChangeFactory slotChangeFactory) {
        this.writePointer(id, Slot.ZERO);
    }

    public void commit(FreespaceCommitter accumulator) {
    }

    public Slot currentSlot(int id) {
        return this.committedSlot(id);
    }

    public void collectCallBackInfo(CallbackInfoCollector collector) {
    }

    public void clear() {
    }

    public Slot committedSlot(int id) {
        return this._container.readPointerSlot(id);
    }

    public boolean isDeleted(int id) {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public int prefetchID() {
        return 0;
    }

    public void prefetchedIDConsumed(int id) {
    }

    public void rollback() {
    }

    public void close() {
    }

    public void accumulateFreeSlots(FreespaceCommitter freespaceCommitter, boolean forFreespace) {
    }
}

