/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.foundation.Visitor4;
import com.db4o.internal.BlockConverter;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.freespace.FreespaceListener;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.slots.Slot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockAwareFreespaceManager
implements FreespaceManager {
    private final FreespaceManager _delegate;
    private final BlockConverter _blockConverter;

    public BlockAwareFreespaceManager(FreespaceManager delegate_, BlockConverter blockConverter) {
        this._delegate = delegate_;
        this._blockConverter = blockConverter;
    }

    @Override
    public Slot allocateSlot(int length) {
        Slot slot = this._delegate.allocateSlot(this._blockConverter.bytesToBlocks(length));
        if (slot == null) {
            return null;
        }
        return this._blockConverter.toNonBlockedLength(slot);
    }

    @Override
    public Slot allocateSafeSlot(int length) {
        Slot slot = this._delegate.allocateSafeSlot(this._blockConverter.bytesToBlocks(length));
        if (slot == null) {
            return null;
        }
        return this._blockConverter.toNonBlockedLength(slot);
    }

    @Override
    public void beginCommit() {
        this._delegate.beginCommit();
    }

    @Override
    public void commit() {
        this._delegate.commit();
    }

    @Override
    public void endCommit() {
        this._delegate.endCommit();
    }

    @Override
    public void free(Slot slot) {
        this._delegate.free(this._blockConverter.toBlockedLength(slot));
    }

    @Override
    public void freeSelf() {
        this._delegate.freeSelf();
    }

    @Override
    public void freeSafeSlot(Slot slot) {
        this._delegate.freeSafeSlot(this._blockConverter.toBlockedLength(slot));
    }

    @Override
    public void listener(FreespaceListener listener) {
        this._delegate.listener(listener);
    }

    @Override
    public void migrateTo(FreespaceManager fm) {
        throw new IllegalStateException();
    }

    @Override
    public int slotCount() {
        return this._delegate.slotCount();
    }

    @Override
    public void start(int id) {
        throw new IllegalStateException();
    }

    @Override
    public byte systemType() {
        return this._delegate.systemType();
    }

    @Override
    public int totalFreespace() {
        return this._blockConverter.blocksToBytes(this._delegate.totalFreespace());
    }

    @Override
    public void traverse(final Visitor4<Slot> visitor) {
        this._delegate.traverse(new Visitor4<Slot>(){

            @Override
            public void visit(Slot slot) {
                visitor.visit(BlockAwareFreespaceManager.this._blockConverter.toNonBlockedLength(slot));
            }
        });
    }

    @Override
    public void write(LocalObjectContainer container) {
        this._delegate.write(container);
    }

    @Override
    public void slotFreed(Slot slot) {
        this._delegate.slotFreed(slot);
    }

    @Override
    public boolean isStarted() {
        return this._delegate.isStarted();
    }

    @Override
    public Slot allocateTransactionLogSlot(int length) {
        Slot slot = this._delegate.allocateTransactionLogSlot(this._blockConverter.bytesToBlocks(length));
        if (slot == null) {
            return null;
        }
        return this._blockConverter.toNonBlockedLength(slot);
    }

    @Override
    public void read(LocalObjectContainer container, Slot slot) {
        throw new IllegalStateException();
    }
}

