/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oFileHeaderCorruptionException;
import com.db4o.foundation.CRC32;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.SystemData;
import com.db4o.internal.fileheader.FileHeaderVariablePart;
import com.db4o.internal.slots.Slot;

public class FileHeaderVariablePart2
extends FileHeaderVariablePart {
    private static final int CHECKSUM_LENGTH = 8;
    private static final int SINGLE_LENGTH = 49;
    private int _address;
    private int _length;

    public FileHeaderVariablePart2(LocalObjectContainer container, int address, int length) {
        super(container);
        this._address = address;
        this._length = length;
    }

    public FileHeaderVariablePart2(LocalObjectContainer container) {
        this(container, 0, 0);
    }

    public Runnable commit(boolean shuttingDown) {
        final int length = this.ownLength();
        if (this._address == 0 || this._length < length) {
            Slot slot = this.allocateSlot(this.marshalledLength(length));
            this._address = slot.address();
            this._length = length;
        }
        final ByteArrayBuffer buffer = new ByteArrayBuffer(length);
        this.marshall(buffer, shuttingDown);
        this.writeToFile(0, buffer);
        return new Runnable(){

            public void run() {
                FileHeaderVariablePart2.this.writeToFile(length * 2, buffer);
            }
        };
    }

    private int marshalledLength(int length) {
        return length * 4;
    }

    private void writeToFile(int startAdress, ByteArrayBuffer buffer) {
        this._container.writeEncrypt(buffer, this._address, startAdress);
        this._container.writeEncrypt(buffer, this._address, startAdress + this._length);
    }

    public int ownLength() {
        return 49;
    }

    public int address() {
        return this._address;
    }

    public int length() {
        return this._length;
    }

    public void read(int address, int length) {
        this._address = address;
        this._length = length;
        ByteArrayBuffer buffer = this._container.readBufferBySlot(new Slot(address, this.marshalledLength(length)));
        boolean versionsAreConsistent = this.versionsAreConsistentAndSeek(buffer);
        this.readBuffer(buffer, versionsAreConsistent);
    }

    protected void readBuffer(ByteArrayBuffer buffer, boolean versionsAreConsistent) {
        buffer.incrementOffset(8);
        SystemData systemData = this.systemData();
        systemData.idSystemSlot(this.readSlot(buffer, false));
        systemData.inMemoryFreespaceSlot(this.readSlot(buffer, !versionsAreConsistent));
        systemData.bTreeFreespaceId(buffer.readInt());
        systemData.converterVersion(buffer.readInt());
        systemData.uuidIndexId(buffer.readInt());
        systemData.identityId(buffer.readInt());
        systemData.lastTimeStampID(buffer.readLong());
        systemData.freespaceSystem(buffer.readByte());
    }

    private Slot readSlot(ByteArrayBuffer buffer, boolean readZero) {
        Slot slot = new Slot(buffer.readInt(), buffer.readInt());
        if (readZero) {
            return Slot.ZERO;
        }
        return slot;
    }

    private void marshall(ByteArrayBuffer buffer, boolean shuttingDown) {
        int checkSumOffset = buffer.offset();
        buffer.incrementOffset(8);
        int checkSumBeginOffset = buffer.offset();
        this.writeBuffer(buffer, shuttingDown);
        int checkSumEndOffSet = buffer.offset();
        byte[] bytes = buffer._buffer;
        int length = checkSumEndOffSet - checkSumBeginOffset;
        long checkSum = CRC32.checkSum(bytes, checkSumBeginOffset, length);
        buffer.seek(checkSumOffset);
        buffer.writeLong(checkSum);
        buffer.seek(checkSumEndOffSet);
    }

    protected void writeBuffer(ByteArrayBuffer buffer, boolean shuttingDown) {
        SystemData systemData = this.systemData();
        this.writeSlot(buffer, systemData.idSystemSlot(), false);
        this.writeSlot(buffer, systemData.inMemoryFreespaceSlot(), !shuttingDown);
        buffer.writeInt(systemData.bTreeFreespaceId());
        buffer.writeInt(systemData.converterVersion());
        buffer.writeInt(systemData.uuidIndexId());
        Db4oDatabase identity = systemData.identity();
        buffer.writeInt(identity == null ? 0 : identity.getID(this._container.systemTransaction()));
        buffer.writeLong(systemData.lastTimeStampID());
        buffer.writeByte(systemData.freespaceSystem());
    }

    private void writeSlot(ByteArrayBuffer buffer, Slot slot, boolean writeZero) {
        if (writeZero || slot == null) {
            buffer.writeInt(0);
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(slot.address());
        buffer.writeInt(slot.length());
    }

    private boolean checkSumOK(ByteArrayBuffer buffer, int offset) {
        int initialOffSet = buffer.offset();
        int length = this.ownLength();
        buffer.seek(offset);
        long readCheckSum = buffer.readLong();
        int checkSumBeginOffset = buffer.offset();
        byte[] bytes = buffer._buffer;
        long calculatedCheckSum = CRC32.checkSum(bytes, checkSumBeginOffset, length -= 8);
        buffer.seek(initialOffSet);
        return calculatedCheckSum == readCheckSum;
    }

    private boolean versionsAreConsistentAndSeek(ByteArrayBuffer buffer) {
        byte[] bytes = buffer._buffer;
        int length = this.ownLength();
        int[] offsets = this.offsets();
        boolean different = false;
        block0: for (int i = 0; i < length; ++i) {
            byte b = bytes[offsets[0] + i];
            for (int j = 1; j < 4; ++j) {
                if (b == bytes[offsets[j] + i]) continue;
                different = true;
                continue block0;
            }
        }
        if (!different) {
            int firstOffset = 0;
            if (!this.checkSumOK(buffer, firstOffset)) {
                throw new Db4oFileHeaderCorruptionException();
            }
            return true;
        }
        boolean firstPairDiffers = false;
        boolean secondPairDiffers = false;
        for (int i = 0; i < length; ++i) {
            if (bytes[offsets[0] + i] != bytes[offsets[1] + i]) {
                firstPairDiffers = true;
            }
            if (bytes[offsets[2] + i] == bytes[offsets[3] + i]) continue;
            secondPairDiffers = true;
        }
        if (!secondPairDiffers && this.checkSumOK(buffer, offsets[2])) {
            buffer.seek(offsets[2]);
            return false;
        }
        if (firstPairDiffers) {
            throw new Db4oFileHeaderCorruptionException();
        }
        if (!this.checkSumOK(buffer, 0)) {
            throw new Db4oFileHeaderCorruptionException();
        }
        return false;
    }

    private int[] offsets() {
        return new int[]{0, this.ownLength(), this.ownLength() * 2, this.ownLength() * 3};
    }

    public int marshalledLength() {
        return this.marshalledLength(this.ownLength());
    }
}

