/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.events;

import com.db4o.ObjectContainer;
import com.db4o.events.CancellableObjectEventArgs;
import com.db4o.events.ClassEventArgs;
import com.db4o.events.CommitEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventException;
import com.db4o.events.EventRegistry;
import com.db4o.events.ObjectContainerEventArgs;
import com.db4o.events.ObjectInfoEventArgs;
import com.db4o.events.QueryEventArgs;
import com.db4o.ext.Db4oException;
import com.db4o.ext.ObjectInfo;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.InCallback;
import com.db4o.internal.Transaction;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.events.Event4Impl;
import com.db4o.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRegistryImpl
implements Callbacks,
EventRegistry {
    protected final Event4Impl _queryStarted = new Event4Impl();
    protected final Event4Impl _queryFinished = new Event4Impl();
    protected final Event4Impl _creating = new Event4Impl();
    protected final Event4Impl _activating = new Event4Impl();
    protected final Event4Impl _updating = new Event4Impl();
    protected final Event4Impl _deleting = new Event4Impl();
    protected final Event4Impl _deactivating = new Event4Impl();
    protected final Event4Impl _created = new Event4Impl();
    protected final Event4Impl _activated = new Event4Impl();
    protected final Event4Impl _updated = new Event4Impl();
    protected final Event4Impl _deleted = new Event4Impl();
    protected final Event4Impl _deactivated = new Event4Impl();
    protected final Event4Impl _committing = new Event4Impl();
    protected final Event4Impl _committed = new CommittedEvent();
    protected final Event4Impl _instantiated = new Event4Impl();
    protected final Event4Impl _classRegistered = new Event4Impl();
    protected final Event4Impl _closing = new Event4Impl();
    protected final Event4Impl _opened = new Event4Impl();

    @Override
    public void queryOnFinished(final Transaction transaction, final Query query) {
        if (!this._queryFinished.hasListeners()) {
            return;
        }
        this.withExceptionHandling(new Runnable(){

            public void run() {
                EventRegistryImpl.this._queryFinished.trigger(new QueryEventArgs(transaction, query));
            }
        });
    }

    @Override
    public void queryOnStarted(final Transaction transaction, final Query query) {
        if (!this._queryStarted.hasListeners()) {
            return;
        }
        this.withExceptionHandling(new Runnable(){

            public void run() {
                EventRegistryImpl.this._queryStarted.trigger(new QueryEventArgs(transaction, query));
            }
        });
    }

    @Override
    public boolean objectCanNew(Transaction transaction, Object obj) {
        return this.triggerCancellableObjectEventArgsInCallback(transaction, this._creating, null, obj);
    }

    @Override
    public boolean objectCanActivate(Transaction transaction, Object obj) {
        return this.triggerCancellableObjectEventArgsInCallback(transaction, this._activating, null, obj);
    }

    @Override
    public boolean objectCanUpdate(Transaction transaction, ObjectInfo objectInfo) {
        return this.triggerCancellableObjectEventArgsInCallback(transaction, this._updating, objectInfo, objectInfo.getObject());
    }

    @Override
    public boolean objectCanDelete(Transaction transaction, ObjectInfo objectInfo) {
        return this.triggerCancellableObjectEventArgsInCallback(transaction, this._deleting, objectInfo, objectInfo.getObject());
    }

    @Override
    public boolean objectCanDeactivate(Transaction transaction, ObjectInfo objectInfo) {
        return this.triggerCancellableObjectEventArgsInCallback(transaction, this._deactivating, objectInfo, objectInfo.getObject());
    }

    @Override
    public void objectOnActivate(Transaction transaction, ObjectInfo obj) {
        this.triggerObjectInfoEventInCallback(transaction, this._activated, obj);
    }

    @Override
    public void objectOnNew(Transaction transaction, ObjectInfo obj) {
        this.triggerObjectInfoEventInCallback(transaction, this._created, obj);
    }

    @Override
    public void objectOnUpdate(Transaction transaction, ObjectInfo obj) {
        this.triggerObjectInfoEventInCallback(transaction, this._updated, obj);
    }

    @Override
    public void objectOnDelete(Transaction transaction, ObjectInfo obj) {
        this.triggerObjectInfoEventInCallback(transaction, this._deleted, obj);
    }

    @Override
    public void classOnRegistered(final ClassMetadata clazz) {
        if (!this._classRegistered.hasListeners()) {
            return;
        }
        this.withExceptionHandling(new Runnable(){

            public void run() {
                EventRegistryImpl.this._classRegistered.trigger(new ClassEventArgs(clazz));
            }
        });
    }

    @Override
    public void objectOnDeactivate(Transaction transaction, ObjectInfo obj) {
        this.triggerObjectInfoEventInCallback(transaction, this._deactivated, obj);
    }

    @Override
    public void objectOnInstantiate(Transaction transaction, ObjectInfo obj) {
        this.triggerObjectInfoEventInCallback(transaction, this._instantiated, obj);
    }

    @Override
    public void commitOnStarted(final Transaction transaction, final CallbackObjectInfoCollections objectInfoCollections) {
        if (!this._committing.hasListeners()) {
            return;
        }
        this.withExceptionHandlingInCallback(new Runnable(){

            public void run() {
                EventRegistryImpl.this._committing.trigger(new CommitEventArgs(transaction, objectInfoCollections, false));
            }
        });
    }

    @Override
    public void commitOnCompleted(final Transaction transaction, final CallbackObjectInfoCollections objectInfoCollections, final boolean isOwnCommit) {
        if (!this._committed.hasListeners()) {
            return;
        }
        this.withExceptionHandlingInCallback(new Runnable(){

            public void run() {
                EventRegistryImpl.this._committed.trigger(new CommitEventArgs(transaction, objectInfoCollections, isOwnCommit));
            }
        });
    }

    @Override
    public void closeOnStarted(final ObjectContainer container) {
        if (!this._closing.hasListeners()) {
            return;
        }
        this.withExceptionHandlingInCallback(new Runnable(){

            public void run() {
                EventRegistryImpl.this._closing.trigger(new ObjectContainerEventArgs(container));
            }
        });
    }

    @Override
    public void openOnFinished(final ObjectContainer container) {
        if (!this._opened.hasListeners()) {
            return;
        }
        this.withExceptionHandlingInCallback(new Runnable(){

            public void run() {
                EventRegistryImpl.this._opened.trigger(new ObjectContainerEventArgs(container));
            }
        });
    }

    public Event4 queryFinished() {
        return this._queryFinished;
    }

    public Event4 queryStarted() {
        return this._queryStarted;
    }

    public Event4 creating() {
        return this._creating;
    }

    public Event4 activating() {
        return this._activating;
    }

    public Event4 updating() {
        return this._updating;
    }

    public Event4 deleting() {
        return this._deleting;
    }

    @Override
    public Event4 deactivating() {
        return this._deactivating;
    }

    public Event4 created() {
        return this._created;
    }

    public Event4 activated() {
        return this._activated;
    }

    public Event4 updated() {
        return this._updated;
    }

    public Event4 deleted() {
        return this._deleted;
    }

    public Event4 deactivated() {
        return this._deactivated;
    }

    public Event4 committing() {
        return this._committing;
    }

    public Event4 committed() {
        return this._committed;
    }

    public Event4 classRegistered() {
        return this._classRegistered;
    }

    public Event4 instantiated() {
        return this._instantiated;
    }

    public Event4 closing() {
        return this._closing;
    }

    protected void onCommittedListenerAdded() {
    }

    @Override
    public boolean caresAboutCommitting() {
        return this._committing.hasListeners();
    }

    @Override
    public boolean caresAboutCommitted() {
        return this._committed.hasListeners();
    }

    @Override
    public boolean caresAboutDeleting() {
        return this._deleting.hasListeners();
    }

    @Override
    public boolean caresAboutDeleted() {
        return this._deleted.hasListeners();
    }

    boolean triggerCancellableObjectEventArgsInCallback(Transaction transaction, final Event4Impl<CancellableObjectEventArgs> e, ObjectInfo objectInfo, Object o) {
        if (!e.hasListeners()) {
            return true;
        }
        final CancellableObjectEventArgs args = new CancellableObjectEventArgs(transaction, objectInfo, o);
        this.withExceptionHandlingInCallback(new Runnable(){

            public void run() {
                e.trigger(args);
            }
        });
        return !args.isCancelled();
    }

    void triggerObjectInfoEventInCallback(final Transaction transaction, final Event4Impl<ObjectInfoEventArgs> e, final ObjectInfo o) {
        if (!e.hasListeners()) {
            return;
        }
        this.withExceptionHandlingInCallback(new Runnable(){

            public void run() {
                e.trigger(new ObjectInfoEventArgs(transaction, o));
            }
        });
    }

    private void withExceptionHandlingInCallback(Runnable runnable) {
        try {
            InCallback.run(runnable);
        }
        catch (Db4oException e) {
            throw e;
        }
        catch (Throwable x) {
            throw new EventException(x);
        }
    }

    private void withExceptionHandling(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Db4oException e) {
            throw e;
        }
        catch (Throwable x) {
            throw new EventException(x);
        }
    }

    @Override
    public Event4<ObjectContainerEventArgs> opened() {
        return this._opened;
    }

    protected class CommittedEvent
    extends Event4Impl {
        protected CommittedEvent() {
        }

        protected void onListenerAdded() {
            EventRegistryImpl.this.onCommittedListenerAdded();
        }
    }
}

