/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.collections;

import com.db4o.internal.Indexable4;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionLocal;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.handlers.IntHandler;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigSetBTreeManager {
    private static final TransactionLocal<Map<Integer, BTree>> _bTreesInTransaction = new TransactionLocal(){

        public Map<Integer, BTree> initialValueFor(Transaction transaction) {
            return new HashMap<Integer, BTree>();
        }
    };
    private final Transaction _transaction;

    BigSetBTreeManager(Transaction transaction) {
        this._transaction = transaction;
    }

    BTree produceBTree(int id) {
        BigSetBTreeManager.assertValidBTreeId(id);
        BTree bTree = this.existingBTreeInTransactionWith(id);
        if (null == bTree) {
            bTree = this.newBTreeWithId(id);
            this.registerBTreeInTransaction(bTree);
        }
        return bTree;
    }

    BTree newBTree() {
        BTree bTree = this.newBTreeWithId(0);
        bTree.write(this.systemTransaction());
        this.registerBTreeInTransaction(bTree);
        return bTree;
    }

    void ensureIsManaged(BTree tree) {
        this.registerBTreeInTransaction(tree);
    }

    private BTree newBTreeWithId(int id) {
        return BigSetBTreeManager.newBTreeWithId(id, this.systemTransaction());
    }

    private Transaction systemTransaction() {
        return this._transaction.systemTransaction();
    }

    private static BTree newBTreeWithId(int id, Transaction systemTransaction) {
        return new BTree(systemTransaction, id, (Indexable4)new IntHandler());
    }

    private static void assertValidBTreeId(int id) {
        if (id <= 0) {
            throw new IllegalArgumentException();
        }
    }

    private void registerBTreeInTransaction(BTree tree) {
        BigSetBTreeManager.assertValidBTreeId(tree.getID());
        BigSetBTreeManager.bTreesIn(this._transaction).put(tree.getID(), tree);
    }

    private BTree existingBTreeInTransactionWith(int id) {
        return BigSetBTreeManager.bTreesIn(this._transaction).get(id);
    }

    private static Map<Integer, BTree> bTreesIn(Transaction transaction) {
        return (Map)transaction.get(BigSetBTreeManager._bTreesInTransaction).value;
    }
}

