/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.caching;

import com.db4o.foundation.Function4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Procedure4;
import com.db4o.internal.caching.PurgeableCache4;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LRUIntCache<V>
implements PurgeableCache4<Integer, V> {
    private final Hashtable4 _slots;
    private final int _maxSize;
    private int _size;
    private Entry _first;
    private Entry _last;

    LRUIntCache(int size) {
        this._maxSize = size;
        this._slots = new Hashtable4(size);
    }

    @Override
    public V produce(Integer key, Function4<Integer, V> producer, Procedure4<V> finalizer) {
        int intKey = key;
        if (this._last == null) {
            V lastValue = producer.apply(key);
            if (lastValue == null) {
                return null;
            }
            this._size = 1;
            Entry<V> lastEntry = new Entry<V>(intKey, lastValue);
            this._slots.put(intKey, (Object)lastEntry);
            this._first = lastEntry;
            this._last = lastEntry;
            return lastValue;
        }
        Entry entry = (Entry)this._slots.get(intKey);
        if (entry == null) {
            V newValue;
            if (this._size >= this._maxSize) {
                Entry oldEntry = (Entry)this._slots.remove(this._last._key);
                this._last = oldEntry._previous;
                this._last._next = null;
                if (null != finalizer) {
                    finalizer.apply(oldEntry._value);
                }
                --this._size;
            }
            if ((newValue = producer.apply(key)) == null) {
                return null;
            }
            ++this._size;
            Entry<V> newEntry = new Entry<V>(intKey, newValue);
            this._slots.put(intKey, (Object)newEntry);
            this._first._previous = newEntry;
            newEntry._next = this._first;
            this._first = newEntry;
            return newValue;
        }
        if (this._first == entry) {
            return entry._value;
        }
        Entry previous = entry._previous;
        entry._previous = null;
        if (this._last == entry) {
            this._last = previous;
        }
        previous._next = entry._next;
        if (previous._next != null) {
            previous._next._previous = previous;
        }
        this._first._previous = entry;
        entry._next = this._first;
        this._first = entry;
        return entry._value;
    }

    @Override
    public Iterator iterator() {
        Iterator4 i = new Iterator4(){
            private Entry _cursor;
            private Entry _current;
            {
                this._cursor = LRUIntCache.this._first;
            }

            public Object current() {
                return this._current._value;
            }

            public boolean moveNext() {
                if (this._cursor == null) {
                    this._current = null;
                    return false;
                }
                this._current = this._cursor;
                this._cursor = this._cursor._next;
                return true;
            }

            public void reset() {
                this._cursor = LRUIntCache.this._first;
                this._current = null;
            }
        };
        return Iterators.platformIterator(i);
    }

    @Override
    public V purge(Integer key) {
        int intKey = key;
        Entry entry = (Entry)this._slots.remove(intKey);
        if (entry == null) {
            return null;
        }
        --this._size;
        if (this._first == entry) {
            this._first = entry._next;
        }
        if (this._last == entry) {
            this._last = entry._previous;
        }
        if (entry._previous != null) {
            entry._previous._next = entry._next;
        }
        if (entry._next != null) {
            entry._next._previous = entry._previous;
        }
        return entry._value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V> {
        final int _key;
        final V _value;
        Entry _previous;
        Entry _next;

        public Entry(int key, V value) {
            this._key = key;
            this._value = value;
        }

        public String toString() {
            return "" + this._key;
        }
    }
}

