/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.activation;

import com.db4o.ObjectContainer;
import com.db4o.TransactionListener;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.TransactionalEventArgs;
import com.db4o.foundation.IdentitySet4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionLocal;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationDepthProvider;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.DescendingActivationDepth;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.activation.FullActivationDepth;
import com.db4o.internal.activation.ModifiedObjectQuery;
import com.db4o.internal.activation.NonDescendingActivationDepth;
import com.db4o.internal.activation.TransparentActivationDepthProvider;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.ta.Activatable;
import com.db4o.ta.RollbackStrategy;

public class TransparentActivationDepthProviderImpl
implements ActivationDepthProvider,
TransparentActivationDepthProvider {
    private RollbackStrategy _rollbackStrategy;
    public boolean _transparentPersistenceIsEnabled;
    private final TransactionLocal<ObjectsModifiedInTransaction> _objectsModifiedInTransaction = new TransactionLocal<ObjectsModifiedInTransaction>(){

        @Override
        public ObjectsModifiedInTransaction initialValueFor(Transaction transaction) {
            final ObjectsModifiedInTransaction objectsModifiedInTransaction = new ObjectsModifiedInTransaction(transaction);
            transaction.addTransactionListener(new TransactionListener(){

                public void postRollback() {
                    objectsModifiedInTransaction.rollback(TransparentActivationDepthProviderImpl.this._rollbackStrategy);
                }

                public void preCommit() {
                    objectsModifiedInTransaction.flush();
                }
            });
            return objectsModifiedInTransaction;
        }
    };

    public ActivationDepth activationDepth(int depth, ActivationMode mode) {
        if (Integer.MAX_VALUE == depth) {
            return new FullActivationDepth(mode);
        }
        return new FixedActivationDepth(depth, mode);
    }

    public ActivationDepth activationDepthFor(ClassMetadata classMetadata, ActivationMode mode) {
        if (this.isTAAware(classMetadata)) {
            return new NonDescendingActivationDepth(mode);
        }
        if (mode.isPrefetch()) {
            return new FixedActivationDepth(1, mode);
        }
        return new DescendingActivationDepth(this, mode);
    }

    private boolean isTAAware(ClassMetadata classMetadata) {
        GenericReflector reflector = classMetadata.reflector();
        return reflector.forClass(Activatable.class).isAssignableFrom(classMetadata.classReflector());
    }

    public void enableTransparentPersistenceSupportFor(InternalObjectContainer container, RollbackStrategy rollbackStrategy) {
        this.flushOnQueryStarted(container);
        this._rollbackStrategy = rollbackStrategy;
        this._transparentPersistenceIsEnabled = true;
    }

    private void flushOnQueryStarted(InternalObjectContainer container) {
        EventRegistry registry = EventRegistryFactory.forObjectContainer(container);
        registry.queryStarted().addListener(new EventListener4(){

            public void onEvent(Event4 e, EventArgs args) {
                TransparentActivationDepthProviderImpl.this.objectsModifiedIn(TransparentActivationDepthProviderImpl.this.transactionFrom(args)).flush();
            }
        });
    }

    protected Transaction transactionFrom(EventArgs args) {
        return (Transaction)((TransactionalEventArgs)args).transaction();
    }

    public void addModified(Object object, Transaction transaction) {
        if (!this._transparentPersistenceIsEnabled) {
            return;
        }
        this.objectsModifiedIn(transaction).add(object);
    }

    public void removeModified(Object object, Transaction transaction) {
        if (!this._transparentPersistenceIsEnabled) {
            return;
        }
        this.objectsModifiedIn(transaction).remove(object);
    }

    private ObjectsModifiedInTransaction objectsModifiedIn(Transaction transaction) {
        return (ObjectsModifiedInTransaction)transaction.get(this._objectsModifiedInTransaction).value;
    }

    private static final class ObjectsModifiedInTransaction {
        private final IdentitySet4 _removedAfterModified = new IdentitySet4();
        private final IdentitySet4 _modified = new IdentitySet4();
        private final Transaction _transaction;

        public ObjectsModifiedInTransaction(Transaction transaction) {
            this._transaction = transaction;
        }

        public void add(Object object) {
            if (this.contains(object)) {
                return;
            }
            this._modified.add(object);
        }

        public void remove(Object object) {
            if (!this.contains(object)) {
                return;
            }
            this._modified.remove(object);
            this._removedAfterModified.add(object);
        }

        private boolean contains(Object object) {
            return this._modified.contains(object);
        }

        public void flush() {
            this.storeModifiedObjects();
            this._modified.clear();
        }

        private void storeModifiedObjects() {
            ObjectContainerBase container = this._transaction.container();
            container.storeAll(this._transaction, this._modified.valuesIterator(), container.updateDepthProvider().unspecified(new ModifiedObjectQuery(){

                public boolean isModified(Object obj) {
                    return ObjectsModifiedInTransaction.this.contains(obj);
                }
            }));
            this._transaction.processDeletes();
        }

        public void rollback(RollbackStrategy rollbackStrategy) {
            this.applyRollbackStrategy(rollbackStrategy);
            this._modified.clear();
        }

        private void applyRollbackStrategy(RollbackStrategy rollbackStrategy) {
            if (null == rollbackStrategy) {
                return;
            }
            this.applyRollbackStrategy(rollbackStrategy, this._modified.valuesIterator());
            this.applyRollbackStrategy(rollbackStrategy, this._removedAfterModified.valuesIterator());
        }

        private void applyRollbackStrategy(RollbackStrategy rollbackStrategy, Iterator4 values) {
            ObjectContainer objectContainer = this._transaction.objectContainer();
            while (values.moveNext()) {
                rollbackStrategy.rollback(objectContainer, values.current());
            }
        }
    }
}

