/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.SystemInfo;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.freespace.FreespaceManager;

public class SystemInfoFileImpl
implements SystemInfo {
    private LocalObjectContainer _file;

    public SystemInfoFileImpl(LocalObjectContainer file) {
        this._file = file;
    }

    public int freespaceEntryCount() {
        if (!this.hasFreespaceManager()) {
            return 0;
        }
        return this.freespaceManager().slotCount();
    }

    private boolean hasFreespaceManager() {
        return this.freespaceManager() != null;
    }

    private FreespaceManager freespaceManager() {
        return this._file.freespaceManager();
    }

    public long freespaceSize() {
        if (!this.hasFreespaceManager()) {
            return 0L;
        }
        long blockSize = this._file.blockSize();
        long blockedSize = this.freespaceManager().totalFreespace();
        return blockSize * blockedSize;
    }

    public long totalSize() {
        return this._file.fileLength();
    }
}

