/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oIOException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public final class StatefulBuffer
extends ByteArrayBuffer {
    Transaction _trans;
    private int _address;
    private int _addressOffset;
    private int _cascadeDelete;
    private int _id;
    private int _length;

    public StatefulBuffer(Transaction trans, int initialBufferSize) {
        this._trans = trans;
        this._length = initialBufferSize;
        this._buffer = new byte[this._length];
    }

    public StatefulBuffer(Transaction trans, int address, int length) {
        this(trans, length);
        this._address = address;
    }

    public StatefulBuffer(Transaction trans, Slot slot) {
        this(trans, slot.address(), slot.length());
    }

    public StatefulBuffer(Transaction trans, Pointer4 pointer) {
        this(trans, pointer._slot);
        this._id = pointer._id;
    }

    public void debugCheckBytes() {
    }

    public int getAddress() {
        return this._address;
    }

    public int getID() {
        return this._id;
    }

    public int length() {
        return this._length;
    }

    public ObjectContainerBase container() {
        return this._trans.container();
    }

    public LocalObjectContainer file() {
        return ((LocalTransaction)this._trans).localContainer();
    }

    public Transaction transaction() {
        return this._trans;
    }

    public byte[] getWrittenBytes() {
        byte[] bytes = new byte[this._offset];
        System.arraycopy(this._buffer, 0, bytes, 0, this._offset);
        return bytes;
    }

    public void read() throws Db4oIOException {
        this.container().readBytes(this._buffer, this._address, this._addressOffset, this._length);
    }

    public final StatefulBuffer readStatefulBuffer() {
        int length = this.readInt();
        if (length == 0) {
            return null;
        }
        StatefulBuffer yb = new StatefulBuffer(this._trans, length);
        System.arraycopy(this._buffer, this._offset, yb._buffer, 0, length);
        this._offset += length;
        return yb;
    }

    public void removeFirstBytes(int aLength) {
        this._length -= aLength;
        byte[] temp = new byte[this._length];
        System.arraycopy(this._buffer, aLength, temp, 0, this._length);
        this._buffer = temp;
        this._offset -= aLength;
        if (this._offset < 0) {
            this._offset = 0;
        }
    }

    public void address(int address) {
        this._address = address;
    }

    public void setID(int id) {
        this._id = id;
    }

    public void setTransaction(Transaction aTrans) {
        this._trans = aTrans;
    }

    public void useSlot(int adress) {
        this._address = adress;
        this._offset = 0;
    }

    public void useSlot(int address, int length) {
        this.useSlot(new Slot(address, length));
    }

    public void useSlot(Slot slot) {
        this._address = slot.address();
        this._offset = 0;
        if (slot.length() > this._buffer.length) {
            this._buffer = new byte[slot.length()];
        }
        this._length = slot.length();
    }

    public void useSlot(int id, int adress, int length) {
        this._id = id;
        this.useSlot(adress, length);
    }

    public void write() {
        this.file().writeBytes(this, this._address, this._addressOffset);
    }

    public void writeEncrypt() {
        this.file().writeEncrypt(this, this._address, this._addressOffset);
    }

    public ByteArrayBuffer readPayloadWriter(int offset, int length) {
        StatefulBuffer payLoad = new StatefulBuffer(this._trans, 0, length);
        System.arraycopy(this._buffer, offset, payLoad._buffer, 0, length);
        this.transferPayLoadAddress(payLoad, offset);
        return payLoad;
    }

    private void transferPayLoadAddress(StatefulBuffer toWriter, int offset) {
        int blockedOffset = offset / this.container().blockSize();
        toWriter._id = toWriter._address = this._address + blockedOffset;
        toWriter._addressOffset = this._addressOffset;
    }

    public void moveForward(int length) {
        this._addressOffset += length;
    }

    public String toString() {
        return "id " + this._id + " adr " + this._address + " len " + this._length;
    }

    public Slot slot() {
        return new Slot(this._address, this._length);
    }

    public Pointer4 pointer() {
        return new Pointer4(this._id, this.slot());
    }

    public int cascadeDeletes() {
        return this._cascadeDelete;
    }

    public void setCascadeDeletes(int depth) {
        this._cascadeDelete = depth;
    }
}

