/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.BlockConverter;
import com.db4o.internal.slots.Slot;

public final class BlockSizeBlockConverter
implements BlockConverter {
    private final int _blockSize;

    public BlockSizeBlockConverter(int blockSize) {
        this._blockSize = blockSize;
    }

    public int bytesToBlocks(long bytes) {
        return (int)((bytes + (long)this._blockSize - 1L) / (long)this._blockSize);
    }

    public int blockAlignedBytes(int bytes) {
        return this.bytesToBlocks(bytes) * this._blockSize;
    }

    public int blocksToBytes(int blocks) {
        return blocks * this._blockSize;
    }

    public Slot toBlockedLength(Slot slot) {
        return new Slot(slot.address(), this.bytesToBlocks(slot.length()));
    }

    public Slot toNonBlockedLength(Slot slot) {
        return new Slot(slot.address(), this.blocksToBytes(slot.length()));
    }
}

